/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure;

import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.psi.impl.CompositeRootCollection;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.SdkFinder;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexCompositeSdk
extends UserDataHolderBase
implements Sdk,
CompositeRootCollection {
    private static final String NAME_DELIM = "\t";
    private final String[] myNames;
    @Nullable
    private volatile Sdk[] mySdks;
    private static final OrderRootType[] RELEVANT_ROOT_TYPES = new OrderRootType[]{OrderRootType.CLASSES, OrderRootType.SOURCES};
    public static final String TYPE_ID = "__CompositeFlexSdk__";
    private static final SdkType TYPE = new SdkType("__CompositeFlexSdk__"){

        public String suggestHomePath() {
            return null;
        }

        public boolean isValidSdkHome(String path) {
            return false;
        }

        @NotNull
        public String suggestSdkName(String currentSdkName, String sdkHome) {
            String string = currentSdkName;
            if (string == null) {
                3.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
            if (sdkModel == null) {
                3.$$$reportNull$$$0(1);
            }
            if (sdkModificator == null) {
                3.$$$reportNull$$$0(2);
            }
            return null;
        }

        public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
            if (additionalData == null) {
                3.$$$reportNull$$$0(3);
            }
            if (additional == null) {
                3.$$$reportNull$$$0(4);
            }
        }

        @NotNull
        public String getPresentableName() {
            String string = this.getName();
            if (string == null) {
                3.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$3";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkModificator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalData";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additional";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestSdkName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$3";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createAdditionalDataConfigurable";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "saveAdditionalData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    public FlexCompositeSdk(String[] names) {
        this.myNames = names;
        this.init();
    }

    private void init() {
        Application application = ApplicationManager.getApplication();
        final Disposable d = Disposer.newDisposable();
        Disposer.register((Disposable)application, (Disposable)d);
        application.getMessageBus().connect(d).subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new ProjectJdkTable.Listener(){

            public void jdkAdded(@NotNull Sdk jdk) {
                if (jdk == null) {
                    1.$$$reportNull$$$0(0);
                }
                FlexCompositeSdk.this.resetSdks();
            }

            public void jdkRemoved(@NotNull Sdk jdk) {
                if (jdk == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (jdk == FlexCompositeSdk.this) {
                    Disposer.dispose((Disposable)d);
                }
                FlexCompositeSdk.this.resetSdks();
            }

            public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
                if (jdk == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (previousName == null) {
                    1.$$$reportNull$$$0(3);
                }
                FlexCompositeSdk.this.resetSdks();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jdk";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "previousName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkRemoved";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkNameChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public SdkType getSdkType() {
        SdkType sdkType = TYPE;
        if (sdkType == null) {
            FlexCompositeSdk.$$$reportNull$$$0(0);
        }
        return sdkType;
    }

    @NotNull
    public String getName() {
        String string = FlexCompositeSdk.getCompositeName(this.myNames);
        if (string == null) {
            FlexCompositeSdk.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String getCompositeName(String[] names) {
        return StringUtil.join((String[])names, (String)NAME_DELIM);
    }

    public String getVersionString() {
        return null;
    }

    public String getHomePath() {
        return null;
    }

    public VirtualFile getHomeDirectory() {
        return null;
    }

    @NotNull
    public RootProvider getRootProvider() {
        RootProvider rootProvider = new RootProvider(){

            @NotNull
            public String[] getUrls(@NotNull OrderRootType rootType) {
                if (rootType == null) {
                    2.$$$reportNull$$$0(0);
                }
                HashSet result = new HashSet();
                FlexCompositeSdk.this.forAllSdks((Processor<Sdk>)sdk -> {
                    if (rootType == null) {
                        2.$$$reportNull$$$0(13);
                    }
                    result.addAll(Arrays.asList(sdk.getRootProvider().getUrls(rootType)));
                    return true;
                });
                String[] stringArray = ArrayUtil.toStringArray(result);
                if (stringArray == null) {
                    2.$$$reportNull$$$0(1);
                }
                return stringArray;
            }

            @NotNull
            public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
                if (rootType == null) {
                    2.$$$reportNull$$$0(2);
                }
                HashSet result = new HashSet();
                FlexCompositeSdk.this.forAllSdks((Processor<Sdk>)sdk -> {
                    if (rootType == null) {
                        2.$$$reportNull$$$0(12);
                    }
                    result.addAll(Arrays.asList(sdk.getRootProvider().getFiles(rootType)));
                    return true;
                });
                VirtualFile[] virtualFileArray = result.toArray(VirtualFile.EMPTY_ARRAY);
                if (virtualFileArray == null) {
                    2.$$$reportNull$$$0(3);
                }
                return virtualFileArray;
            }

            public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
                if (listener == null) {
                    2.$$$reportNull$$$0(4);
                }
                FlexCompositeSdk.this.forAllSdks((Processor<Sdk>)sdk -> {
                    if (listener == null) {
                        2.$$$reportNull$$$0(11);
                    }
                    RootProvider rootProvider = sdk.getRootProvider();
                    rootProvider.removeRootSetChangedListener(listener);
                    rootProvider.addRootSetChangedListener(listener);
                    return true;
                });
            }

            public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener, @NotNull Disposable parentDisposable) {
                if (listener == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (parentDisposable == null) {
                    2.$$$reportNull$$$0(6);
                }
                FlexCompositeSdk.this.forAllSdks((Processor<Sdk>)sdk -> {
                    if (listener == null) {
                        2.$$$reportNull$$$0(9);
                    }
                    if (parentDisposable == null) {
                        2.$$$reportNull$$$0(10);
                    }
                    sdk.getRootProvider().addRootSetChangedListener(listener, parentDisposable);
                    return true;
                });
            }

            public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
                if (listener == null) {
                    2.$$$reportNull$$$0(7);
                }
                FlexCompositeSdk.this.forAllSdks((Processor<Sdk>)sdk -> {
                    if (listener == null) {
                        2.$$$reportNull$$$0(8);
                    }
                    sdk.getRootProvider().removeRootSetChangedListener(listener);
                    return true;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rootType";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$2";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listener";
                        break;
                    }
                    case 6: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parentDisposable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUrls";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFiles";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getUrls";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getFiles";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "addRootSetChangedListener";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "removeRootSetChangedListener";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$removeRootSetChangedListener$4";
                        break;
                    }
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$addRootSetChangedListener$3";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$addRootSetChangedListener$2";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$getFiles$1";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$getUrls$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (rootProvider == null) {
            FlexCompositeSdk.$$$reportNull$$$0(2);
        }
        return rootProvider;
    }

    private void forAllSdks(Processor<Sdk> processor) {
        Sdk[] sdks;
        for (Sdk sdk : sdks = this.getSdks()) {
            if (processor.process((Object)sdk)) continue;
            return;
        }
    }

    @NotNull
    public Sdk[] getSdks() {
        boolean cache;
        Object[] allSdks;
        if (this.mySdks != null) {
            if (this.mySdks == null) {
                FlexCompositeSdk.$$$reportNull$$$0(3);
            }
            return this.mySdks;
        }
        FlexProjectConfigurationEditor currentEditor = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getConfigEditor();
        if (currentEditor == null) {
            allSdks = ProjectJdkTable.getInstance().getAllJdks();
            cache = true;
        } else {
            Collection sdks = ProjectStructureConfigurable.getInstance((Project)currentEditor.getProject()).getProjectJdksModel().getProjectSdks().values();
            allSdks = sdks.toArray(new Sdk[0]);
            cache = false;
        }
        List result = ContainerUtil.findAll((Object[])allSdks, sdk -> ArrayUtil.contains((String)sdk.getName(), (String[])this.myNames));
        Sdk[] resultArray = result.toArray(new Sdk[0]);
        if (cache) {
            this.mySdks = resultArray;
        }
        if (resultArray == null) {
            FlexCompositeSdk.$$$reportNull$$$0(4);
        }
        return resultArray;
    }

    private void resetSdks() {
        this.mySdks = null;
    }

    @NotNull
    public SdkModificator getSdkModificator() {
        throw new UnsupportedOperationException();
    }

    public SdkAdditionalData getSdkAdditionalData() {
        return null;
    }

    @NotNull
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public VirtualFile[] getFiles(OrderRootType rootType, VirtualFile hint) {
        Sdk[] sdks;
        for (Sdk sdk : sdks = this.getSdks()) {
            for (OrderRootType t : RELEVANT_ROOT_TYPES) {
                VirtualFile[] files = sdk.getRootProvider().getFiles(t);
                if (!FlexCompositeSdk.isAncestorOf(files, hint)) continue;
                return t == rootType ? files : sdk.getRootProvider().getFiles(rootType);
            }
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    private static boolean isAncestorOf(VirtualFile[] ancestors, VirtualFile file) {
        VirtualFile fileInLocalFs = JarFileSystem.getInstance().getVirtualFileForJar(file);
        for (VirtualFile ancestor : ancestors) {
            if (VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file, (boolean)false)) {
                return true;
            }
            if (fileInLocalFs == null || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)fileInLocalFs, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public String getName(VirtualFile hint) {
        Sdk[] sdks = this.getSdks();
        if (sdks.length >= 2) {
            for (Sdk sdk : sdks) {
                for (OrderRootType t : RELEVANT_ROOT_TYPES) {
                    if (!FlexCompositeSdk.isAncestorOf(sdk.getRootProvider().getFiles(t), hint)) continue;
                    return sdk.getName();
                }
            }
        }
        return this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdks";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class SdkFinderImpl
    extends SdkFinder {
        public Sdk findSdk(String name, String sdkType) {
            if (TYPE.getName().equals(sdkType)) {
                List sdksNames = StringUtil.split((String)name, (String)FlexCompositeSdk.NAME_DELIM);
                return new FlexCompositeSdk(ArrayUtil.toStringArray((Collection)sdksNames));
            }
            return null;
        }
    }
}

