/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.flex.model.bc.CompilerOptionInfo;
import com.intellij.lang.javascript.flex.projectStructure.model.CompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.CompilerOptionsListener;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableCompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleOrProjectCompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CompilerOptionsImpl
implements ModifiableCompilerOptions,
ModuleOrProjectCompilerOptions {
    private final Project myProject;
    private final boolean myResetHighlightingOnCommit;
    private final EventDispatcher<CompilerOptionsListener> myDispatcher = EventDispatcher.create(CompilerOptionsListener.class);
    private final Map<String, String> myOptions = new THashMap();
    @NotNull
    private CompilerOptions.ResourceFilesMode myResourceFilesMode = CompilerOptions.ResourceFilesMode.All;
    @NotNull
    private String myFilesToIncludeInSWC = "";
    @NotNull
    private String myAdditionalConfigFilePath = "";
    @NotNull
    private String myAdditionalOptions = "";

    CompilerOptionsImpl() {
        this(null, false);
    }

    CompilerOptionsImpl(Project project, boolean resetHighlightingOnCommit) {
        this.myProject = project;
        this.myResetHighlightingOnCommit = resetHighlightingOnCommit;
    }

    @Override
    public void addOptionsListener(CompilerOptionsListener listener, Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @Override
    @Nullable
    public String getOption(@NotNull String name) {
        if (name == null) {
            CompilerOptionsImpl.$$$reportNull$$$0(0);
        }
        return this.myOptions.get(name);
    }

    @Override
    public Map<String, String> getAllOptions() {
        return Collections.unmodifiableMap(this.myOptions);
    }

    @Override
    public void setAllOptions(Map<String, String> newOptions) {
        this.myOptions.clear();
        this.myOptions.putAll(newOptions);
        if (this.myResetHighlightingOnCommit) {
            ApplicationManager.getApplication().runWriteAction(() -> FlexBuildConfigurationManagerImpl.resetHighlighting(this.myProject));
            ((CompilerOptionsListener)this.myDispatcher.getMulticaster()).optionsInTableChanged();
        }
    }

    @Override
    public void setResourceFilesMode(@NotNull CompilerOptions.ResourceFilesMode mode) {
        if (mode == null) {
            CompilerOptionsImpl.$$$reportNull$$$0(1);
        }
        this.myResourceFilesMode = mode;
    }

    @Override
    @NotNull
    public CompilerOptions.ResourceFilesMode getResourceFilesMode() {
        CompilerOptions.ResourceFilesMode resourceFilesMode = this.myResourceFilesMode;
        if (resourceFilesMode == null) {
            CompilerOptionsImpl.$$$reportNull$$$0(2);
        }
        return resourceFilesMode;
    }

    @Override
    public Collection<String> getFilesToIncludeInSWC() {
        if (this.myFilesToIncludeInSWC.isEmpty()) {
            return Collections.emptyList();
        }
        return StringUtil.split((String)this.myFilesToIncludeInSWC, (String)"\n");
    }

    @Override
    public void setFilesToIncludeInSWC(@NotNull Collection<String> filesToIncludeInSWC) {
        if (filesToIncludeInSWC == null) {
            CompilerOptionsImpl.$$$reportNull$$$0(3);
        }
        this.myFilesToIncludeInSWC = filesToIncludeInSWC.isEmpty() ? "" : StringUtil.join(filesToIncludeInSWC, (String)"\n");
    }

    @Override
    public void setAdditionalConfigFilePath(@NotNull String path) {
        if (path == null) {
            CompilerOptionsImpl.$$$reportNull$$$0(4);
        }
        this.myAdditionalConfigFilePath = path;
        if (this.myResetHighlightingOnCommit) assert (this.myAdditionalConfigFilePath.equals(path));
    }

    @Override
    @NotNull
    public String getAdditionalConfigFilePath() {
        String string = this.myAdditionalConfigFilePath;
        if (string == null) {
            CompilerOptionsImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public void setAdditionalOptions(@NotNull String options) {
        if (options == null) {
            CompilerOptionsImpl.$$$reportNull$$$0(6);
        }
        this.myAdditionalOptions = options;
        if (this.myResetHighlightingOnCommit) {
            ApplicationManager.getApplication().runWriteAction(() -> FlexBuildConfigurationManagerImpl.resetHighlighting(this.myProject));
            ((CompilerOptionsListener)this.myDispatcher.getMulticaster()).additionalOptionsChanged();
        }
    }

    @Override
    @NotNull
    public String getAdditionalOptions() {
        String string = this.myAdditionalOptions;
        if (string == null) {
            CompilerOptionsImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public CompilerOptionsImpl getCopy() {
        CompilerOptionsImpl copy = new CompilerOptionsImpl();
        this.applyTo(copy);
        return copy;
    }

    void applyTo(ModifiableCompilerOptions copy) {
        copy.setAllOptions(this.myOptions);
        copy.setResourceFilesMode(this.myResourceFilesMode);
        ((CompilerOptionsImpl)copy).myFilesToIncludeInSWC = this.myFilesToIncludeInSWC;
        copy.setAdditionalConfigFilePath(this.myAdditionalConfigFilePath);
        copy.setAdditionalOptions(this.myAdditionalOptions);
    }

    public State getState(@Nullable ComponentManager componentManager) {
        State state = new State();
        CompilerOptionsImpl.putOptionsCollapsingPaths(this.myOptions, state.options, componentManager);
        state.resourceFilesMode = this.myResourceFilesMode;
        state.filesToIncludeInSWC = FlexBuildConfigurationImpl.collapsePaths(componentManager, this.myFilesToIncludeInSWC);
        state.additionalConfigFilePath = this.myAdditionalConfigFilePath;
        state.additionalOptions = this.myAdditionalOptions;
        return state;
    }

    private static void putOptionsCollapsingPaths(Map<String, String> fromMap, Map<String, String> toMap, @Nullable ComponentManager componentManager) {
        for (Map.Entry<String, String> entry : fromMap.entrySet()) {
            toMap.put(entry.getKey(), FlexBuildConfigurationImpl.collapsePaths(componentManager, entry.getValue()));
        }
    }

    public void loadState(State state) {
        this.myOptions.clear();
        for (Map.Entry<String, String> entry : state.options.entrySet()) {
            if (!CompilerOptionInfo.idExists((String)entry.getKey())) continue;
            this.myOptions.put(entry.getKey(), entry.getValue());
        }
        this.myResourceFilesMode = state.resourceFilesMode;
        this.myFilesToIncludeInSWC = state.filesToIncludeInSWC;
        this.myAdditionalConfigFilePath = state.additionalConfigFilePath;
        this.myAdditionalOptions = state.additionalOptions;
    }

    public boolean isEqual(CompilerOptionsImpl other) {
        return this.myOptions.equals(other.myOptions) && this.myResourceFilesMode == other.myResourceFilesMode && this.myFilesToIncludeInSWC.equals(other.myFilesToIncludeInSWC) && this.myAdditionalConfigFilePath.equals(other.myAdditionalConfigFilePath) && this.myAdditionalOptions.equals(other.myAdditionalOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/projectStructure/model/impl/CompilerOptionsImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToIncludeInSWC";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/projectStructure/model/impl/CompilerOptionsImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceFilesMode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalConfigFilePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOption";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setResourceFilesMode";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFilesToIncludeInSWC";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalConfigFilePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="compiler-options")
    public static class State {
        @Property(surroundWithTag=false)
        @MapAnnotation
        public Map<String, String> options = new THashMap();
        public CompilerOptions.ResourceFilesMode resourceFilesMode = CompilerOptions.ResourceFilesMode.All;
        public String filesToIncludeInSWC = "";
        public String additionalConfigFilePath = "";
        public String additionalOptions = "";
    }
}

