/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.flex.model.bc.ComponentSet;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencies;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SdkEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.BuildConfigurationEntryImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.EntryState;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.ModuleLibraryEntryImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.SdkEntryImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.SharedLibraryEntryImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.StatefulDependencyEntry;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DependenciesImpl
implements ModifiableDependencies {
    private static final LinkageType DEFAULT_FRAMEWORK_LINKAGE = LinkageType.Default;
    @NotNull
    private String myTargetPlayer = "";
    @NotNull
    private ComponentSet myComponentSet = ComponentSet.SparkAndMx;
    @NotNull
    private LinkageType myFrameworkLinkage = DEFAULT_FRAMEWORK_LINKAGE;
    private final List<ModifiableDependencyEntry> myEntries = new ArrayList<ModifiableDependencyEntry>();
    @Nullable
    private SdkEntryImpl mySdk;

    DependenciesImpl() {
    }

    @Override
    @Nullable
    public SdkEntry getSdkEntry() {
        return this.mySdk;
    }

    @Override
    public void setSdkEntry(@Nullable SdkEntry sdk) {
        this.mySdk = (SdkEntryImpl)sdk;
    }

    @Override
    public DependencyEntry[] getEntries() {
        return this.myEntries.toArray(new DependencyEntry[0]);
    }

    @Override
    public List<ModifiableDependencyEntry> getModifiableEntries() {
        return this.myEntries;
    }

    @Override
    @NotNull
    public LinkageType getFrameworkLinkage() {
        LinkageType linkageType = this.myFrameworkLinkage;
        if (linkageType == null) {
            DependenciesImpl.$$$reportNull$$$0(0);
        }
        return linkageType;
    }

    @Override
    public void setFrameworkLinkage(@NotNull LinkageType frameworkLinkage) {
        if (frameworkLinkage == null) {
            DependenciesImpl.$$$reportNull$$$0(1);
        }
        this.myFrameworkLinkage = frameworkLinkage;
    }

    @Override
    @NotNull
    public String getTargetPlayer() {
        String string = this.myTargetPlayer;
        if (string == null) {
            DependenciesImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void setTargetPlayer(@NotNull String targetPlayer) {
        if (targetPlayer == null) {
            DependenciesImpl.$$$reportNull$$$0(3);
        }
        this.myTargetPlayer = targetPlayer;
    }

    @Override
    public void setComponentSet(@NotNull ComponentSet componentSet) {
        if (componentSet == null) {
            DependenciesImpl.$$$reportNull$$$0(4);
        }
        this.myComponentSet = componentSet;
    }

    @Override
    @NotNull
    public ComponentSet getComponentSet() {
        ComponentSet componentSet = this.myComponentSet;
        if (componentSet == null) {
            DependenciesImpl.$$$reportNull$$$0(5);
        }
        return componentSet;
    }

    public DependenciesImpl getCopy() {
        DependenciesImpl copy = new DependenciesImpl();
        this.applyTo(copy);
        return copy;
    }

    void applyTo(DependenciesImpl copy) {
        copy.myTargetPlayer = this.myTargetPlayer;
        copy.myComponentSet = this.myComponentSet;
        copy.myFrameworkLinkage = this.myFrameworkLinkage;
        copy.myEntries.clear();
        copy.myEntries.addAll(ContainerUtil.map(this.myEntries, e -> {
            if (e instanceof ModuleLibraryEntryImpl) {
                return ((ModuleLibraryEntryImpl)e).getCopy();
            }
            if (e instanceof SharedLibraryEntryImpl) {
                return ((SharedLibraryEntryImpl)e).getCopy();
            }
            if (e instanceof BuildConfigurationEntryImpl) {
                return ((BuildConfigurationEntryImpl)e).getCopy();
            }
            throw new RuntimeException("Unexpected entry type: " + e);
        }));
        copy.mySdk = this.mySdk != null ? this.mySdk.getCopy() : null;
    }

    public boolean isEqual(DependenciesImpl other) {
        if (!other.myTargetPlayer.equals(this.myTargetPlayer)) {
            return false;
        }
        if (other.myComponentSet != this.myComponentSet) {
            return false;
        }
        if (other.myFrameworkLinkage != this.myFrameworkLinkage) {
            return false;
        }
        if (this.myEntries.size() != other.myEntries.size()) {
            return false;
        }
        if (this.mySdk != null ? other.mySdk == null || !this.mySdk.isEqual(other.mySdk) : other.mySdk != null) {
            return false;
        }
        for (int i = 0; i < this.myEntries.size(); ++i) {
            if (this.myEntries.get(i).isEqual(other.myEntries.get(i))) continue;
            return false;
        }
        return true;
    }

    public State getState() {
        State state = new State();
        state.TARGET_PLAYER = this.myTargetPlayer;
        state.COMPONENT_SET = this.myComponentSet;
        state.FRAMEWORK_LINKAGE = this.myFrameworkLinkage.getSerializedText();
        state.ENTRIES = (EntryState[])ContainerUtil.mapNotNull((Object[])this.myEntries.toArray(new ModifiableDependencyEntry[0]), entry -> {
            if (entry instanceof StatefulDependencyEntry) {
                return ((StatefulDependencyEntry)((Object)entry)).getState();
            }
            throw new RuntimeException("Unexpected entry type: " + entry);
        }, (Object[])new EntryState[0]);
        if (this.mySdk != null) {
            state.SDK = this.mySdk.getState();
        }
        return state;
    }

    public void loadState(@NotNull State state, Project project) {
        if (state == null) {
            DependenciesImpl.$$$reportNull$$$0(6);
        }
        this.myTargetPlayer = state.TARGET_PLAYER;
        this.myComponentSet = state.COMPONENT_SET;
        this.myFrameworkLinkage = LinkageType.valueOf((String)state.FRAMEWORK_LINKAGE, (LinkageType)DEFAULT_FRAMEWORK_LINKAGE);
        ModulePointerManager pointerManager = ModulePointerManager.getInstance((Project)project);
        this.myEntries.clear();
        for (EntryState info : state.ENTRIES) {
            StatefulDependencyEntry libraryEntry;
            if (info.LIBRARY_ID != null) {
                libraryEntry = new ModuleLibraryEntryImpl(info.LIBRARY_ID);
                ((ModuleLibraryEntryImpl)libraryEntry).getDependencyType().loadState(info.DEPENDENCY_TYPE);
                this.myEntries.add((ModifiableDependencyEntry)((Object)libraryEntry));
                continue;
            }
            if (info.LIBRARY_NAME != null) {
                libraryEntry = new SharedLibraryEntryImpl(info.LIBRARY_NAME, info.LIBRARY_LEVEL);
                ((SharedLibraryEntryImpl)libraryEntry).getDependencyType().loadState(info.DEPENDENCY_TYPE);
                this.myEntries.add((ModifiableDependencyEntry)((Object)libraryEntry));
                continue;
            }
            if (info.BC_NAME != null) {
                BuildConfigurationEntryImpl bcEntry = new BuildConfigurationEntryImpl(pointerManager.create(info.MODULE_NAME), info.BC_NAME);
                bcEntry.getDependencyType().loadState(info.DEPENDENCY_TYPE);
                this.myEntries.add(bcEntry);
                continue;
            }
            throw new RuntimeException("unknown entry");
        }
        SdkEntryImpl sdkEntryImpl = this.mySdk = state.SDK != null ? new SdkEntryImpl(state.SDK) : null;
        if (this.mySdk != null && this.mySdk.getName().isEmpty()) {
            this.mySdk = null;
        }
    }

    static /* synthetic */ LinkageType access$000() {
        return DEFAULT_FRAMEWORK_LINKAGE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/projectStructure/model/impl/DependenciesImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkLinkage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPlayer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkLinkage";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/projectStructure/model/impl/DependenciesImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlayer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentSet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setFrameworkLinkage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTargetPlayer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setComponentSet";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="dependencies")
    public static class State {
        @Attribute(value="target-player")
        public String TARGET_PLAYER = "";
        @Attribute(value="component-set")
        public ComponentSet COMPONENT_SET = ComponentSet.SparkAndMx;
        @Attribute(value="framework-linkage")
        public String FRAMEWORK_LINKAGE = DependenciesImpl.access$000().getSerializedText();
        @XCollection(propertyElementName="entries")
        public EntryState[] ENTRIES = new EntryState[0];
        @Property(surroundWithTag=false)
        public SdkEntryImpl.State SDK;
    }
}

