/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.ProjectTopics;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.ui.ChooseActiveBuildConfigurationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.ui.ClickListener;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActiveBuildConfigurationWidget {
    private final Project myProject;
    @Nullable
    private MyWidget myWidget;

    public ActiveBuildConfigurationWidget(Project project) {
        this.myProject = project;
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    1.$$$reportNull$$$0(1);
                }
                ActiveBuildConfigurationWidget.this.showOrHideWidget(false);
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (module == null) {
                    1.$$$reportNull$$$0(3);
                }
                ActiveBuildConfigurationWidget.this.showOrHideWidget(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/flex/projectStructure/ui/ActiveBuildConfigurationWidget$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.showOrHideWidget(false);
    }

    public void destroy() {
        this.showOrHideWidget(true);
    }

    private void showOrHideWidget(boolean forceRemove) {
        boolean showWidget;
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (statusBar == null) {
            return;
        }
        boolean bl = showWidget = !forceRemove && this.shouldShowWidget();
        if (showWidget) {
            if (this.myWidget == null) {
                this.myWidget = new MyWidget(this.myProject);
                statusBar.addWidget((StatusBarWidget)this.myWidget, MyWidget.getAnchor());
            }
        } else if (this.myWidget != null) {
            statusBar.removeWidget(this.myWidget.ID());
            this.myWidget = null;
        }
    }

    private boolean shouldShowWidget() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (ModuleType.get((Module)module) != FlexModuleType.getInstance()) continue;
            return true;
        }
        return false;
    }

    private static class MyWidget
    extends EditorBasedWidget
    implements CustomStatusBarWidget,
    StatusBarWidget.Multiframe {
        private final JLabel myEnabledLabel;
        private final JLabel myDisabledLabel;
        private final JPanel myPanel;
        private final JLabel myUpDownLabel;

        private MyWidget(@NotNull Project project) {
            if (project == null) {
                MyWidget.$$$reportNull$$$0(0);
            }
            super(project);
            this.myEnabledLabel = new JLabel();
            this.myDisabledLabel = new JLabel(FlexBundle.message("active.bc.widget.empty.text", new Object[0]));
            this.myUpDownLabel = new JLabel(AllIcons.Ide.Statusbar_arrows);
            Disposer.register((Disposable)project, (Disposable)this);
            project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                public void rootsChanged(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.update();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/flex/projectStructure/ui/ActiveBuildConfigurationWidget$MyWidget$1", "rootsChanged"));
                }
            });
            this.myEnabledLabel.setFont(SystemInfo.isMac ? UIUtil.getLabelFont().deriveFont(11.0f) : UIUtil.getLabelFont());
            this.myEnabledLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.myDisabledLabel.setHorizontalAlignment(0);
            this.myDisabledLabel.setToolTipText(FlexBundle.message("active.bc.widget.empty.tooltip", new Object[0]));
            this.myDisabledLabel.setForeground(UIUtil.getInactiveTextColor());
            this.myDisabledLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.myPanel = new JPanel(new GridBagLayout()){

                @Override
                public Dimension getPreferredSize() {
                    int max = this.getFontMetrics(this.getFont()).stringWidth(myDisabledLabel.getText());
                    return new Dimension(20 + max, this.getMinimumSize().height);
                }
            };
            this.myPanel.setOpaque(false);
            this.myPanel.setCursor(Cursor.getPredefinedCursor(12));
            this.myPanel.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
            GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0);
            this.myPanel.add((Component)this.myEnabledLabel, c);
            ++c.gridx;
            c.anchor = 10;
            this.myPanel.add((Component)this.myDisabledLabel, c);
            ++c.gridx;
            c.weightx = 0.0;
            this.myPanel.add((Component)this.myUpDownLabel, c);
            ClickListener listener = new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    Module module;
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if ((module = this.findCurrentFlexModule()) != null) {
                        ListPopup popup = ChooseActiveBuildConfigurationAction.createPopup(module);
                        Dimension dimension = popup.getContent().getPreferredSize();
                        Point at = new Point(0, -dimension.height);
                        popup.show(new RelativePoint(e.getComponent(), at));
                    } else {
                        HintHint hintHint = new HintHint(e).setShowImmediately(true).setAwtTooltip(true);
                        new LightweightHint((JComponent)new JLabel(myDisabledLabel.getToolTipText())).show((JComponent)myPanel, e.getX(), e.getY(), (JComponent)myPanel, hintHint);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/flex/projectStructure/ui/ActiveBuildConfigurationWidget$MyWidget$3", "onClick"));
                }
            };
            listener.installOn((Component)this.myEnabledLabel);
            listener.installOn((Component)this.myDisabledLabel);
            listener.installOn((Component)this.myPanel);
            listener.installOn((Component)this.myUpDownLabel);
            this.update();
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        @Nullable
        public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
            if (type == null) {
                MyWidget.$$$reportNull$$$0(1);
            }
            return null;
        }

        private void update() {
            if (this.myStatusBar == null) {
                this.showDisabled();
                return;
            }
            Module module = this.findCurrentFlexModule();
            if (module == null) {
                this.showDisabled();
                return;
            }
            FlexBuildConfiguration bc = FlexBuildConfigurationManager.getInstance(module).getActiveConfiguration();
            this.myEnabledLabel.setText(BCUtils.renderBuildConfiguration(bc, null, false).toString());
            this.myEnabledLabel.setToolTipText(FlexBundle.message("active.bc.widget.tooltip", bc.getName(), module.getName()));
            this.myPanel.setToolTipText(this.myEnabledLabel.getToolTipText());
            this.myEnabledLabel.setIcon(bc.getIcon());
            this.myEnabledLabel.setVisible(true);
            this.myDisabledLabel.setVisible(false);
            this.myUpDownLabel.setVisible(true);
            this.myStatusBar.updateWidget(this.ID());
        }

        private void showDisabled() {
            this.myEnabledLabel.setVisible(false);
            this.myUpDownLabel.setVisible(false);
            this.myDisabledLabel.setVisible(true);
            this.myPanel.setToolTipText(this.myDisabledLabel.getToolTipText());
        }

        public StatusBarWidget copy() {
            return new MyWidget(this.getProject());
        }

        @NotNull
        public String ID() {
            if ("ActiveFlexBuildConfiguration" == null) {
                MyWidget.$$$reportNull$$$0(2);
            }
            return "ActiveFlexBuildConfiguration";
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                MyWidget.$$$reportNull$$$0(3);
            }
            this.update();
        }

        @Nullable
        private Module findCurrentFlexModule() {
            VirtualFile selectedFile = this.getSelectedFile();
            if (selectedFile == null) {
                return null;
            }
            Module module = ModuleUtil.findModuleForFile((VirtualFile)selectedFile, (Project)this.getProject());
            if (module == null || FlexModuleType.getInstance() != ModuleType.get((Module)module)) {
                return null;
            }
            return module;
        }

        public static String getAnchor() {
            return "after " + (SystemInfo.isMac ? "Encoding" : "InsertOverwrite");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/flex/projectStructure/ui/ActiveBuildConfigurationWidget$MyWidget";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/flex/projectStructure/ui/ActiveBuildConfigurationWidget$MyWidget";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ID";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "selectionChanged";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

