/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.compiler.options.CompilerUIConfigurable;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.CompilerOptionInfo;
import com.intellij.flex.model.bc.ValueSource;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.projectStructure.FlexProjectLevelCompilerOptionsHolder;
import com.intellij.lang.javascript.flex.projectStructure.model.CompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.CompilerOptionsListener;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableCompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleOrProjectCompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.ui.DependenciesConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.LocalesDialog;
import com.intellij.lang.javascript.flex.projectStructure.ui.RepeatableValueDialog;
import com.intellij.lang.javascript.flex.sdk.FlexSdkType2;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerOptionsConfigurable
extends NamedConfigurable<CompilerOptions>
implements Place.Navigator {
    public static final String TAB_NAME = FlexBundle.message("bc.tab.compiler.options.display.name", new Object[0]);
    public static final String CONDITIONAL_COMPILER_DEFINITION_NAME = "FlexCompilerOptions.ConditionalCompilerDefinitionName";
    private JPanel myMainPanel;
    private TreeTable myTreeTable;
    private NonFocusableCheckBox myShowAllOptionsCheckBox;
    private JLabel myInheritProjectDefaultsLegend;
    private JLabel myInheritModuleDefaultsLegend;
    private JButton myProjectDefaultsButton;
    private JButton myModuleDefaultsButton;
    private JPanel myResourcesPanel;
    private JCheckBox myCopyResourceFilesCheckBox;
    private JRadioButton myCopyAllResourcesRadioButton;
    private JRadioButton myRespectResourcePatternsRadioButton;
    private HoverHyperlinkLabel myResourcePatternsHyperlink;
    private JPanel myIncludeInSWCPanel;
    private TextFieldWithBrowseButton myIncludeInSWCField;
    private Collection<String> myFilesToIncludeInSWC;
    private JLabel myConfigFileLabel;
    private TextFieldWithBrowseButton myConfigFileTextWithBrowse;
    private JLabel myInheritedOptionsLabel;
    private JTextField myInheritedOptionsField;
    private JLabel myAdditionalOptionsLabel;
    private RawCommandLineEditor myAdditionalOptionsField;
    private JLabel myNoteLabel;
    private final Mode myMode;
    private final Module myModule;
    private final BuildConfigurationNature myNature;
    private final DependenciesConfigurable myDependenciesConfigurable;
    private final Project myProject;
    private final String myName;
    private final FlexBuildConfigurationManager myBCManager;
    private final FlexProjectLevelCompilerOptionsHolder myProjectLevelOptionsHolder;
    private final ModifiableCompilerOptions myModel;
    private final Map<String, String> myCurrentOptions;
    private boolean myMapModified;
    private final EventDispatcher<UserActivityListener> myUserActivityDispatcher;
    private boolean myFreeze;
    private final Collection<OptionsListener> myListeners;
    private final Disposable myDisposable;
    private static final String UNKNOWN_SDK_VERSION = "100";

    public CompilerOptionsConfigurable(Module module, BuildConfigurationNature nature, DependenciesConfigurable dependenciesConfigurable, ModifiableCompilerOptions model) {
        this(Mode.BC, module, module.getProject(), nature, dependenciesConfigurable, model);
        dependenciesConfigurable.addSdkChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CompilerOptionsConfigurable.this.updateTreeTable();
            }
        });
    }

    private CompilerOptionsConfigurable(Mode mode, final Module module, final Project project, BuildConfigurationNature nature, DependenciesConfigurable dependenciesConfigurable, ModifiableCompilerOptions model) {
        this.$$$setupUI$$$();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDisposable = Disposer.newDisposable();
        this.myMode = mode;
        this.myModule = module;
        this.myProject = project;
        this.myNature = nature;
        this.myDependenciesConfigurable = dependenciesConfigurable;
        this.myName = this.myMode == Mode.BC ? TAB_NAME : (this.myMode == Mode.Module ? FlexBundle.message("default.compiler.options.for.module.title", module.getName()) : FlexBundle.message("default.compiler.options.for.project.title", project.getName()));
        this.myBCManager = this.myMode == Mode.BC ? FlexBuildConfigurationManager.getInstance(module) : null;
        this.myProjectLevelOptionsHolder = FlexProjectLevelCompilerOptionsHolder.getInstance(project);
        this.myModel = model;
        this.myCurrentOptions = new THashMap();
        this.myFilesToIncludeInSWC = Collections.emptyList();
        this.myShowAllOptionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompilerOptionsConfigurable.this.updateTreeTable();
            }
        });
        this.myInheritModuleDefaultsLegend.setVisible(this.myMode == Mode.BC);
        this.myInheritProjectDefaultsLegend.setVisible(this.myMode == Mode.BC || this.myMode == Mode.Module);
        this.myResourcesPanel.setVisible(this.myMode == Mode.BC && BCUtils.canHaveResourceFiles(this.myNature));
        this.myCopyResourceFilesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompilerOptionsConfigurable.this.updateResourcesControls();
            }
        });
        this.myResourcePatternsHyperlink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new CompilerUIConfigurable(module.getProject()));
            }
        });
        this.myIncludeInSWCPanel.setVisible(this.myMode == Mode.BC && this.myNature.isLib());
        this.myIncludeInSWCField.getTextField().setEditable(false);
        this.myIncludeInSWCField.setButtonIcon(PlatformIcons.OPEN_EDIT_DIALOG_ICON);
        this.myIncludeInSWCField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<StringBuilder> value = new ArrayList<StringBuilder>();
                for (String path : CompilerOptionsConfigurable.this.myFilesToIncludeInSWC) {
                    value.add(new StringBuilder(path));
                }
                RepeatableValueDialog dialog = new RepeatableValueDialog(module.getProject(), FlexBundle.message("items.to.include.in.swc.dialog.title", new Object[0]), value, CompilerOptionInfo.INCLUDE_FILE_INFO_FOR_UI);
                if (dialog.showAndGet()) {
                    List newValue = dialog.getCurrentList();
                    CompilerOptionsConfigurable.this.myFilesToIncludeInSWC = new ArrayList(newValue.size());
                    for (StringBuilder path : newValue) {
                        CompilerOptionsConfigurable.this.myFilesToIncludeInSWC.add(path.toString());
                    }
                    CompilerOptionsConfigurable.this.updateFilesToIncludeInSWCText();
                }
            }
        });
        this.initButtonsAndAdditionalOptions();
        this.myShowAllOptionsCheckBox.setSelected(true);
        this.myShowAllOptionsCheckBox.setVisible(false);
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.register((Component)this.myMainPanel);
        this.myUserActivityDispatcher = EventDispatcher.create(UserActivityListener.class);
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                if (CompilerOptionsConfigurable.this.myFreeze) {
                    return;
                }
                ((UserActivityListener)CompilerOptionsConfigurable.this.myUserActivityDispatcher.getMulticaster()).stateChanged();
            }
        }, this.myDisposable);
    }

    public void addUserActivityListener(UserActivityListener listener, Disposable disposable) {
        this.myUserActivityDispatcher.addListener((EventListener)listener, disposable);
    }

    public void removeUserActivityListeners() {
        for (UserActivityListener listener : this.myUserActivityDispatcher.getListeners()) {
            this.myUserActivityDispatcher.removeListener((EventListener)listener);
        }
    }

    private void updateFilesToIncludeInSWCText() {
        String s = StringUtil.join(this.myFilesToIncludeInSWC, path -> PathUtil.getFileName((String)path), (String)", ");
        this.myIncludeInSWCField.setText(s);
    }

    private void initButtonsAndAdditionalOptions() {
        if (this.myMode == Mode.BC || this.myMode == Mode.Module) {
            CompilerOptionsListener optionsListener = new CompilerOptionsListener(){

                @Override
                public void optionsInTableChanged() {
                    CompilerOptionsConfigurable.this.updateTreeTable();
                }

                @Override
                public void additionalOptionsChanged() {
                    CompilerOptionsConfigurable.this.updateAdditionalOptionsControls();
                }
            };
            if (this.myMode == Mode.BC) {
                this.myBCManager.getModuleLevelCompilerOptions().addOptionsListener(optionsListener, this.myDisposable);
            }
            this.myProjectLevelOptionsHolder.getProjectLevelCompilerOptions().addOptionsListener(optionsListener, this.myDisposable);
        }
        ActionListener projectDefaultsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleOrProjectCompilerOptions compilerOptions = CompilerOptionsConfigurable.this.myProjectLevelOptionsHolder.getProjectLevelCompilerOptions();
                CompilerOptionsConfigurable configurable = new CompilerOptionsConfigurable(Mode.Project, null, CompilerOptionsConfigurable.this.myProject, CompilerOptionsConfigurable.this.myNature, CompilerOptionsConfigurable.this.myDependenciesConfigurable, compilerOptions);
                ShowSettingsUtil.getInstance().editConfigurable(CompilerOptionsConfigurable.this.myProject, (Configurable)configurable);
            }
        };
        ActionListener moduleDefaultsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleOrProjectCompilerOptions compilerOptions = CompilerOptionsConfigurable.this.myBCManager.getModuleLevelCompilerOptions();
                CompilerOptionsConfigurable configurable = new CompilerOptionsConfigurable(Mode.Module, CompilerOptionsConfigurable.this.myModule, CompilerOptionsConfigurable.this.myProject, CompilerOptionsConfigurable.this.myNature, CompilerOptionsConfigurable.this.myDependenciesConfigurable, compilerOptions);
                ShowSettingsUtil.getInstance().editConfigurable(CompilerOptionsConfigurable.this.myProject, (Configurable)configurable);
            }
        };
        this.myConfigFileTextWithBrowse.addBrowseFolderListener(null, null, this.myProject, FlexUtils.createFileChooserDescriptor("xml"));
        this.myConfigFileTextWithBrowse.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                CompilerOptionsConfigurable.this.updateAdditionalOptionsControls();
                CompilerOptionsConfigurable.this.fireConfigFileChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/flex/projectStructure/ui/CompilerOptionsConfigurable$10", "textChanged"));
            }
        });
        this.myConfigFileLabel.setVisible(this.myMode == Mode.BC);
        this.myConfigFileTextWithBrowse.setVisible(this.myMode == Mode.BC);
        this.myInheritedOptionsLabel.setVisible(this.myMode == Mode.BC || this.myMode == Mode.Module);
        this.myInheritedOptionsField.setVisible(this.myMode == Mode.BC || this.myMode == Mode.Module);
        String labelText = this.myMode == Mode.BC ? "Additional compiler options:" : (this.myMode == Mode.Module ? "Default options for module:" : "Default options for project:");
        this.myAdditionalOptionsLabel.setText(labelText);
        this.myAdditionalOptionsField.setDialogCaption(StringUtil.capitalizeWords((String)labelText, (boolean)true));
        this.myAdditionalOptionsField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    11.$$$reportNull$$$0(0);
                }
                CompilerOptionsConfigurable.this.updateAdditionalOptionsControls();
                CompilerOptionsConfigurable.this.fireAdditionalOptionsChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/flex/projectStructure/ui/CompilerOptionsConfigurable$11", "textChanged"));
            }
        });
        this.myNoteLabel.setIcon(UIUtil.getBalloonInformationIcon());
        this.myProjectDefaultsButton.addActionListener(projectDefaultsListener);
        this.myProjectDefaultsButton.setVisible(this.myMode == Mode.BC || this.myMode == Mode.Module);
        this.myModuleDefaultsButton.addActionListener(moduleDefaultsListener);
        this.myModuleDefaultsButton.setVisible(this.myMode == Mode.BC);
    }

    public void addAdditionalOptionsListener(OptionsListener listener) {
        this.myListeners.add(listener);
    }

    private void fireConfigFileChanged() {
        for (OptionsListener listener : this.myListeners) {
            listener.configFileChanged(FileUtil.toSystemIndependentName((String)this.myConfigFileTextWithBrowse.getText().trim()));
        }
    }

    private void fireAdditionalOptionsChanged() {
        for (OptionsListener listener : this.myListeners) {
            listener.additionalOptionsChanged(this.myAdditionalOptionsField.getText().trim());
        }
    }

    @Nls
    public String getDisplayName() {
        return this.myName;
    }

    public void setDisplayName(String name) {
    }

    public String getBannerSlogan() {
        return this.getDisplayName();
    }

    public CompilerOptions getEditableObject() {
        return this.myModel;
    }

    public String getHelpTopic() {
        return "BuildConfigurationPage.CompilerOptions";
    }

    public JComponent createOptionsPanel() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        if (this.myMapModified) {
            return true;
        }
        if (this.myModel.getResourceFilesMode() != this.getResourceFilesMode()) {
            return true;
        }
        if (!this.myModel.getFilesToIncludeInSWC().equals(this.myFilesToIncludeInSWC)) {
            return true;
        }
        if (!this.myModel.getAdditionalConfigFilePath().equals(FileUtil.toSystemIndependentName((String)this.myConfigFileTextWithBrowse.getText().trim()))) {
            return true;
        }
        return !this.myModel.getAdditionalOptions().equals(this.myAdditionalOptionsField.getText().trim());
    }

    private CompilerOptions.ResourceFilesMode getResourceFilesMode() {
        return !this.myCopyResourceFilesCheckBox.isVisible() || !this.myCopyResourceFilesCheckBox.isSelected() ? CompilerOptions.ResourceFilesMode.None : (this.myCopyAllResourcesRadioButton.isSelected() ? CompilerOptions.ResourceFilesMode.All : CompilerOptions.ResourceFilesMode.ResourcePatterns);
    }

    public void apply() throws ConfigurationException {
        this.applyTo(this.myModel);
    }

    public void applyTo(ModifiableCompilerOptions compilerOptions) {
        TableUtil.stopEditing((JTable)this.myTreeTable);
        compilerOptions.setAllOptions(this.myCurrentOptions);
        if (compilerOptions == this.myModel) {
            this.myMapModified = false;
        }
        compilerOptions.setResourceFilesMode(this.getResourceFilesMode());
        compilerOptions.setFilesToIncludeInSWC(this.myFilesToIncludeInSWC);
        compilerOptions.setAdditionalConfigFilePath(FileUtil.toSystemIndependentName((String)this.myConfigFileTextWithBrowse.getText().trim()));
        compilerOptions.setAdditionalOptions(this.myAdditionalOptionsField.getText().trim());
    }

    public void reset() {
        this.myFreeze = true;
        try {
            this.myCurrentOptions.clear();
            this.myCurrentOptions.putAll(this.myModel.getAllOptions());
            this.myMapModified = false;
            this.updateTreeTable();
            CompilerOptions.ResourceFilesMode mode = this.myModel.getResourceFilesMode();
            this.myCopyResourceFilesCheckBox.setSelected(mode != CompilerOptions.ResourceFilesMode.None);
            this.myCopyAllResourcesRadioButton.setSelected(mode == CompilerOptions.ResourceFilesMode.None || mode == CompilerOptions.ResourceFilesMode.All);
            this.myRespectResourcePatternsRadioButton.setSelected(mode == CompilerOptions.ResourceFilesMode.ResourcePatterns);
            this.updateResourcesControls();
            this.myFilesToIncludeInSWC = this.myModel.getFilesToIncludeInSWC();
            this.updateFilesToIncludeInSWCText();
            this.myConfigFileTextWithBrowse.setText(FileUtil.toSystemDependentName((String)this.myModel.getAdditionalConfigFilePath()));
            this.myAdditionalOptionsField.setText(this.myModel.getAdditionalOptions());
            this.updateAdditionalOptionsControls();
        }
        finally {
            this.myFreeze = false;
        }
    }

    public void disposeUIResources() {
        this.myListeners.clear();
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private void createUIComponents() {
        this.myTreeTable = this.createTreeTable();
        this.myResourcePatternsHyperlink = new HoverHyperlinkLabel("resource patterns");
    }

    private TreeTable createTreeTable() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        ListTreeTableModel model = new ListTreeTableModel((TreeNode)rootNode, this.createColumns());
        TreeTable treeTable = new TreeTable((TreeTableModel)model);
        treeTable.getColumnModel().getColumn(1).setCellRenderer(this.createValueRenderer());
        treeTable.getColumnModel().getColumn(1).setCellEditor(this.createValueEditor());
        TreeTableTree tree = treeTable.getTree();
        tree.setRootVisible(false);
        tree.setLineStyleAngled();
        tree.setShowsRootHandles(true);
        tree.setCellRenderer(this.createTreeCellRenderer());
        treeTable.setSelectionMode(0);
        treeTable.setRowHeight(new JTextField((String)"Fake").getPreferredSize().height + 3);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RestoreDefaultValueAction((JTree)tree));
        PopupHandler.installPopupHandler((JComponent)treeTable, (ActionGroup)group, (String)"unknown", (ActionManager)ActionManager.getInstance());
        new TreeTableSpeedSearch(treeTable, o -> {
            Object userObject = ((DefaultMutableTreeNode)o.getLastPathComponent()).getUserObject();
            return userObject instanceof CompilerOptionInfo ? ((CompilerOptionInfo)userObject).DISPLAY_NAME : "";
        }).setComparator(new SpeedSearchComparator(false));
        return treeTable;
    }

    private TreeCellRenderer createTreeCellRenderer() {
        return new TreeCellRenderer(){
            private final JLabel myLabel = new JLabel();

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (!(userObject instanceof CompilerOptionInfo)) {
                    return this.myLabel;
                }
                CompilerOptionInfo info = (CompilerOptionInfo)userObject;
                this.myLabel.setText(info.DISPLAY_NAME);
                ValueSource valueSource = (ValueSource)((CompilerOptionsConfigurable)CompilerOptionsConfigurable.this).getValueAndSource((CompilerOptionInfo)info).second;
                CompilerOptionsConfigurable.renderAccordingToSource(this.myLabel, valueSource, selected);
                this.myLabel.setForeground(selected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground());
                return this.myLabel;
            }
        };
    }

    private static void renderAccordingToSource(Component component, ValueSource valueSource, boolean selected) {
        int boldOrPlain = valueSource == ValueSource.BC || valueSource == ValueSource.ProjectDefault ? 1 : 0;
        component.setFont(component.getFont().deriveFont(boldOrPlain));
        component.setEnabled(selected || valueSource == ValueSource.BC || valueSource == ValueSource.ModuleDefault);
    }

    private TableCellRenderer createValueRenderer() {
        return new TableCellRenderer(){
            private final JLabel myLabel = new JLabel();
            private final JCheckBox myCheckBox = new JCheckBox();
            private final ComponentWithBrowseButton<JLabel> myLabelWithBrowse = new ComponentWithBrowseButton((JComponent)new JLabel(), null);

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (!(value instanceof CompilerOptionInfo)) {
                    this.myLabel.setText("");
                    return this.myLabel;
                }
                CompilerOptionInfo info = (CompilerOptionInfo)value;
                Pair valueAndSource = CompilerOptionsConfigurable.this.getValueAndSource(info);
                switch (info.TYPE) {
                    case Boolean: {
                        this.myCheckBox.setBackground(table.getBackground());
                        this.myCheckBox.setSelected("true".equalsIgnoreCase((String)valueAndSource.first));
                        return this.myCheckBox;
                    }
                    case String: 
                    case Int: 
                    case List: 
                    case IncludeClasses: 
                    case IncludeFiles: {
                        this.myLabel.setBackground(table.getBackground());
                        this.myLabel.setText(CompilerOptionsConfigurable.getPresentableSummary((String)valueAndSource.first, info));
                        CompilerOptionsConfigurable.renderAccordingToSource(this.myLabel, (ValueSource)valueAndSource.second, false);
                        return this.myLabel;
                    }
                    case File: {
                        JLabel label = (JLabel)this.myLabelWithBrowse.getChildComponent();
                        this.myLabelWithBrowse.setBackground(table.getBackground());
                        label.setText(FileUtil.toSystemDependentName((String)((String)valueAndSource.first)));
                        CompilerOptionsConfigurable.renderAccordingToSource(label, (ValueSource)valueAndSource.second, false);
                        return this.myLabelWithBrowse;
                    }
                }
                assert (false);
                return null;
            }
        };
    }

    private static String getPresentableSummary(String rawValue, CompilerOptionInfo info) {
        if (info.TYPE == CompilerOptionInfo.OptionType.List) {
            if (info.LIST_ELEMENTS.length == 1) {
                String fixedSlashes = info.LIST_ELEMENTS[0].LIST_ELEMENT_TYPE == CompilerOptionInfo.ListElementType.File ? FileUtil.toSystemDependentName((String)rawValue) : rawValue;
                return fixedSlashes.replace("\n", ", ");
            }
            if ("compiler.define".equals(info.ID)) {
                return rawValue.replace("\n", ", ").replace("\t", "=");
            }
            StringBuilder b = new StringBuilder();
            for (String entry : StringUtil.split((String)rawValue, (String)"\n")) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(entry, 0, entry.indexOf("\t"));
            }
            return b.toString();
        }
        return rawValue;
    }

    private TableCellEditor createValueEditor() {
        return new AbstractTableCellEditor(){
            private final JTextField myTextField = new JTextField();
            private final TextFieldWithBrowseButton myTextWithBrowse = new TextFieldWithBrowseButton();
            private final RepeatableValueEditor myRepeatableValueEditor = new RepeatableValueEditor(CompilerOptionsConfigurable.access$800(CompilerOptionsConfigurable.this));
            private final ExtensionAwareFileChooserDescriptor myFileChooserDescriptor = new ExtensionAwareFileChooserDescriptor();
            private final JCheckBox myCheckBox = new JCheckBox();
            private Component myCurrentEditor;
            {
                this.myTextWithBrowse.addBrowseFolderListener(null, null, CompilerOptionsConfigurable.this.myProject, (FileChooserDescriptor)this.myFileChooserDescriptor);
                this.myCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TableUtil.stopEditing((JTable)CompilerOptionsConfigurable.this.myTreeTable);
                    }
                });
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                assert (value instanceof CompilerOptionInfo);
                CompilerOptionInfo info = (CompilerOptionInfo)value;
                Sdk sdk = CompilerOptionsConfigurable.this.myDependenciesConfigurable.getCurrentSdk();
                String sdkHome = sdk == null || sdk.getSdkType() == FlexmojosSdkType.getInstance() ? null : sdk.getHomePath();
                String optionValue = sdkHome == null ? (String)((CompilerOptionsConfigurable)CompilerOptionsConfigurable.this).getValueAndSource((CompilerOptionInfo)info).first : ((String)((CompilerOptionsConfigurable)CompilerOptionsConfigurable.this).getValueAndSource((CompilerOptionInfo)info).first).replace("${FLEX_SDK}", sdkHome);
                switch (info.TYPE) {
                    case Boolean: {
                        this.myCheckBox.setBackground(table.getBackground());
                        this.myCheckBox.setSelected("true".equalsIgnoreCase(optionValue));
                        this.myCurrentEditor = this.myCheckBox;
                        break;
                    }
                    case List: {
                        this.myRepeatableValueEditor.setInfoAndValue(info, optionValue);
                        this.myCurrentEditor = this.myRepeatableValueEditor;
                        break;
                    }
                    case String: 
                    case Int: 
                    case IncludeClasses: 
                    case IncludeFiles: {
                        this.myTextField.setText(optionValue);
                        this.myCurrentEditor = this.myTextField;
                        break;
                    }
                    case File: {
                        this.myFileChooserDescriptor.setAllowedExtensions(info.FILE_EXTENSION);
                        this.myTextWithBrowse.setText(FileUtil.toSystemDependentName((String)optionValue));
                        this.myCurrentEditor = this.myTextWithBrowse;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                return this.myCurrentEditor;
            }

            public Object getCellEditorValue() {
                if (this.myCurrentEditor == this.myCheckBox) {
                    return String.valueOf(this.myCheckBox.isSelected());
                }
                if (this.myCurrentEditor == this.myTextField) {
                    return this.myTextField.getText().trim();
                }
                if (this.myCurrentEditor == this.myTextWithBrowse) {
                    Sdk sdk = CompilerOptionsConfigurable.this.myDependenciesConfigurable.getCurrentSdk();
                    String sdkHome = sdk == null || sdk.getSdkType() == FlexmojosSdkType.getInstance() ? null : sdk.getHomePath();
                    String path = FileUtil.toSystemIndependentName((String)this.myTextWithBrowse.getText().trim());
                    return sdkHome == null ? path : path.replace(sdkHome, "${FLEX_SDK}");
                }
                if (this.myCurrentEditor == this.myRepeatableValueEditor) {
                    Sdk sdk = CompilerOptionsConfigurable.this.myDependenciesConfigurable.getCurrentSdk();
                    String sdkHome = sdk == null ? null : sdk.getHomePath();
                    String value = this.myRepeatableValueEditor.getValue();
                    return sdkHome == null ? value : value.replace(sdkHome, "${FLEX_SDK}");
                }
                assert (false);
                return null;
            }
        };
    }

    private ColumnInfo[] createColumns() {
        ColumnInfo optionColumn = new ColumnInfo("Option"){

            public Object valueOf(Object o) {
                Object userObject = ((DefaultMutableTreeNode)o).getUserObject();
                return userObject instanceof CompilerOptionInfo ? userObject : o;
            }

            public Class getColumnClass() {
                return TreeTableModel.class;
            }
        };
        ColumnInfo valueColumn = new ColumnInfo("Value"){

            public Object valueOf(Object o) {
                Object userObject = ((DefaultMutableTreeNode)o).getUserObject();
                return userObject instanceof CompilerOptionInfo && !((CompilerOptionInfo)userObject).isGroup() ? userObject : null;
            }

            public Class getColumnClass() {
                return CompilerOptionInfo.class;
            }

            public boolean isCellEditable(Object o) {
                Object userObject = ((DefaultMutableTreeNode)o).getUserObject();
                return userObject instanceof CompilerOptionInfo && !((CompilerOptionInfo)userObject).isGroup();
            }

            public void setValue(Object node, Object value) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                CompilerOptionInfo info = (CompilerOptionInfo)treeNode.getUserObject();
                Pair valueAndSource = CompilerOptionsConfigurable.this.getValueAndSource(info);
                if (!value.equals(valueAndSource.first)) {
                    CompilerOptionsConfigurable.this.myMapModified = true;
                    CompilerOptionsConfigurable.this.myCurrentOptions.put(info.ID, (String)value);
                    CompilerOptionsConfigurable.reloadNodeOrGroup((JTree)CompilerOptionsConfigurable.this.myTreeTable.getTree(), treeNode);
                }
            }
        };
        return new ColumnInfo[]{optionColumn, valueColumn};
    }

    private static void reloadNodeOrGroup(JTree tree, DefaultMutableTreeNode treeNode) {
        DefaultMutableTreeNode parent;
        DefaultMutableTreeNode nodeToRefresh = treeNode;
        while ((parent = (DefaultMutableTreeNode)nodeToRefresh.getParent()).getUserObject() instanceof CompilerOptionInfo) {
            nodeToRefresh = parent;
        }
        ((DefaultTreeModel)tree.getModel()).reload(nodeToRefresh);
    }

    private void updateResourcesControls() {
        this.myCopyAllResourcesRadioButton.setEnabled(this.myCopyResourceFilesCheckBox.isSelected());
        this.myRespectResourcePatternsRadioButton.setEnabled(this.myCopyResourceFilesCheckBox.isSelected());
        this.myResourcePatternsHyperlink.setEnabled(this.myCopyResourceFilesCheckBox.isSelected());
    }

    private void updateAdditionalOptionsControls() {
        String projectOptions = this.myProjectLevelOptionsHolder.getProjectLevelCompilerOptions().getAdditionalOptions();
        if (this.myMode == Mode.BC) {
            this.myInheritedOptionsField.setText(projectOptions + (projectOptions.isEmpty() ? "" : " ") + this.myBCManager.getModuleLevelCompilerOptions().getAdditionalOptions());
        } else if (this.myMode == Mode.Module) {
            this.myInheritedOptionsField.setText(projectOptions);
        }
        this.myNoteLabel.setVisible(this.myMode == Mode.BC && (!this.myConfigFileTextWithBrowse.getText().trim().isEmpty() || !this.myInheritedOptionsField.getText().trim().isEmpty() || !this.myAdditionalOptionsField.getText().trim().isEmpty()));
    }

    private void updateTreeTable() {
        TreeTableTree tree = this.myTreeTable.getTree();
        TreePath selectionPath = tree.getSelectionPath();
        List expandedPaths = TreeUtil.collectExpandedPaths((JTree)tree);
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
        CompilerOptionInfo[] optionInfos = CompilerOptionInfo.getRootInfos();
        boolean showAll = this.myShowAllOptionsCheckBox.isSelected();
        this.updateChildNodes(rootNode, optionInfos, showAll);
        treeModel.reload(rootNode);
        TreeUtil.restoreExpandedPaths((JTree)tree, (List)expandedPaths);
        tree.setSelectionPath(selectionPath);
    }

    private void updateChildNodes(DefaultMutableTreeNode rootNode, CompilerOptionInfo[] optionInfos, boolean showAll) {
        int currentNodeNumber = 0;
        for (CompilerOptionInfo info : optionInfos) {
            boolean show = info.isGroup() || (this.myMode != Mode.BC || info.isApplicable(this.getSdkVersion(), this.myNature)) && (showAll || !info.ADVANCED || this.hasCustomValue(info));
            DefaultMutableTreeNode node = CompilerOptionsConfigurable.findChildNodeWithInfo(rootNode, info);
            if (show) {
                if (node == null) {
                    node = new DefaultMutableTreeNode(info, info.isGroup());
                    rootNode.insert(node, currentNodeNumber);
                }
                ++currentNodeNumber;
                if (!info.isGroup()) continue;
                this.updateChildNodes(node, info.getChildOptionInfos(), showAll);
                if (node.getChildCount() != 0) continue;
                node.removeFromParent();
                --currentNodeNumber;
                continue;
            }
            if (node == null) continue;
            node.removeFromParent();
        }
    }

    @Nullable
    private static DefaultMutableTreeNode findChildNodeWithInfo(DefaultMutableTreeNode rootNode, CompilerOptionInfo info) {
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            if (!info.equals(childNode.getUserObject())) continue;
            return childNode;
        }
        return null;
    }

    private boolean hasCustomValue(CompilerOptionInfo info) {
        return this.myCurrentOptions.get(info.ID) != null;
    }

    @NotNull
    private Pair<String, ValueSource> getValueAndSource(CompilerOptionInfo info) {
        String projectDefaultValue;
        String moduleDefaultValue;
        if (info.isGroup()) {
            ValueSource groupValueSource = ValueSource.GlobalDefault;
            for (CompilerOptionInfo childInfo : info.getChildOptionInfos()) {
                ValueSource childSource;
                if (this.myMode == Mode.BC && !childInfo.isApplicable(this.getSdkVersion(), this.myNature) || (childSource = (ValueSource)this.getValueAndSource((CompilerOptionInfo)childInfo).second).ordinal() <= groupValueSource.ordinal()) continue;
                groupValueSource = childSource;
            }
            Pair pair = Pair.create(null, (Object)groupValueSource);
            if (pair == null) {
                CompilerOptionsConfigurable.$$$reportNull$$$0(0);
            }
            return pair;
        }
        String customValue = this.myCurrentOptions.get(info.ID);
        if (customValue != null) {
            Pair pair = Pair.create((Object)customValue, (Object)ValueSource.BC);
            if (pair == null) {
                CompilerOptionsConfigurable.$$$reportNull$$$0(1);
            }
            return pair;
        }
        if (this.myMode == Mode.BC && (moduleDefaultValue = this.myBCManager.getModuleLevelCompilerOptions().getOption(info.ID)) != null) {
            Pair pair = Pair.create((Object)moduleDefaultValue, (Object)ValueSource.ModuleDefault);
            if (pair == null) {
                CompilerOptionsConfigurable.$$$reportNull$$$0(2);
            }
            return pair;
        }
        if ((this.myMode == Mode.BC || this.myMode == Mode.Module) && (projectDefaultValue = this.myProjectLevelOptionsHolder.getProjectLevelCompilerOptions().getOption(info.ID)) != null) {
            Pair pair = Pair.create((Object)projectDefaultValue, (Object)ValueSource.ProjectDefault);
            if (pair == null) {
                CompilerOptionsConfigurable.$$$reportNull$$$0(3);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)info.getDefaultValue(this.getSdkVersion(), this.myNature, this.myDependenciesConfigurable.getCurrentComponentSet()), (Object)ValueSource.GlobalDefault);
        if (pair == null) {
            CompilerOptionsConfigurable.$$$reportNull$$$0(4);
        }
        return pair;
    }

    private String getSdkVersion() {
        Sdk sdk = this.myDependenciesConfigurable.getCurrentSdk();
        String sdkVersion = sdk == null ? null : sdk.getVersionString();
        return sdkVersion == null ? UNKNOWN_SDK_VERSION : sdkVersion;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        Object location;
        if (place != null && (location = place.getPath("FlashBuildConfiguration.locationOnTab")) instanceof Location) {
            switch ((Location)((Object)location)) {
                case AdditionalConfigFile: {
                    return IdeFocusManager.findInstance().requestFocus((Component)this.myConfigFileTextWithBrowse.getChildComponent(), true);
                }
                case FilesToIncludeInSwc: {
                    return IdeFocusManager.findInstance().requestFocus((Component)this.myIncludeInSWCField.getChildComponent(), true);
                }
                case ConditionalCompilerDefinition: {
                    DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTreeTable.getTree().getModel().getRoot();
                    CompilerOptionInfo info = CompilerOptionInfo.getOptionInfo((String)"compiler.define");
                    DefaultMutableTreeNode node = CompilerOptionsConfigurable.findChildNodeWithInfo(root, info);
                    if (node == null) break;
                    this.myTreeTable.clearSelection();
                    this.myTreeTable.addSelectedPath(TreeUtil.getPath((TreeNode)root, (TreeNode)node));
                    Object ccdName = place.getPath(CONDITIONAL_COMPILER_DEFINITION_NAME);
                    if (!(ccdName instanceof String)) break;
                    TableUtil.editCellAt((JTable)this.myTreeTable, (int)this.myTreeTable.getSelectedRow(), (int)1);
                    Component editor = this.myTreeTable.getEditorComponent();
                    if (!(editor instanceof RepeatableValueEditor)) break;
                    ((RepeatableValueEditor)((Object)editor)).setAutoAddConditionalCompilerDefinition((String)ccdName);
                    ((RepeatableValueEditor)((Object)editor)).getButton().doClick();
                }
            }
        }
        return ActionCallback.DONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/CompilerOptionsConfigurable", "getValueAndSource"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel2;
        NonFocusableCheckBox nonFocusableCheckBox;
        JLabel jLabel;
        JButton jButton;
        JButton jButton2;
        JTextField jTextField;
        JLabel jLabel2;
        RawCommandLineEditor rawCommandLineEditor;
        JLabel jLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel4;
        JLabel jLabel5;
        JLabel jLabel6;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 3, 1, 0, 3, 7, 7, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        TreeTable treeTable = this.myTreeTable;
        treeTable.setPreferredScrollableViewportSize(new Dimension(450, 450));
        jBScrollPane.setViewportView((Component)treeTable);
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Legend", (int)0, (int)0, null, null));
        JLabel jLabel7 = new JLabel();
        ((Component)jLabel7).setEnabled(false);
        jLabel7.setText("Global default");
        jPanel5.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInheritProjectDefaultsLegend = jLabel6 = new JLabel();
        ((Component)jLabel6).setEnabled(false);
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel6.getFont());
        if (font != null) {
            jLabel6.setFont(font);
        }
        jLabel6.setText("Project default");
        jPanel5.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInheritModuleDefaultsLegend = jLabel5 = new JLabel();
        jLabel5.setText("Module default");
        jPanel5.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        Font font2 = this.$$$getFont$$$(null, 1, -1, jLabel8.getFont());
        if (font2 != null) {
            jLabel8.setFont(font2);
        }
        jLabel8.setText("Specific value");
        jPanel5.add((Component)jLabel8, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel6, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myConfigFileLabel = jLabel4 = new JLabel();
        jLabel4.setText("Additional compiler configuration file:");
        jLabel4.setDisplayedMnemonic('F');
        jLabel4.setDisplayedMnemonicIndex(34);
        jPanel6.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConfigFileTextWithBrowse = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel6.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myAdditionalOptionsLabel = jLabel3 = new JLabel();
        jLabel3.setText("Additional compiler options:");
        jLabel3.setDisplayedMnemonic('O');
        jLabel3.setDisplayedMnemonicIndex(20);
        jPanel6.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalOptionsField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel6.add((Component)rawCommandLineEditor, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myInheritedOptionsLabel = jLabel2 = new JLabel();
        jLabel2.setText("Inherited options:");
        jPanel6.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInheritedOptionsField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel6.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myProjectDefaultsButton = jButton2 = new JButton();
        jButton2.setText("Project Defaults...");
        jButton2.setMnemonic('P');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myModuleDefaultsButton = jButton = new JButton();
        jButton.setText("Module Defaults...");
        jButton.setMnemonic('M');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(-1, 10), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel8, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myNoteLabel = jLabel = new JLabel();
        jLabel.setText("Options set in the configuration file and additional options may override the options set in the table");
        jPanel8.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, new Dimension(150, -1), null, null));
        Spacer spacer4 = new Spacer();
        jPanel8.add((Component)spacer4, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        this.myShowAllOptionsCheckBox = nonFocusableCheckBox = new NonFocusableCheckBox();
        nonFocusableCheckBox.setText("Show more options");
        nonFocusableCheckBox.setMnemonic('W');
        nonFocusableCheckBox.setDisplayedMnemonicIndex(3);
        jPanel3.add((Component)nonFocusableCheckBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myResourcesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCopyAllResourcesRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("all except *.as and *.mxml");
        jRadioButton2.setMnemonic('L');
        jRadioButton2.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel2.add((Component)spacer5, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(1, 0, 1, 4, 0, 1, 6, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel2.add((Component)jPanel9, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRespectResourcePatternsRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("according to");
        jRadioButton.setMnemonic('R');
        jRadioButton.setDisplayedMnemonicIndex(4);
        jPanel9.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myResourcePatternsHyperlink;
        hoverHyperlinkLabel.setText("resource patterns");
        jPanel9.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCopyResourceFilesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Copy resource files to output folder:");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIncludeInSWCPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel.add((Component)jSeparator2, new GridConstraints(1, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Items to include in output SWC:");
        jLabel9.setDisplayedMnemonic('T');
        jLabel9.setDisplayedMnemonicIndex(6);
        jPanel.add((Component)jLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIncludeInSWCField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel3.setLabelFor((Component)rawCommandLineEditor);
        jLabel2.setLabelFor(jTextField);
        jLabel9.setLabelFor((Component)textFieldWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private class RestoreDefaultValueAction
    extends AnAction {
        private final JTree myTree;

        RestoreDefaultValueAction(JTree tree) {
            super("Restore Default Value");
            this.myTree = tree;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreDefaultValueAction.$$$reportNull$$$0(0);
            }
            TableUtil.stopEditing((JTable)CompilerOptionsConfigurable.this.myTreeTable);
            CompilerOptionInfo info = (CompilerOptionInfo)this.getNodeAndInfo().second;
            e.getPresentation().setEnabled(info != null && CompilerOptionsConfigurable.this.hasCustomValue(info));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreDefaultValueAction.$$$reportNull$$$0(1);
            }
            Pair<DefaultMutableTreeNode, CompilerOptionInfo> nodeAndInfo = this.getNodeAndInfo();
            if (nodeAndInfo.second != null) {
                CompilerOptionsConfigurable.this.myMapModified = true;
                CompilerOptionsConfigurable.this.myCurrentOptions.remove(((CompilerOptionInfo)nodeAndInfo.second).ID);
                CompilerOptionsConfigurable.reloadNodeOrGroup(this.myTree, (DefaultMutableTreeNode)nodeAndInfo.first);
            }
        }

        private Pair<DefaultMutableTreeNode, CompilerOptionInfo> getNodeAndInfo() {
            TreePath path = this.myTree.getSelectionPath();
            DefaultMutableTreeNode node = path == null ? null : (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node == null ? null : node.getUserObject();
            return userObject instanceof CompilerOptionInfo ? Pair.create((Object)node, (Object)((CompilerOptionInfo)userObject)) : Pair.empty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/lang/javascript/flex/projectStructure/ui/CompilerOptionsConfigurable$RestoreDefaultValueAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ExtensionAwareFileChooserDescriptor
    extends FileChooserDescriptor {
        @Nullable
        private String[] myAllowedExtensions;

        ExtensionAwareFileChooserDescriptor() {
            super(true, false, true, true, false, false);
        }

        public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
            return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || this.isAllowedExtension(file.getExtension()));
        }

        private boolean isAllowedExtension(String extension) {
            if (this.myAllowedExtensions == null) {
                return true;
            }
            for (String allowedExtension : this.myAllowedExtensions) {
                if (!allowedExtension.equalsIgnoreCase(extension)) continue;
                return true;
            }
            return false;
        }

        public void setAllowedExtensions(String ... allowedExtensions) {
            this.myAllowedExtensions = allowedExtensions;
        }
    }

    private class RepeatableValueEditor
    extends TextFieldWithBrowseButton {
        private final Project myProject;
        private CompilerOptionInfo myInfo;
        private String myValue;
        private String myAddedConditionalCompilerDefinition = null;

        private RepeatableValueEditor(Project project) {
            this.myProject = project;
            this.getTextField().setEditable(false);
            this.setButtonIcon(PlatformIcons.OPEN_EDIT_DIALOG_ICON);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogWrapper dialog;
                    Sdk sdk;
                    List entries = StringUtil.split((String)RepeatableValueEditor.this.myValue, (String)"\n");
                    ArrayList<StringBuilder> buffers = new ArrayList<StringBuilder>(entries.size());
                    for (String entry : entries) {
                        buffers.add(new StringBuilder(entry));
                    }
                    if (((RepeatableValueEditor)RepeatableValueEditor.this).myInfo.ID.equals("compiler.locale") && (sdk = CompilerOptionsConfigurable.this.myDependenciesConfigurable.getCurrentSdk()) != null && sdk.getSdkType() == FlexSdkType2.getInstance()) {
                        dialog = new LocalesDialog(RepeatableValueEditor.this.myProject, sdk, StringUtil.split((String)RepeatableValueEditor.this.myValue, (String)"\n"));
                        if (dialog.showAndGet()) {
                            RepeatableValueEditor.this.myValue = StringUtil.join(dialog.getLocales(), (String)"\n");
                        }
                    } else {
                        dialog = new RepeatableValueDialog(RepeatableValueEditor.this.myProject, StringUtil.capitalizeWords((String)((RepeatableValueEditor)RepeatableValueEditor.this).myInfo.DISPLAY_NAME, (boolean)true), buffers, RepeatableValueEditor.this.myInfo, RepeatableValueEditor.this.myAddedConditionalCompilerDefinition);
                        if (dialog.showAndGet()) {
                            RepeatableValueEditor.this.myValue = StringUtil.join(dialog.getCurrentList(), stringBuilder -> stringBuilder.toString(), (String)"\n");
                        }
                    }
                    TableUtil.stopEditing((JTable)CompilerOptionsConfigurable.this.myTreeTable);
                }
            });
        }

        public void setInfoAndValue(CompilerOptionInfo info, String value) {
            this.myInfo = info;
            this.myValue = value;
            this.myAddedConditionalCompilerDefinition = null;
            this.setText(CompilerOptionsConfigurable.getPresentableSummary(value, info));
        }

        public void setAutoAddConditionalCompilerDefinition(String ccdName) {
            this.myAddedConditionalCompilerDefinition = ccdName;
        }

        public String getValue() {
            return this.myValue;
        }
    }

    public static interface OptionsListener
    extends EventListener {
        public void configFileChanged(String var1);

        public void additionalOptionsChanged(String var1);
    }

    private static enum Mode {
        BC,
        Module,
        Project;

    }

    public static enum Location {
        AdditionalConfigFile("additional-config-file"),
        FilesToIncludeInSwc("files-to-include-in-swc"),
        ConditionalCompilerDefinition("doesn't matter");

        public final String errorId;

        private Location(String errorId) {
            this.errorId = errorId;
        }
    }
}

