/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class FlexModuleEditor
implements ModuleConfigurationEditor {
    public static final String DISPLAY_NAME = "Flex";
    private final CommonContentEntriesEditor myEntriesEditor;

    public FlexModuleEditor(ModuleConfigurationState state) {
        Module module = state.getRootModel().getModule();
        this.myEntriesEditor = new CommonContentEntriesEditor(module.getName(), state, new JpsModuleSourceRootType[]{JavaSourceRootType.SOURCE, JavaSourceRootType.TEST_SOURCE}){

            protected List<ContentEntry> addContentEntries(VirtualFile[] files) {
                List entries = super.addContentEntries(files);
                this.addContentEntryPanels(entries.toArray(new ContentEntry[0]));
                return entries;
            }
        };
        this.myEntriesEditor.getComponent().setBorder((Border)JBUI.Borders.empty());
    }

    @Nls
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return "projectStructure.modules.flex";
    }

    public JComponent createComponent() {
        return this.myEntriesEditor.createComponent();
    }

    public boolean isModified() {
        return this.myEntriesEditor.isModified();
    }

    public void reset() {
        this.myEntriesEditor.reset();
    }

    public void apply() throws ConfigurationException {
        this.myEntriesEditor.apply();
    }

    public void disposeUIResources() {
        this.myEntriesEditor.disposeUIResources();
    }
}

