/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.flex.model.bc.CompilerOptionInfo;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalesDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JLabel myLabel;
    private CheckBoxList<String> myCheckBoxList;
    private final Collection<String> mySdkLocales;

    public LocalesDialog(Project project, @NotNull Sdk sdk, Collection<String> selectedLocales) {
        if (sdk == null) {
            LocalesDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.$$$setupUI$$$();
        this.mySdkLocales = LocalesDialog.getAvailableLocales(sdk);
        this.setTitle(CompilerOptionInfo.getOptionInfo((String)"compiler.locale").DISPLAY_NAME);
        this.myLabel.setText(FlexBundle.message("locales.dialog.label", sdk.getName()));
        TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
        for (String locale : this.mySdkLocales) {
            map.put(locale, false);
        }
        for (String locale : selectedLocales) {
            map.put(locale, true);
        }
        this.myCheckBoxList.setStringItems(map);
        this.init();
    }

    private static Collection<String> getAvailableLocales(Sdk sdk) {
        THashSet result = new THashSet();
        File localeDir = new File(sdk.getHomePath() + "/frameworks/locale");
        if (localeDir.isDirectory()) {
            for (File subdir : localeDir.listFiles()) {
                if (!subdir.isDirectory() || !LocalesDialog.containsSwc(subdir)) continue;
                result.add(subdir.getName());
            }
        }
        return result;
    }

    private static boolean containsSwc(File dir) {
        return dir.listFiles(FileFilters.withExtension((String)"swc")).length > 0;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myCheckBoxList;
    }

    private void createUIComponents() {
        this.myCheckBoxList = new CheckBoxList<String>(){

            protected JComponent adjustRendering(JComponent rootComponent, JCheckBox checkBox, int index, boolean selected, boolean hasFocus) {
                String locale = checkBox.getText();
                checkBox.setForeground(LocalesDialog.this.mySdkLocales.contains(locale) ? UIUtil.getListForeground((boolean)selected) : JBColor.RED);
                return rootComponent;
            }
        };
        this.myCheckBoxList.setSelectionMode(2);
        new ListSpeedSearch(this.myCheckBoxList, o -> ((JCheckBox)o).getText());
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public List<String> getLocales() {
        ArrayList<String> result = new ArrayList<String>();
        ListModel model = this.myCheckBoxList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            JCheckBox checkBox = (JCheckBox)model.getElementAt(i);
            if (!checkBox.isSelected()) continue;
            result.add(checkBox.getText());
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/lang/javascript/flex/projectStructure/ui/LocalesDialog", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/lang/javascript/flex/FlexBundle").getString("locales.dialog.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 300), null));
        CheckBoxList<String> checkBoxList = this.myCheckBoxList;
        jBScrollPane.setViewportView((Component)checkBoxList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

