/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript;

import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.inspections.JSClosureCompilerSyntaxInspection;
import com.intellij.lang.javascript.inspections.actionscript.fixes.ActionScriptConstructorChecker;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeListImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageStatementImpl;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSCollectMembersToImplementProcessor;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSOverrideHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.validation.ActionScriptImplementedMethodProcessor;
import com.intellij.lang.javascript.validation.DuplicatesCheckUtil;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.TypedJSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.fixes.ChangeTypeFix;
import com.intellij.lang.javascript.validation.fixes.ImplementMethodsFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.javascript.validation.fixes.JSChangeSignatureFix;
import com.intellij.lang.javascript.validation.fixes.RemoveASTNodeFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ActionScriptAnnotatingVisitor
extends TypedJSAnnotatingVisitor {
    private static final String[] EXTENSIONS_TO_CHECK = new String[]{"as", "js2", "es", "mxml", "fxg"};
    private static final List<TokenSet> ourModifiersList = Arrays.asList(TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.DYNAMIC_KEYWORD}), TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STATIC_KEYWORD}), TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.FINAL_KEYWORD}), TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.OVERRIDE_KEYWORD}), TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.VIRTUAL_KEYWORD}));
    private static final String[] ourModifierFixIds = new String[]{"javascript.fix.remove.dynamic.modifier", "javascript.fix.remove.static.modifier", "javascript.fix.remove.final.modifier", "javascript.fix.remove.override.modifier", "javascript.fix.remove.virtual.modifier"};

    public ActionScriptAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        super(psiElement, holder);
    }

    @NotNull
    protected ActionScriptConstructorChecker createConstructorChecker() {
        ActionScriptConstructorChecker actionScriptConstructorChecker = new ActionScriptConstructorChecker(this.myProblemReporter);
        if (actionScriptConstructorChecker == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(2);
        }
        return actionScriptConstructorChecker;
    }

    protected static JSAnnotatingVisitor.SignatureMatchResult checkCompatibleSignature(JSFunction fun, JSFunction override) {
        JSAnnotatingVisitor.SignatureMatchResult result;
        JSParameterList nodeParameterList = fun.getParameterList();
        JSParameterList overrideParameterList = override.getParameterList();
        JSParameter[] parameters = nodeParameterList != null ? nodeParameterList.getParameterVariables() : JSParameter.EMPTY_ARRAY;
        JSParameter[] overrideParameters = overrideParameterList != null ? overrideParameterList.getParameterVariables() : JSParameter.EMPTY_ARRAY;
        JSAnnotatingVisitor.SignatureMatchResult signatureMatchResult = result = parameters.length != overrideParameters.length ? JSAnnotatingVisitor.SignatureMatchResult.PARAMETERS_DIFFERS : JSAnnotatingVisitor.SignatureMatchResult.COMPATIBLE_SIGNATURE;
        if (result == JSAnnotatingVisitor.SignatureMatchResult.COMPATIBLE_SIGNATURE) {
            for (int i = 0; i < parameters.length; ++i) {
                if (ActionScriptAnnotatingVisitor.compatibleType(overrideParameters[i].getTypeString(), parameters[i].getTypeString(), (PsiElement)overrideParameterList, (PsiElement)nodeParameterList) && overrideParameters[i].hasInitializer() == parameters[i].hasInitializer()) continue;
                result = JSAnnotatingVisitor.SignatureMatchResult.PARAMETERS_DIFFERS;
                break;
            }
        }
        if (result == JSAnnotatingVisitor.SignatureMatchResult.COMPATIBLE_SIGNATURE && !ActionScriptAnnotatingVisitor.compatibleType(override.getReturnTypeString(), fun.getReturnTypeString(), (PsiElement)override, (PsiElement)fun)) {
            result = JSAnnotatingVisitor.SignatureMatchResult.RETURN_TYPE_DIFFERS;
        }
        if (result == JSAnnotatingVisitor.SignatureMatchResult.COMPATIBLE_SIGNATURE && override.getKind() != fun.getKind()) {
            result = JSAnnotatingVisitor.SignatureMatchResult.FUNCTION_KIND_DIFFERS;
        }
        return result;
    }

    @Deprecated
    protected static boolean compatibleType(String overrideParameterType, String parameterType, PsiElement overrideContext, PsiElement funContext) {
        if (overrideParameterType != null && !overrideParameterType.equals(parameterType)) {
            parameterType = JSImportHandlingUtil.resolveTypeName((String)parameterType, (PsiElement)funContext);
            if (!(overrideParameterType = JSImportHandlingUtil.resolveTypeName((String)overrideParameterType, (PsiElement)overrideContext)).equals(parameterType)) {
                return parameterType != null && (JSTypeEvaluateManager.isArrayType((String)overrideParameterType) && JSTypeEvaluateManager.getBaseArrayType((String)overrideParameterType).equals(parameterType) || JSTypeEvaluateManager.isArrayType((String)parameterType) || JSTypeEvaluateManager.getBaseArrayType((String)parameterType).equals(overrideParameterType));
            }
            return true;
        }
        return overrideParameterType != null || parameterType == null || "*".equals(parameterType);
    }

    @NotNull
    protected JSAnnotatorProblemReporter createProblemReporter(PsiElement context) {
        JSAnnotatorProblemReporter jSAnnotatorProblemReporter = new JSAnnotatorProblemReporter(this.myHolder){

            @Nullable
            protected String getAnnotatorInspectionId() {
                return null;
            }
        };
        if (jSAnnotatorProblemReporter == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(3);
        }
        return jSAnnotatorProblemReporter;
    }

    public static void checkFileUnderSourceRoot(JSNamedElement aClass, JSAnnotatingVisitor.ErrorReportingClient client) {
        PsiFile containingFile;
        VirtualFile file;
        PsiElement nameIdentifier = aClass.getNameIdentifier();
        if (nameIdentifier == null) {
            nameIdentifier = aClass.getFirstChild();
        }
        if ((file = (containingFile = aClass.getContainingFile()).getVirtualFile()) == null) {
            return;
        }
        VirtualFile rootForFile = ProjectRootManager.getInstance((Project)containingFile.getProject()).getFileIndex().getSourceRootForFile(file);
        if (rootForFile == null) {
            client.reportError(nameIdentifier.getNode(), JSBundle.message((String)"javascript.validation.message.file.should.be.under.source.root", (Object[])new Object[0]), JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.WARNING, new IntentionAction[0]);
        }
        if (!(aClass instanceof JSPackageStatement)) {
            VirtualFile parent = file.getParent();
            if (parent == null) {
                return;
            }
            boolean found = false;
            for (String ext : EXTENSIONS_TO_CHECK) {
                String name = file.getNameWithoutExtension() + "." + ext;
                VirtualFile child = parent.findChild(name);
                if (child == null || !name.equals(child.getName())) continue;
                if (found) {
                    client.reportError(nameIdentifier.getNode(), JSBundle.message((String)"javascript.validation.message.more.than.one.named.object.in.package", (Object[])new Object[0]), JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[0]);
                    break;
                }
                found = true;
            }
        }
    }

    protected static JSChangeSignatureFix createChangeBaseMethodSignatureFix(JSFunction superMethod, JSFunction override) {
        JSType type = override.getReturnType();
        String s = StringUtil.notNullize((String)(type != null ? type.getResolvedTypeText() : null));
        JSChangeSignatureFix fix = new JSChangeSignatureFix(superMethod);
        fix.setReturnType(s);
        return fix;
    }

    public void visitJSAttributeNameValuePair(@NotNull JSAttributeNameValuePair attributeNameValuePair) {
        String baseClassFqns;
        boolean ok;
        if (attributeNameValuePair == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(4);
        }
        if (!(ok = this.checkReferences((PsiElement)attributeNameValuePair))) {
            return;
        }
        if (attributeNameValuePair.getValueNode() == null) {
            return;
        }
        PsiElement parent = attributeNameValuePair.getParent();
        XmlElementDescriptor descriptor = parent instanceof JSAttributeImpl ? ((JSAttributeImpl)parent).getBackedDescriptor() : null;
        String attributeName = StringUtil.notNullize((String)attributeNameValuePair.getName(), (String)"_DEFAULT_");
        XmlAttributeDescriptor attributeDescriptor = descriptor == null ? null : descriptor.getAttributeDescriptor(attributeName, null);
        String string = baseClassFqns = attributeDescriptor == null ? null : attributeDescriptor.getDefaultValue();
        if (baseClassFqns != null && !StringUtil.isEmptyOrSpaces((String)baseClassFqns)) {
            PsiElement resolved;
            PsiReference[] references = attributeNameValuePair.getReferences();
            PsiReference lastReference = references.length > 0 ? references[0] : null;
            for (PsiReference reference : references) {
                if (reference.getRangeInElement().getEndOffset() <= lastReference.getRangeInElement().getEndOffset()) continue;
                lastReference = reference;
            }
            PsiElement psiElement = resolved = lastReference != null ? lastReference.resolve() : null;
            if (resolved instanceof JSClass) {
                boolean correctClass = false;
                ArrayList<String> resolvedBaseClasses = new ArrayList<String>();
                GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)attributeNameValuePair);
                for (String baseClassFqn : StringUtil.split((String)baseClassFqns, (String)",")) {
                    if ("Object".equals(baseClassFqn)) {
                        correctClass = true;
                        break;
                    }
                    PsiElement baseClass = ActionScriptClassResolver.findClassByQNameStatic(baseClassFqn, (PsiElement)attributeNameValuePair);
                    if (!(baseClass instanceof JSClass)) continue;
                    resolvedBaseClasses.add(baseClassFqn);
                    if (!JSInheritanceUtil.isParentClass((JSClass)((JSClass)resolved), (JSClass)((JSClass)baseClass), (boolean)false, (GlobalSearchScope)scope)) continue;
                    correctClass = true;
                    break;
                }
                if (!correctClass) {
                    String classesForMessage = resolvedBaseClasses.isEmpty() ? StringUtil.replace((String)baseClassFqns, (String)",", (String)", ") : StringUtil.join(resolvedBaseClasses, (String)", ");
                    this.myHolder.createErrorAnnotation(ActionScriptAnnotatingVisitor.calcRangeForReferences((PsiReference)lastReference), JSBundle.message((String)"javascript.expected.class.or.descendant", (Object[])new Object[]{classesForMessage}));
                }
            } else if (resolved != attributeNameValuePair) {
                this.myHolder.createErrorAnnotation(attributeNameValuePair.getValueNode(), JSBundle.message((String)"javascript.qualified.class.name.expected", (Object[])new Object[0]));
            }
        }
    }

    public void visitJSIncludeDirective(@NotNull JSIncludeDirective includeDirective) {
        if (includeDirective == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(5);
        }
        this.checkReferences((PsiElement)includeDirective);
    }

    protected void checkImplementedMethods(@NotNull JSClass jsClass, JSAnnotatingVisitor.ErrorReportingClient reportingClient) {
        if (jsClass == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(6);
        }
        ActionScriptAnnotatingVisitor.checkActionScriptImplementedMethods(jsClass, reportingClient);
    }

    public static void checkActionScriptImplementedMethods(@NotNull JSClass jsClass, final JSAnnotatingVisitor.ErrorReportingClient reportingClient) {
        if (jsClass == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(7);
        }
        ActionScriptImplementedMethodProcessor implementedMethodProcessor = new ActionScriptImplementedMethodProcessor(jsClass){
            ImplementMethodsFix implementMethodsFix;
            {
                super(jsClass);
                this.implementMethodsFix = null;
            }

            @Override
            protected void addNonImplementedFunction(JSFunction function) {
                ASTNode node = this.myJsClass.findNameIdentifier();
                if (node == null) {
                    return;
                }
                if (this.implementMethodsFix == null) {
                    this.implementMethodsFix = new ImplementMethodsFix(this.myJsClass);
                }
                this.implementMethodsFix.addElementToProcess((JSElement)function);
                String messageId = JSClosureCompilerSyntaxInspection.getNotImplementedTextId((boolean)false, (boolean)function.isGetProperty(), (boolean)function.isSetProperty());
                String message = JSBundle.message((String)messageId, (Object[])new Object[]{function.getName(), ((JSClass)JSResolveUtil.findParent((PsiElement)function)).getQualifiedName()});
                reportingClient.reportError(node, message, JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[]{this.implementMethodsFix});
            }

            @Override
            protected void addImplementedFunction(JSFunction interfaceFunction, JSFunction implementationFunction) {
                JSAnnotatingVisitor.SignatureMatchResult incompatibleSignature;
                JSAttributeList attributeList = implementationFunction.getAttributeList();
                if (attributeList == null || attributeList.getAccessType() != JSAttributeList.AccessType.PUBLIC) {
                    ASTNode node = ActionScriptAnnotatingVisitor.findElementForAccessModifierError((JSFunction)implementationFunction, (JSAttributeList)attributeList);
                    reportingClient.reportError(node, JSBundle.message((String)"javascript.validation.message.interface.method.invalid.access.modifier", (Object[])new Object[0]), JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[]{JSFixFactory.getInstance().createChangeVisibilityFix((JSAttributeListOwner)implementationFunction, JSAttributeList.AccessType.PUBLIC, null)});
                }
                if ((incompatibleSignature = ActionScriptAnnotatingVisitor.checkCompatibleSignature(implementationFunction, interfaceFunction)) != JSAnnotatingVisitor.SignatureMatchResult.COMPATIBLE_SIGNATURE) {
                    PsiElement parent = JSResolveUtil.findParent((PsiElement)implementationFunction);
                    if (parent instanceof JSFile) {
                        parent = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)parent);
                    }
                    if (parent != this.myJsClass) {
                        this.addNonImplementedFunction(interfaceFunction);
                        return;
                    }
                    if (incompatibleSignature == JSAnnotatingVisitor.SignatureMatchResult.PARAMETERS_DIFFERS) {
                        JSParameterList parameterList = implementationFunction.getParameterList();
                        JSParameterList expectedParameterList = interfaceFunction.getParameterList();
                        JSChangeSignatureFix changeSignatureFix = new JSChangeSignatureFix(interfaceFunction, parameterList);
                        reportingClient.reportError(parameterList.getNode(), JSBundle.message((String)"javascript.validation.message.interface.method.invalid.signature", (Object[])new Object[]{expectedParameterList != null ? expectedParameterList.getText() : "()"}), JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[]{new JSChangeSignatureFix(implementationFunction, expectedParameterList, false){

                            @NotNull
                            public String getText() {
                                String string = JSBundle.message((String)"javascript.fix.message.change.parameters.to.expected", (Object[])new Object[0]);
                                if (string == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return string;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$2$1", "getText"));
                            }
                        }, changeSignatureFix});
                    } else if (incompatibleSignature == JSAnnotatingVisitor.SignatureMatchResult.RETURN_TYPE_DIFFERS) {
                        PsiElement implementationReturnTypeExpr = implementationFunction.getReturnTypeElement();
                        JSType type = interfaceFunction.getReturnType();
                        String interfaceReturnType = type != null ? type.getResolvedTypeText() : null;
                        String msg = JSBundle.message((String)"javascript.validation.message.interface.method.invalid.signature2", (Object[])new Object[]{StringUtil.notNullize((String)interfaceReturnType)});
                        reportingClient.reportError(implementationReturnTypeExpr != null ? implementationReturnTypeExpr.getNode() : implementationFunction.findNameIdentifier(), msg, JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[]{new ChangeTypeFix((JSNamedElement)implementationFunction, interfaceReturnType, "javascript.fix.message.change.return.type.to.expected"), ActionScriptAnnotatingVisitor.createChangeBaseMethodSignatureFix(interfaceFunction, implementationFunction)});
                    } else if (incompatibleSignature == JSAnnotatingVisitor.SignatureMatchResult.FUNCTION_KIND_DIFFERS) {
                        String msg = JSBundle.message((String)"javascript.validation.message.interface.method.invalid.signature3", (Object[])new Object[]{interfaceFunction.getKind()});
                        reportingClient.reportError(implementationFunction.findNameIdentifier(), msg, JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[0]);
                    }
                }
            }
        };
        JSResolveUtil.processInterfaceMembers((JSClass)jsClass, (JSCollectMembersToImplementProcessor)implementedMethodProcessor);
    }

    protected void checkFunctionDeclaration(@NotNull JSFunction node) {
        if (node == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(8);
        }
        super.checkFunctionDeclaration(node);
        ASTNode nameIdentifier = node.findNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        PsiElement parent = node.getParent();
        if (parent instanceof JSFile) {
            parent = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)parent);
            String name = node.getName();
            if (parent instanceof JSClass && name != null && name.equals(((JSClass)parent).getName()) && !ActionScriptAnnotatingVisitor.isNative(node) && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)parent.getContainingFile())) {
                Annotation annotation = this.myHolder.createErrorAnnotation(nameIdentifier, JSBundle.message((String)"javascript.validation.message.constructor.in.mxml.is.not.allowed", (Object[])new Object[0]));
                annotation.registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.constructor", node.getNode()));
            }
        }
        if (parent instanceof JSPackageStatement) {
            this.checkNamedObjectIsInCorrespondingFile((JSNamedElement)node);
        }
        if (parent instanceof JSClass && !node.isConstructor()) {
            JSAttributeList attributeList = node.getAttributeList();
            JSClass clazz = (JSClass)parent;
            if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && (attributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE || attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE))) {
                boolean hasOverride;
                Ref set;
                final String qName = clazz.getQualifiedName();
                boolean b = JSResolveUtil.iterateType((JSPsiElementBase)node, (PsiElement)parent, (String)qName, (JSOverrideHandler)new JSOverrideHandler(set = new Ref(), hasOverride = attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE), attributeList, nameIdentifier, node, clazz){
                    final /* synthetic */ Ref val$set;
                    final /* synthetic */ boolean val$hasOverride;
                    final /* synthetic */ JSAttributeList val$attributeList;
                    final /* synthetic */ ASTNode val$nameIdentifier;
                    final /* synthetic */ JSFunction val$node;
                    final /* synthetic */ JSClass val$clazz;
                    {
                        this.val$set = ref;
                        this.val$hasOverride = bl;
                        this.val$attributeList = jSAttributeList;
                        this.val$nameIdentifier = aSTNode;
                        this.val$node = jSFunction;
                        this.val$clazz = jSClass;
                    }

                    public boolean process(@NotNull List<JSPsiElementBase> elements, PsiElement scope, String className) {
                        DialectOptionHolder holder;
                        if (elements == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (qName == className || qName != null && qName.equals(className)) {
                            return true;
                        }
                        JSFunction value = (JSFunction)elements.iterator().next();
                        this.val$set.set((Object)value);
                        if ("Object".equals(className)) {
                            if (this.val$hasOverride && !this.val$attributeList.hasModifier(JSAttributeList.ModifierType.NATIVE)) {
                                ASTNode astNode = this.val$attributeList.getNode().findChildByType(JSTokenTypes.OVERRIDE_KEYWORD);
                                Annotation annotation = ActionScriptAnnotatingVisitor.this.myHolder.createErrorAnnotation(astNode, JSBundle.message((String)"javascript.validation.message.function.override.for.object.method", (Object[])new Object[0]));
                                annotation.registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.override.modifier", astNode));
                            }
                            return false;
                        }
                        if (!this.val$hasOverride && (holder = ActionScriptAnnotatingVisitor.this.myHighlighter.getDialectOptionsHolder()) != null && holder.isECMA4) {
                            Annotation annotation = ActionScriptAnnotatingVisitor.this.myHolder.createErrorAnnotation(this.val$nameIdentifier, JSBundle.message((String)"javascript.validation.message.function.override.without.override.modifier", (Object[])new Object[]{className}));
                            annotation.registerFix((IntentionAction)new AddOverrideIntentionAction(this.val$node));
                        } else {
                            JSAttributeList attrList = value.getAttributeList();
                            JSAttributeList parentAttrList = ((JSAttributeListOwner)scope).getAttributeList();
                            if (attrList != null && attrList.hasModifier(JSAttributeList.ModifierType.FINAL) || parentAttrList != null && parentAttrList.hasModifier(JSAttributeList.ModifierType.FINAL)) {
                                ActionScriptAnnotatingVisitor.this.myHolder.createErrorAnnotation(this.val$attributeList.getNode().findChildByType(JSTokenTypes.OVERRIDE_KEYWORD), JSBundle.message((String)"javascript.validation.message.can.not.override.final.method", (Object[])new Object[]{className}));
                            }
                        }
                        if (this.val$clazz.isInterface()) {
                            ActionScriptAnnotatingVisitor.this.myHolder.createErrorAnnotation(this.val$nameIdentifier, JSBundle.message((String)"javascript.validation.message.function.override.for.interface", (Object[])new Object[]{className}));
                        }
                        return false;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$3", "process"));
                    }
                }, (boolean)true);
                if (b && hasOverride) {
                    ASTNode astNode = attributeList.getNode().findChildByType(JSTokenTypes.OVERRIDE_KEYWORD);
                    Annotation annotation = this.myHolder.createErrorAnnotation(astNode, JSBundle.message((String)"javascript.validation.message.function.override.without.parent.method", (Object[])new Object[0]));
                    annotation.registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.override.modifier", astNode));
                }
                if (!b && hasOverride) {
                    JSAnnotatingVisitor.SignatureMatchResult incompatibleSignature;
                    JSFunction override = (JSFunction)set.get();
                    JSAttributeList overrideAttrList = override.getAttributeList();
                    String overrideNs = null;
                    if (attributeList.getAccessType() != overrideAttrList.getAccessType() || (overrideNs = JSResolveUtil.getNamespaceValue((JSAttributeList)overrideAttrList)) != null && !overrideNs.equals(JSResolveUtil.getNamespaceValue((JSAttributeList)attributeList))) {
                        LocalQuickFixAndIntentionActionOnPsiElement fix;
                        String newVisibility;
                        if (overrideNs != null) {
                            newVisibility = overrideNs;
                            fix = JSFixFactory.getInstance().createChangeVisibilityFix((JSAttributeListOwner)node, null, overrideNs);
                        } else {
                            newVisibility = JSFormatUtil.formatVisibility((JSAttributeList.AccessType)overrideAttrList.getAccessType());
                            fix = JSFixFactory.getInstance().createChangeVisibilityFix((JSAttributeListOwner)node, overrideAttrList.getAccessType(), null);
                        }
                        Annotation annotation = this.myHolder.createErrorAnnotation(ActionScriptAnnotatingVisitor.findElementForAccessModifierError((JSFunction)node, (JSAttributeList)attributeList), JSBundle.message((String)"javascript.validation.message.function.override.incompatible.access.modifier", (Object[])new Object[]{newVisibility}));
                        annotation.registerFix((IntentionAction)fix);
                    }
                    if ((incompatibleSignature = ActionScriptAnnotatingVisitor.checkCompatibleSignature(node, override)) == JSAnnotatingVisitor.SignatureMatchResult.PARAMETERS_DIFFERS) {
                        JSParameterList nodeParameterList = node.getParameterList();
                        JSParameterList overrideParameterList = override.getParameterList();
                        Annotation annotation = this.myHolder.createErrorAnnotation(nodeParameterList != null ? nodeParameterList.getNode() : node.findNameIdentifier(), JSBundle.message((String)"javascript.validation.message.function.override.incompatible.signature", (Object[])new Object[]{overrideParameterList != null ? overrideParameterList.getText() : "()"}));
                        annotation.registerFix((IntentionAction)new JSChangeSignatureFix(node, overrideParameterList, false){

                            @NotNull
                            public String getText() {
                                String string = JSBundle.message((String)"javascript.fix.message.change.parameters.to.expected", (Object[])new Object[0]);
                                if (string == null) {
                                    4.$$$reportNull$$$0(0);
                                }
                                return string;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$4", "getText"));
                            }
                        });
                        annotation.registerFix((IntentionAction)new JSChangeSignatureFix(override, nodeParameterList));
                    } else if (incompatibleSignature == JSAnnotatingVisitor.SignatureMatchResult.RETURN_TYPE_DIFFERS) {
                        PsiElement returnTypeExpr = node.getReturnTypeElement();
                        JSType type = override.getReturnType();
                        String baseReturnType = type != null ? type.getResolvedTypeText() : null;
                        String msg = JSBundle.message((String)"javascript.validation.message.function.override.incompatible.signature2", (Object[])new Object[]{StringUtil.notNullize((String)baseReturnType)});
                        Annotation annotation = this.myHolder.createErrorAnnotation(returnTypeExpr != null ? returnTypeExpr.getNode() : node.findNameIdentifier(), msg);
                        annotation.registerFix((IntentionAction)new ChangeTypeFix((JSNamedElement)node, baseReturnType, "javascript.fix.message.change.return.type.to.expected"));
                        annotation.registerFix((IntentionAction)ActionScriptAnnotatingVisitor.createChangeBaseMethodSignatureFix(override, node));
                    } else if (incompatibleSignature == JSAnnotatingVisitor.SignatureMatchResult.FUNCTION_KIND_DIFFERS) {
                        String msg = JSBundle.message((String)"javascript.validation.message.function.override.incompatible.signature3", (Object[])new Object[]{override.getKind().toString()});
                        Annotation annotation = this.myHolder.createErrorAnnotation(node.findNameIdentifier(), msg);
                    }
                }
            } else if (attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                if (clazz.isInterface()) {
                    this.reportStaticMethodProblem(attributeList, "javascript.validation.message.static.method.in.interface");
                }
                if (attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                    this.reportStaticMethodProblem(attributeList, "javascript.validation.message.static.method.with.override");
                }
            }
        }
    }

    private static boolean isNative(JSFunction function) {
        JSAttributeList attributeList = function.getAttributeList();
        return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.NATIVE);
    }

    private void reportStaticMethodProblem(JSAttributeList attributeList, String key) {
        ASTNode astNode = attributeList.getNode().findChildByType(JSTokenTypes.STATIC_KEYWORD);
        Annotation annotation = this.myHolder.createErrorAnnotation(astNode, JSBundle.message((String)key, (Object[])new Object[0]));
        annotation.registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.static.modifier", astNode));
    }

    public void visitJSPackageStatement(JSPackageStatement packageStatement) {
        ASTNode node;
        boolean injected;
        JSFile jsFile = (JSFile)PsiTreeUtil.getParentOfType((PsiElement)packageStatement, JSFile.class);
        PsiElement context = jsFile == null ? null : jsFile.getContext();
        boolean bl = injected = context instanceof XmlAttributeValue || context instanceof XmlText;
        if (injected) {
            this.myHolder.createErrorAnnotation(packageStatement.getFirstChild().getNode(), JSBundle.message((String)"javascript.validation.message.nested.packages.are.not.allowed", (Object[])new Object[0]));
            return;
        }
        for (PsiElement el = packageStatement.getPrevSibling(); el != null; el = el.getPrevSibling()) {
            if (el instanceof PsiWhiteSpace || el instanceof PsiComment) continue;
            this.myHolder.createErrorAnnotation(packageStatement.getFirstChild().getNode(), JSBundle.message((String)"javascript.validation.message.package.shouldbe.first.statement", (Object[])new Object[0]));
            break;
        }
        if ((node = packageStatement.findNameIdentifier()) == null) {
            this.checkPackageStatement(packageStatement);
        }
    }

    private void checkPackageStatement(final JSPackageStatement packageStatement) {
        String s = packageStatement.getQualifiedName();
        PsiFile containingFile = packageStatement.getContainingFile();
        final String expected = JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)containingFile.getVirtualFile(), (Project)containingFile.getProject());
        if (expected != null && (s == null && expected.length() != 0 || s != null && !expected.equals(s))) {
            ASTNode nameIdentifier = packageStatement.findNameIdentifier();
            Annotation annotation = this.myHolder.createErrorAnnotation(nameIdentifier != null ? nameIdentifier : packageStatement.getFirstChild().getNode(), JSBundle.message((String)"javascript.validation.message.incorrect.package.name", (Object[])new Object[]{s, expected}));
            annotation.registerFix(new IntentionAction(){

                @NotNull
                public String getText() {
                    String string = JSBundle.message((String)"javascript.fix.package.name", (Object[])new Object[]{expected});
                    if (string == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = this.getText();
                    if (string == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        5.$$$reportNull$$$0(2);
                    }
                    return packageStatement.isValid();
                }

                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    if (project == null) {
                        5.$$$reportNull$$$0(3);
                    }
                    JSPackageStatementImpl.doChangeName((Project)project, (JSPackageStatement)packageStatement, (String)expected);
                }

                public boolean startInWriteAction() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 2: 
                        case 3: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$5";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$5";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "isAvailable";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "invoke";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
        THashSet elements = new THashSet();
        for (JSSourceElement statement : packageStatement.getStatements()) {
            if (statement instanceof JSNamedElement && !(statement instanceof JSImportStatement)) {
                elements.add((JSNamedElement)statement);
                continue;
            }
            if (!(statement instanceof JSVarStatement)) continue;
            ContainerUtil.addAll((Collection)elements, (Object[])((JSVarStatement)statement).getVariables());
        }
        if (elements.size() > 1) {
            for (JSNamedElement el : elements) {
                JSAttributeList attributeList;
                if (!(el instanceof JSAttributeListOwner) || (attributeList = ((JSAttributeListOwner)el).getAttributeList()) != null && attributeList.getConditionalCompileVariableReference() != null) continue;
                ASTNode nameIdentifier = el.findNameIdentifier();
                this.myHolder.createErrorAnnotation(nameIdentifier != null ? nameIdentifier : el.getFirstChild().getNode(), JSBundle.message((String)"javascript.validation.message.more.than.one.externally.visible.symbol", (Object[])new Object[0])).registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.externally.visible.symbol", el.getNode()));
            }
        }
        ActionScriptAnnotatingVisitor.checkFileUnderSourceRoot((JSNamedElement)packageStatement, (JSAnnotatingVisitor.ErrorReportingClient)new JSAnnotatingVisitor.SimpleErrorReportingClient((JSAnnotatingVisitor)this));
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        JSParameterList parameterList;
        JSFunction fun;
        JSNamedElement namedElement;
        ASTNode nameIdentifier;
        super.visitJSReferenceExpression(node);
        PsiElement parent = node.getParent();
        if (node.getQualifier() == null) {
            String nodeText = node.getText();
            if (!(parent instanceof JSCallExpression) && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)node) && "Vector".equals(nodeText)) {
                this.myHolder.createWarningAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.vector.without.parameters", (Object[])new Object[0]));
            } else if (parent instanceof JSNewExpression && "Vector".equals(nodeText)) {
                this.myHolder.createWarningAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.vector.without.parameters2", (Object[])new Object[0]));
            }
        }
        if (parent instanceof JSNamedElement && (nameIdentifier = (namedElement = (JSNamedElement)parent).findNameIdentifier()) != null && nameIdentifier.getPsi() == node) {
            if (parent instanceof JSPackageStatement) {
                this.checkPackageStatement((JSPackageStatement)parent);
            } else if (!(parent instanceof JSImportStatement) && parent.getParent() instanceof JSPackageStatement) {
                this.checkNamedObjectIsInCorrespondingFile(namedElement);
            } else if (parent instanceof JSVariable) {
                if (parent.getParent().getParent() instanceof JSPackageStatement) {
                    this.checkNamedObjectIsInCorrespondingFile((JSNamedElement)((JSVariable)parent));
                }
            } else if (parent instanceof JSNamespaceDeclaration) {
                DuplicatesCheckUtil.checkDuplicates((JSNamedElement)((JSNamespaceDeclaration)parent), (JSAnnotatorProblemReporter)this.myProblemReporter);
            }
            if (parent instanceof JSClass) {
                boolean clazzParentIsInjectedJsFile;
                JSClass jsClass = (JSClass)parent;
                JSFunction constructor = jsClass.getConstructor();
                if (constructor == null) {
                    this.createConstructorChecker().checkMissedConstructor(jsClass);
                }
                PsiElement clazzParent = jsClass.getParent();
                PsiElement context = clazzParent.getContext();
                boolean bl = clazzParentIsInjectedJsFile = clazzParent instanceof JSFile && (context instanceof XmlAttributeValue || context instanceof XmlText) && !XmlBackedJSClassImpl.isImplementsAttribute((JSFile)((JSFile)clazzParent));
                if (PsiTreeUtil.getParentOfType((PsiElement)jsClass, (Class[])new Class[]{JSFunction.class, JSClass.class}) != null || clazzParentIsInjectedJsFile) {
                    this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.nested.classes.are.not.allowed", (Object[])new Object[0]));
                }
                this.checkClass(jsClass);
            }
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)node, (String)"arguments") && (fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class)) != null && node.resolve() instanceof ImplicitJSVariableImpl && (parameterList = fun.getParameterList()) != null) {
            for (JSParameter p : parameterList.getParameterVariables()) {
                if (!p.isRest()) continue;
                this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.arguments.with.rest.parameter", (Object[])new Object[0]));
            }
        }
    }

    private void checkClass(JSClass jsClass) {
        if (!jsClass.isInterface()) {
            this.checkIfExtendsFinalOrMultipleClasses(jsClass);
        }
        DuplicatesCheckUtil.checkDuplicates((JSNamedElement)jsClass, (JSAnnotatorProblemReporter)this.myProblemReporter);
    }

    private void checkIfExtendsFinalOrMultipleClasses(JSClass jsClass) {
        JSReferenceList extendsList = jsClass.getExtendsList();
        if (extendsList != null) {
            String[] extendsListTexts = extendsList.getReferenceTexts();
            if (extendsListTexts.length > 1) {
                this.myHolder.createErrorAnnotation(extendsList.getTextRange(), JSBundle.message((String)"javascript.validation.message.extend.multiple.classes", (Object[])new Object[0]));
            } else if (extendsListTexts.length == 1) {
                JSExpression[] referencesToSuper;
                JSAttributeList attributeList;
                JSClass[] superClasses = jsClass.getSuperClasses();
                JSAttributeList jSAttributeList = attributeList = superClasses.length > 0 ? superClasses[0].getAttributeList() : null;
                if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.FINAL) && (referencesToSuper = extendsList.getExpressions()).length == 1) {
                    this.myHolder.createErrorAnnotation((PsiElement)referencesToSuper[0], JSBundle.message((String)"javascript.validation.message.extend.final.class", (Object[])new Object[]{superClasses[0].getQualifiedName()}));
                }
            }
        }
    }

    public void visitJSAttributeList(JSAttributeList attributeList) {
        JSReferenceExpression namespaceElement = attributeList.getNamespaceElement();
        PsiElement accessTypeElement = attributeList.findAccessTypeElement();
        JSReferenceExpression namespaceOrAccessModifierElement = namespaceElement;
        ASTNode[] children = attributeList.getNode().getChildren(JSAttributeListImpl.ourModifiersTypeSet);
        if (namespaceOrAccessModifierElement == null) {
            namespaceOrAccessModifierElement = accessTypeElement;
        } else if (accessTypeElement != null) {
            this.myHolder.createErrorAnnotation((PsiElement)namespaceOrAccessModifierElement, JSBundle.message((String)"javascript.validation.message.use.namespace.reference.or.access.modifier", (Object[])new Object[0])).registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.namespace.reference", namespaceOrAccessModifierElement.getNode()));
            this.myHolder.createErrorAnnotation(accessTypeElement, JSBundle.message((String)"javascript.validation.message.use.namespace.reference.or.access.modifier", (Object[])new Object[0])).registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.visibility.modifier", accessTypeElement.getNode()));
        }
        if (children.length > 1 && namespaceElement == null) {
            for (ASTNode astNode : children) {
                this.myHolder.createErrorAnnotation(astNode, JSBundle.message((String)"javascript.validation.message.one.visibility.modifier.allowed", (Object[])new Object[0])).registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.visibility.modifier", astNode));
            }
        }
        PsiElement element = attributeList.getParent();
        PsiElement parentForCheckingNsOrAccessModifier = JSResolveUtil.findParent((PsiElement)element);
        if (namespaceOrAccessModifierElement != null) {
            JSAttributeList.AccessType accessType;
            if (!(parentForCheckingNsOrAccessModifier instanceof JSClass)) {
                String typeElementText;
                boolean nodeUnderPackage = parentForCheckingNsOrAccessModifier instanceof JSPackageStatement;
                if (!((nodeUnderPackage || ActionScriptAnnotatingVisitor.hasQualifiedName(element) || parentForCheckingNsOrAccessModifier instanceof JSFile && attributeList.getAccessType() == JSAttributeList.AccessType.PACKAGE_LOCAL) && ("public".equals(typeElementText = namespaceOrAccessModifierElement.getText()) || "internal".equals(typeElementText)))) {
                    boolean nsRef = namespaceOrAccessModifierElement instanceof JSReferenceExpression;
                    String message = JSBundle.message((String)(nodeUnderPackage ? "javascript.validation.message.access.modifier.allowed.only.for.package.members" : (nsRef ? "javascript.validation.message.namespace.allowed.only.for.class.members" : "javascript.validation.message.access.modifier.allowed.only.for.class.members")), (Object[])new Object[0]);
                    Annotation annotation = parentForCheckingNsOrAccessModifier instanceof JSFile && !(element instanceof JSClass) ? this.myHolder.createWarningAnnotation((PsiElement)namespaceOrAccessModifierElement, message) : this.myHolder.createErrorAnnotation((PsiElement)namespaceOrAccessModifierElement, message);
                    annotation.registerFix((IntentionAction)new RemoveASTNodeFix(nsRef ? "javascript.fix.remove.namespace.reference" : "javascript.fix.remove.access.modifier", namespaceOrAccessModifierElement.getNode()));
                }
            } else if (((JSClass)parentForCheckingNsOrAccessModifier).isInterface()) {
                if (attributeList.getAccessType() != JSAttributeList.AccessType.PACKAGE_LOCAL || attributeList.getNode().findChildByType(JSTokenTypes.INTERNAL_KEYWORD) != null) {
                    ASTNode astNode = attributeList.getNode().findChildByType(JSTokenTypes.ACCESS_MODIFIERS);
                    String message = JSBundle.message((String)"javascript.validation.message.interface.members.cannot.have.access.modifiers", (Object[])new Object[0]);
                    String fixMessageKey = "javascript.fix.remove.access.modifier";
                    if (astNode == null) {
                        astNode = attributeList.getNode().findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
                        message = JSBundle.message((String)"javascript.validation.message.interface.members.cannot.have.namespace.attributes", (Object[])new Object[0]);
                        fixMessageKey = "javascript.fix.remove.namespace.reference";
                    }
                    Annotation annotation = this.myHolder.createErrorAnnotation(astNode, message);
                    annotation.registerFix((IntentionAction)new RemoveASTNodeFix(fixMessageKey, astNode));
                }
            } else if (JSResolveUtil.isConstructorFunction((PsiElement)element) && (accessType = attributeList.getAccessType()) != JSAttributeList.AccessType.PUBLIC) {
                this.myHolder.createErrorAnnotation(namespaceOrAccessModifierElement.getNode(), JSBundle.message((String)"javascript.validation.message.constructor.cannot.have.custom.visibility", (Object[])new Object[0]));
            }
        }
        if (attributeList.hasModifier(JSAttributeList.ModifierType.FINAL)) {
            PsiElement parent;
            if (element instanceof JSClass) {
                if (((JSClass)element).isInterface()) {
                    this.finalModifierProblem(attributeList, "javascript.validation.message.interface.cannot.be.final.modifiers");
                }
            } else if (parentForCheckingNsOrAccessModifier instanceof JSClass && ((JSClass)parentForCheckingNsOrAccessModifier).isInterface()) {
                this.finalModifierProblem(attributeList, "javascript.validation.message.interface.members.cannot.be.final.modifiers");
            } else if (!(element instanceof JSFunction) || (parent = element.getParent()) instanceof JSPackageStatement || parent instanceof JSFile && parent.getContext() == null) {
                this.finalModifierProblem(attributeList, "javascript.validation.message.final.modifier.allowed.only.for.methods");
            }
        }
        if (attributeList.hasExplicitModifier(JSAttributeList.ModifierType.STATIC)) {
            if (element instanceof JSFunction || element instanceof JSVarStatement) {
                if (!(parentForCheckingNsOrAccessModifier instanceof JSClass)) {
                    PsiElement modifierElement = attributeList.findModifierElement(JSAttributeList.ModifierType.STATIC);
                    String message = JSBundle.message((String)"javascript.validation.message.static.modifier.is.allowed.only.for.class.members", (Object[])new Object[0]);
                    Annotation annotation = parentForCheckingNsOrAccessModifier instanceof JSFile ? this.myHolder.createWarningAnnotation(modifierElement, message) : this.myHolder.createErrorAnnotation(modifierElement, message);
                    annotation.registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.static.modifier", modifierElement.getNode()));
                } else if (JSResolveUtil.isConstructorFunction((PsiElement)element)) {
                    this.modifierProblem(attributeList, JSAttributeList.ModifierType.STATIC, "javascript.validation.message.constructor.cannot.be.static", "javascript.fix.remove.static.modifier");
                }
            } else if (element instanceof JSNamespaceDeclaration || element instanceof JSClass) {
                this.modifierProblem(attributeList, JSAttributeList.ModifierType.STATIC, "javascript.validation.message.static.modifier.is.allowed.only.for.class.members", "javascript.fix.remove.static.modifier");
            }
            if (attributeList.hasModifier(JSAttributeList.ModifierType.FINAL) && element instanceof JSFunction) {
                this.finalModifierProblem(attributeList, "javascript.validation.message.static.method.cannot.be.final");
            }
        }
        if (attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) && !(element instanceof JSFunction)) {
            this.modifierProblem(attributeList, JSAttributeList.ModifierType.OVERRIDE, "javascript.validation.message.override.can.be.applied.to.method", "javascript.fix.remove.override.modifier");
        }
        if (attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC) && (!(element instanceof JSClass) || ((JSClass)element).isInterface())) {
            this.modifierProblem(attributeList, JSAttributeList.ModifierType.DYNAMIC, "javascript.validation.message.dynamic.can.be.applied.to.class", "javascript.fix.remove.dynamic.modifier");
        }
        this.checkMultipleModifiersProblem(attributeList);
    }

    private void finalModifierProblem(JSAttributeList attributeList, String messageKey) {
        this.modifierProblem(attributeList, JSAttributeList.ModifierType.FINAL, messageKey, "javascript.fix.remove.final.modifier");
    }

    private void modifierProblem(JSAttributeList attributeList, JSAttributeList.ModifierType modifierType, String messageKey, String removeFixNameKey) {
        PsiElement modifierElement = attributeList.findModifierElement(modifierType);
        String message = JSBundle.message((String)messageKey, (Object[])new Object[0]);
        Annotation annotation = this.myHolder.createErrorAnnotation(modifierElement, message);
        annotation.registerFix((IntentionAction)new RemoveASTNodeFix(removeFixNameKey, modifierElement.getNode()));
    }

    private static boolean hasQualifiedName(PsiElement element) {
        String qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : null;
        return qName != null && qName.indexOf(46) != -1;
    }

    private void checkMultipleModifiersProblem(JSAttributeList attributeList) {
        ASTNode node = attributeList.getNode();
        for (int i = 0; i < ourModifiersList.size(); ++i) {
            ASTNode[] modifiers = node.getChildren(ourModifiersList.get(i));
            if (modifiers.length < 2) continue;
            String s = modifiers[0].getElementType().toString().toLowerCase(Locale.ENGLISH);
            String type = s.substring(s.indexOf(58) + 1, s.indexOf(95));
            for (ASTNode a : modifiers) {
                Annotation errorAnnotation = JSAnnotatorProblemReporter.createErrorAnnotation((PsiElement)a.getPsi(), (String)JSBundle.message((String)"javascript.validation.message.attribute.was.specified.multiple.times", (Object[])new Object[]{type}), (ProblemHighlightType)ProblemHighlightType.ERROR, (AnnotationHolder)this.myHolder);
                errorAnnotation.registerFix((IntentionAction)new RemoveASTNodeFix(ourModifierFixIds[i], a));
            }
        }
    }

    public void visitJSAttribute(JSAttribute jsAttribute) {
        JSType type;
        JSVariable var;
        JSVarStatement varStatement;
        if (!(!"Embed".equals(jsAttribute.getName()) || (varStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)jsAttribute, JSVarStatement.class)) == null || (var = (JSVariable)ArrayUtil.getFirstElement((Object[])varStatement.getVariables())) == null || (type = var.getType()) instanceof JSStringType || type instanceof JSTypeImpl && "Class".equals(type.getTypeText(JSType.TypeTextFormat.SIMPLE)))) {
            this.myHolder.createErrorAnnotation((PsiElement)jsAttribute, JSBundle.message((String)"javascript.validation.message.embed.annotation.used.with.var.of.wrong.type", (Object[])new Object[0]));
        }
        JSSemanticHighlightingUtil.highlight((JSAttribute)jsAttribute, (AnnotationHolder)this.myHolder);
        PsiReference psiReference = jsAttribute.getReference();
        if (psiReference != null && psiReference.resolve() == null) {
            this.myHolder.createWeakWarningAnnotation(jsAttribute.getNameIdentifier(), JSBundle.message((String)"javascript.validation.message.unknown.metadata.annotation.used", (Object[])new Object[0]));
        }
    }

    public void visitJSNamespaceDeclaration(JSNamespaceDeclaration namespaceDeclaration) {
        PsiElement resolve;
        PsiElement initializer = namespaceDeclaration.getInitializer();
        if (!(!(initializer instanceof JSExpression) || initializer instanceof JSLiteralExpression || initializer instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)initializer).resolve()) instanceof JSNamespaceDeclaration || resolve instanceof JSVariable && "Namespace".equals(((JSVariable)resolve).getTypeString())))) {
            JSAnnotatorProblemReporter.createErrorAnnotation((PsiElement)initializer, (String)JSBundle.message((String)"javascript.namespace.initializer.should.be.string.or.another.namespace.reference", (Object[])new Object[0]), (ProblemHighlightType)ProblemHighlightType.ERROR, (AnnotationHolder)this.myHolder);
        }
    }

    private void checkNamedObjectIsInCorrespondingFile(JSNamedElement aClass) {
        ASTNode node;
        PsiFile containingFile = aClass.getContainingFile();
        if (containingFile.getContext() != null) {
            return;
        }
        VirtualFile file = containingFile.getVirtualFile();
        if (file != null && !file.getNameWithoutExtension().equals(aClass.getName()) && ProjectRootManager.getInstance((Project)containingFile.getProject()).getFileIndex().getSourceRootForFile(file) != null && (node = aClass.findNameIdentifier()) != null) {
            String name = aClass.getName();
            String nameWithExtension = name + "." + file.getExtension();
            final String message = JSBundle.message((String)(aClass instanceof JSClass ? "javascript.validation.message.class.should.be.in.file" : (aClass instanceof JSNamespaceDeclaration ? "javascript.validation.message.namespace.should.be.in.file" : (aClass instanceof JSVariable ? "javascript.validation.message.variable.should.be.in.file" : "javascript.validation.message.function.should.be.in.file"))), (Object[])new Object[]{name, nameWithExtension});
            Annotation annotation = this.myHolder.createErrorAnnotation(node, message);
            annotation.registerFix((IntentionAction)new RenameFileFix(nameWithExtension));
            annotation.registerFix((IntentionAction)new RenameElementFix((PsiNamedElement)aClass){
                final String text;
                final String familyName;
                {
                    super(arg0);
                    String term = message.substring(0, message.indexOf(32));
                    this.text = super.getText().replace("class", StringUtil.decapitalize((String)term));
                    this.familyName = super.getFamilyName().replace("Class", term);
                }

                @NotNull
                public String getText() {
                    String string = this.text;
                    if (string == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = this.familyName;
                    if (string == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$6";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            });
        }
        ActionScriptAnnotatingVisitor.checkFileUnderSourceRoot(aClass, (JSAnnotatingVisitor.ErrorReportingClient)new JSAnnotatingVisitor.SimpleErrorReportingClient((JSAnnotatingVisitor)this));
    }

    protected void validateSetter(@NotNull JSFunction setter, @NotNull JSFunction getter, JSParameterListElement param, JSType setterType, JSType retType) {
        if (setter == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(9);
        }
        if (getter == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(10);
        }
        super.validateSetter(setter, getter, param, setterType, retType);
        this.checkAccessorAccessTypeMatch(setter, getter, "actionscript.validation.message.set.method.access.type.is.different.from.getter");
    }

    protected void validateGetter(@NotNull JSFunction getter, JSFunction setter, JSType type) {
        if (getter == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(11);
        }
        if (type instanceof JSVoidType) {
            String typeString = type != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : "empty";
            this.myHolder.createErrorAnnotation(type != null ? getter.getReturnTypeElement() : ActionScriptAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)getter), JSBundle.message((String)"javascript.validation.message.get.method.should.be.valid.type", (Object[])new Object[]{typeString}));
        } else if (setter != null) {
            JSType setterType;
            JSParameter[] setterParameters;
            JSParameterList setterParameterList = setter.getParameterList();
            JSParameter[] jSParameterArray = setterParameters = setterParameterList != null ? setterParameterList.getParameterVariables() : JSParameter.EMPTY_ARRAY;
            if (!(setterParameters.length != 1 || (setterType = setterParameters[0].getType()) instanceof JSAnyType || type instanceof JSAnyType || JSTypeUtils.areTypesCompatible((JSType)setterType, (JSType)type, null, (PsiElement)getter))) {
                PsiElement typeElement = getter.getReturnTypeElement();
                this.myHolder.createErrorAnnotation(typeElement != null ? typeElement : ActionScriptAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)getter), JSBundle.message((String)"javascript.validation.message.get.method.type.is.different.from.setter", (Object[])new Object[]{setterType != null ? setterType.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : "empty"}));
            }
            this.checkAccessorAccessTypeMatch(getter, setter, "actionscript.validation.message.get.method.access.type.is.different.from.setter");
        }
    }

    protected void validateRestParameterType(JSParameterListElement parameter) {
        PsiElement typeElement = parameter.getTypeElement();
        if (typeElement != null && !"Array".equals(typeElement.getText())) {
            Pair nodesBefore = ActionScriptAnnotatingVisitor.getNodesBefore((PsiElement)typeElement, (IElementType)JSTokenTypes.COLON);
            this.myHolder.createErrorAnnotation(typeElement, JSBundle.message((String)"javascript.validation.message.unexpected.type.for.rest.parameter", (Object[])new Object[0])).registerFix((IntentionAction)JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.type.reference", false, (ASTNode)nodesBefore.first, (ASTNode)nodesBefore.second));
        }
    }

    public void visitJSThisExpression(JSThisExpression node) {
        this.checkClassReferenceInStaticContext((JSExpression)node, "javascript.validation.message.this.referenced.from.static.context");
    }

    private void checkClassReferenceInStaticContext(JSExpression node, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String key) {
        JSFunction function;
        JSAttributeList attributeList;
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSExecutionScope.class, JSClass.class, JSObjectLiteralExpression.class});
        if (element instanceof JSFunction && (attributeList = (function = (JSFunction)element).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
            this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)key, (Object[])new Object[0]));
            return;
        }
        if (node instanceof JSSuperExpression) {
            if (element instanceof JSObjectLiteralExpression) {
                element = PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSExecutionScope.class, JSClass.class});
            }
            if (element == null || !(element instanceof JSClass) && !(JSResolveUtil.findParent((PsiElement)element) instanceof JSClass)) {
                String message = JSBundle.message((String)"javascript.validation.message.super.referenced.without.class.instance.context", (Object[])new Object[0]);
                this.myHolder.createErrorAnnotation((PsiElement)node, message);
            }
        }
    }

    public void visitJSSuperExpression(JSSuperExpression node) {
        this.checkClassReferenceInStaticContext((JSExpression)node, "javascript.validation.message.super.referenced.from.static.context");
    }

    public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
        JSExpression returnedExpr;
        if (node == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(12);
        }
        super.visitJSReturnStatement(node);
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class, XmlTagChild.class, XmlAttributeValue.class, JSFile.class});
        if (element instanceof JSFunction && (returnedExpr = node.getExpression()) != null && ((JSFunction)element).isConstructor() && JSResolveUtil.findParent((PsiElement)element) instanceof JSClass) {
            String message = FlexBundle.message("javascript.validation.message.no.return.value.required.for.constructor", new Object[0]);
            this.myHolder.createErrorAnnotation((PsiElement)returnedExpr, message);
        }
    }

    protected boolean isConstNeedInitializer(JSVariable var) {
        return true;
    }

    protected ProblemHighlightType getHighlightTypeForTypeOrSignatureProblem(@NotNull PsiElement node) {
        if (node == null) {
            ActionScriptAnnotatingVisitor.$$$reportNull$$$0(13);
        }
        return ProblemHighlightType.GENERIC_ERROR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeNameValuePair";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeDirective";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorChecker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemReporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitJSAttributeNameValuePair";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitJSIncludeDirective";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkImplementedMethods";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkActionScriptImplementedMethods";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionDeclaration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateSetter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateGetter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitJSReturnStatement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightTypeForTypeOrSignatureProblem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddOverrideIntentionAction
    implements IntentionAction {
        private final JSFunction myNode;

        AddOverrideIntentionAction(JSFunction node) {
            this.myNode = node;
        }

        @NotNull
        public String getText() {
            String string = JSBundle.message((String)"javascript.fix.add.override.modifier", (Object[])new Object[0]);
            if (string == null) {
                AddOverrideIntentionAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                AddOverrideIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                AddOverrideIntentionAction.$$$reportNull$$$0(2);
            }
            return this.myNode.isValid();
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                AddOverrideIntentionAction.$$$reportNull$$$0(3);
            }
            JSAttributeListWrapper w = new JSAttributeListWrapper((JSAttributeListOwner)this.myNode);
            w.overrideModifier(JSAttributeList.ModifierType.OVERRIDE, true);
            w.applyTo((JSAttributeListOwner)this.myNode);
        }

        public boolean startInWriteAction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$AddOverrideIntentionAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$AddOverrideIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

