/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSCollectMembersToImplementProcessor;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.validation.JSFunctionCollector;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ActionScriptImplementedMethodProcessor
extends JSCollectMembersToImplementProcessor {
    @NotNull
    protected final JSClass myJsClass;

    public static Collection<JSFunction> collectFunctionsToImplement(@NotNull JSClass clazz) {
        if (clazz == null) {
            ActionScriptImplementedMethodProcessor.$$$reportNull$$$0(0);
        }
        final JSFunctionCollector alreadyUsedMethods = new JSFunctionCollector();
        ActionScriptImplementedMethodProcessor processor = new ActionScriptImplementedMethodProcessor(clazz){

            @Override
            protected void addNonImplementedFunction(JSFunction function) {
                if (alreadyUsedMethods.hasFunctionWithTheSameKind(function.getName(), function.getKind())) {
                    return;
                }
                alreadyUsedMethods.add(function);
            }
        };
        JSResolveUtil.processInterfaceMembers((JSClass)clazz, (JSCollectMembersToImplementProcessor)processor);
        return alreadyUsedMethods.getFunctions();
    }

    public ActionScriptImplementedMethodProcessor(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            ActionScriptImplementedMethodProcessor.$$$reportNull$$$0(1);
        }
        super(null, false);
        this.myJsClass = jsClass;
    }

    @NotNull
    protected ResultSink createResultSink() {
        CompletionResultSink completionResultSink = new CompletionResultSink(this.place, null);
        if (completionResultSink == null) {
            ActionScriptImplementedMethodProcessor.$$$reportNull$$$0(2);
        }
        return completionResultSink;
    }

    protected void processMembers(@NotNull List<PsiElement> results) {
        if (results == null) {
            ActionScriptImplementedMethodProcessor.$$$reportNull$$$0(3);
        }
        JSFunctionCollector functionsCollector = null;
        for (PsiElement _function : results) {
            JSFunction o;
            JSFunction function;
            String name;
            if (!(_function instanceof JSFunction) || (name = (function = (JSFunction)_function).getName()) == null) continue;
            if (functionsCollector == null) {
                functionsCollector = this.collectVisibleFunctions();
            }
            if ((o = functionsCollector.findFunctionWithTheSameKind(name, function.getKind())) == null) {
                JSVariable var;
                if (JSPsiImplUtils.isGetterOrSetter((JSFunction)function) && (var = (JSVariable)JSInheritanceUtil.findMember((String)name, (JSClass)this.myJsClass, (JSInheritanceUtil.SearchedMemberType)JSInheritanceUtil.SearchedMemberType.Fields, null, (boolean)true)) != null && ActionScriptResolveUtil.fieldIsImplicitAccessorMethod((JSFunction)function, (JSVariable)var)) continue;
                this.addNonImplementedFunction(function);
                continue;
            }
            this.addImplementedFunction(function, o);
        }
    }

    @NotNull
    private JSFunctionCollector collectVisibleFunctions() {
        JSFunctionCollector jSFunctionCollector = JSFunctionCollector.collectAllVisibleClassFunctions((JSClass)this.myJsClass, null, jsFunction -> {
            JSAttributeList attributeList = jsFunction.getAttributeList();
            if (!JSInheritanceUtil.canHaveSuperMember((JSAttributeList)attributeList)) {
                return false;
            }
            PsiElement parentClass = JSResolveUtil.findParent((PsiElement)jsFunction);
            return attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC || this.myJsClass == parentClass;
        });
        if (jSFunctionCollector == null) {
            ActionScriptImplementedMethodProcessor.$$$reportNull$$$0(4);
        }
        return jSFunctionCollector;
    }

    protected void addImplementedFunction(JSFunction interfaceFunction, JSFunction implementationFunction) {
    }

    protected abstract void addNonImplementedFunction(JSFunction var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/ActionScriptImplementedMethodProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/ActionScriptImplementedMethodProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createResultSink";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVisibleFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectFunctionsToImplement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

