/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.CreateFieldByMxmlAttributeFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSPropertyAccessorIntentionAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class CreateSetterByMxmlAttributeFix
extends CreateJSPropertyAccessorIntentionAction {
    private final String myReferencedName;
    private final String myAttributeValue;

    public CreateSetterByMxmlAttributeFix(String referencedName, String attributeValue) {
        super(referencedName, false);
        this.myReferencedName = referencedName;
        this.myAttributeValue = attributeValue;
    }

    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateSetterByMxmlAttributeFix.$$$reportNull$$$0(0);
        }
        template.addTextSegment("public ");
        this.writeFunctionAndName(template, this.myReferencedName, anchorParent, null, referenceExpression);
        template.addTextSegment("(");
        template.addTextSegment(this.myReferencedName + ":");
        CreateFieldByMxmlAttributeFix.addTypeVariableByMxmlAttributeValue(template, this.myAttributeValue);
        template.addTextSegment(")");
        template.addTextSegment(":");
        this.addReturnType(template, referenceExpression, anchorParent);
        PsiElement clazz = CreateSetterByMxmlAttributeFix.findClass((PsiElement)anchorParent);
        if (clazz == null || clazz instanceof JSClass && !((JSClass)clazz).isInterface()) {
            template.addTextSegment(" {");
            this.addBody(template, anchorParent);
            template.addTextSegment("}");
        } else {
            this.addSemicolonSegment(template, anchorParent);
            template.addEndVariable();
        }
    }

    private void addBody(Template template, PsiElement context) {
        String varName;
        String paramName = varName = this.myReferencedName;
        if ((varName = JSRefactoringUtil.transformAccessorNameToPropertyName((String)varName, (PsiElement)context)).equals(paramName)) {
            varName = StringUtil.fixVariableNameDerivedFromPropertyName((String)varName);
        }
        CreateSetterByMxmlAttributeFix.addVarName(template, varName);
        template.addEndVariable();
        template.addTextSegment(" = " + paramName);
        this.addSemicolonSegment(template, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorParent", "com/intellij/lang/javascript/validation/fixes/CreateSetterByMxmlAttributeFix", "buildTemplate"));
    }
}

