/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.spring.model.values.converters.SpringValueConditionFactory;
import com.intellij.spring.model.values.converters.resources.ResourceTypeCondition;
import com.intellij.spring.model.values.converters.resources.SpringResourceTypeProvider;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.xml.GenericDomValue;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringWebServicesResourceTypeProvider
implements SpringResourceTypeProvider {
    private final Map<Condition<GenericDomValue>, Condition<PsiFileSystemItem>> myFilterMap = new HashMap();

    public SpringWebServicesResourceTypeProvider() {
        this.addResourceFilter("org.springframework.ws.wsdl.wsdl11.SimpleWsdl11Definition", "wsdl", "wsdl");
        this.addResourceFilter("org.springframework.xml.xsd.SimpleXsdSchema", "xsd", "xsd");
        this.addResourceFilter("org.springframework.ws.soap.server.endpoint.interceptor.PayloadValidatingInterceptor", "schema", "xsd");
        this.addResourceFilter("org.springframework.ws.server.endpoint.interceptor.PayloadTransformingInterceptor", "requestXslt", "xslt");
        this.addResourceFilter("org.springframework.ws.server.endpoint.interceptor.PayloadTransformingInterceptor", "responseXslt", "xslt");
        this.addResourceFilter("org.springframework.ws.soap.security.xwss.XwsSecurityInterceptor", "policyConfiguration", "xml");
        this.addConstructorArgResourceFilter("org.springframework.ws.wsdl.wsdl11.SimpleWsdl11Definition", "wsdl");
        this.addConstructorArgResourceFilter("org.springframework.xml.xsd.SimpleXsdSchema", "xsd");
        this.addConstructorArgResourceFilter("org.springframework.xml.xsd.commons.CommonsXsdSchema", "xsd");
    }

    private void addConstructorArgResourceFilter(String beanClass, String fileExtension) {
        this.myFilterMap.put((Condition<GenericDomValue>)SpringValueConditionFactory.createBeanClassConstructorArgCondition((String)beanClass), (Condition<PsiFileSystemItem>)new ResourceTypeCondition(new String[]{fileExtension}));
    }

    private void addResourceFilter(@NotNull String beanProperty, @NotNull String propertyName, @NotNull String fileExtension) {
        if (beanProperty == null) {
            SpringWebServicesResourceTypeProvider.$$$reportNull$$$0(0);
        }
        if (propertyName == null) {
            SpringWebServicesResourceTypeProvider.$$$reportNull$$$0(1);
        }
        if (fileExtension == null) {
            SpringWebServicesResourceTypeProvider.$$$reportNull$$$0(2);
        }
        this.myFilterMap.put((Condition<GenericDomValue>)SpringValueConditionFactory.createBeanPropertyCondition((String)beanProperty, (String[])new String[]{propertyName}), (Condition<PsiFileSystemItem>)new ResourceTypeCondition(new String[]{fileExtension}));
    }

    @Nullable
    public Condition<PsiFileSystemItem> getResourceFilter(@NotNull GenericDomValue genericDomValue) {
        if (genericDomValue == null) {
            SpringWebServicesResourceTypeProvider.$$$reportNull$$$0(3);
        }
        for (Map.Entry<Condition<GenericDomValue>, Condition<PsiFileSystemItem>> entry : this.myFilterMap.entrySet()) {
            if (!entry.getKey().value((Object)genericDomValue)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanProperty";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExtension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericDomValue";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/ws/converters/SpringWebServicesResourceTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addResourceFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getResourceFilter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

