/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.inspections.configuration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.ws.SpringWebServicesBundle;
import com.intellij.spring.ws.inspections.configuration.AddEmailTransportSupportFix;
import com.intellij.spring.ws.inspections.configuration.AddEmbeddedHttpTransportSupportFix;
import com.intellij.spring.ws.inspections.configuration.AddJmsTransportSupportFix;
import com.intellij.spring.ws.inspections.configuration.AddMessageDispatcherServletInWebXmlFix;
import com.intellij.spring.ws.util.SpringWebServicesUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringWebServicesConfigurationsInspection
extends SpringBeanInspectionBase {
    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        Module module = domFileElement.getModule();
        if (module == null) {
            return;
        }
        if (DomJavaUtil.findClass((String)"org.springframework.ws.transport.http.MessageDispatcherServlet", domFileElement) == null) {
            return;
        }
        if (SpringWebServicesUtil.isSpringWebServiceBeansDefined(domFileElement)) {
            Collection webFacets = WebFacet.getInstances((Module)module);
            Servlet messageDispatcherServlet = SpringWebServicesUtil.getMessageDispatcherServlet(webFacets);
            if (messageDispatcherServlet != null) {
                SpringWebServicesConfigurationsInspection.checkFileNameAndLocation(domFileElement, holder, messageDispatcherServlet);
            } else {
                XmlFile xmlFile = domFileElement.getFile();
                SpringModel springModel = SpringManager.getInstance((Project)xmlFile.getProject()).getSpringModelByFile((PsiFile)xmlFile);
                if (springModel != null && !SpringWebServicesConfigurationsInspection.isSpringWebServiceTransportConfigured(domFileElement, (CommonSpringModel)springModel)) {
                    holder.createProblem(domFileElement.getRootElement(), HighlightSeverity.ERROR, SpringWebServicesBundle.message("SpringWebServicesConfigurationsInspection.transport.is.not.configured", new Object[0]), SpringWebServicesConfigurationsInspection.getLocalFixes(domFileElement, module));
                }
            }
        }
    }

    private static LocalQuickFix[] getLocalFixes(@NotNull DomFileElement<Beans> domFileElement, @NotNull Module module) {
        if (domFileElement == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(1);
        }
        HashSet fixes = new HashSet();
        XmlFile xmlFile = domFileElement.getFile();
        SpringWebServicesConfigurationsInspection.registerMessageDispatcherServletInWebXmlFix((Set<LocalQuickFix>)fixes, xmlFile);
        SpringWebServicesConfigurationsInspection.registerJmsTransportFix((Set<LocalQuickFix>)fixes, xmlFile);
        SpringWebServicesConfigurationsInspection.registerEmailTransportFix((Set<LocalQuickFix>)fixes, xmlFile);
        SpringWebServicesConfigurationsInspection.registerEmbeddedHttpTransportFix((Set<LocalQuickFix>)fixes, xmlFile);
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static void registerEmbeddedHttpTransportFix(@NotNull Set<LocalQuickFix> fixes, @NotNull XmlFile xmlFile) {
        if (fixes == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(2);
        }
        if (xmlFile == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(3);
        }
        fixes.add(new AddEmbeddedHttpTransportSupportFix(xmlFile));
    }

    private static void registerEmailTransportFix(@NotNull Set<LocalQuickFix> fixes, @NotNull XmlFile xmlFile) {
        if (fixes == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(4);
        }
        if (xmlFile == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(5);
        }
        fixes.add(new AddEmailTransportSupportFix(xmlFile));
    }

    private static void registerJmsTransportFix(@NotNull Set<LocalQuickFix> fixes, @NotNull XmlFile xmlFile) {
        if (fixes == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(6);
        }
        if (xmlFile == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(7);
        }
        fixes.add(new AddJmsTransportSupportFix(xmlFile));
    }

    private static void registerMessageDispatcherServletInWebXmlFix(Set<LocalQuickFix> fixes, XmlFile xmlFile) {
        if (xmlFile.getName().endsWith("-servlet.xml") && SpringWebServicesConfigurationsInspection.isFileInWebInfDirectory(xmlFile)) {
            WebApp webApp = SpringWebServicesConfigurationsInspection.getWebApp(xmlFile);
            String servletName = SpringWebServicesConfigurationsInspection.getServletName(xmlFile.getName());
            if (webApp != null && !StringUtil.isEmptyOrSpaces((String)servletName)) {
                fixes.add(new AddMessageDispatcherServletInWebXmlFix(webApp, servletName));
            }
        }
    }

    @Nullable
    private static WebApp getWebApp(@NotNull XmlFile xmlFile) {
        WebFacet facet;
        if (xmlFile == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(8);
        }
        return (facet = WebUtil.getWebFacet((PsiElement)xmlFile)) == null ? null : facet.getRoot();
    }

    @Nullable
    private static String getServletName(@NotNull String filename) {
        int index;
        if (filename == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(9);
        }
        return (index = filename.indexOf("-servlet.xml")) < 0 ? null : filename.substring(0, index);
    }

    private static boolean isSpringWebServiceTransportConfigured(DomFileElement<Beans> domFileElement, @NotNull CommonSpringModel springModel) {
        if (springModel == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(10);
        }
        if (SpringWebServicesConfigurationsInspection.isEmbeddedHttpServerTransportConfigured(domFileElement, springModel)) {
            return true;
        }
        if (SpringWebServicesConfigurationsInspection.isWiringUpSpringWebServicesInDispatcherServlet(domFileElement, springModel)) {
            return true;
        }
        if (SpringWebServicesConfigurationsInspection.isJmsTransportConfigured(domFileElement, springModel)) {
            return true;
        }
        return SpringWebServicesConfigurationsInspection.isEmailTransportConfigured(domFileElement, springModel);
    }

    private static boolean isEmbeddedHttpServerTransportConfigured(DomFileElement<Beans> domFileElement, CommonSpringModel springModel) {
        return SpringWebServicesConfigurationsInspection.hasBeansOfType(domFileElement, springModel, "org.springframework.remoting.support.SimpleHttpServerFactoryBean");
    }

    private static boolean isEmailTransportConfigured(DomFileElement<Beans> domFileElement, CommonSpringModel springModel) {
        return SpringWebServicesConfigurationsInspection.hasBeansOfType(domFileElement, springModel, "org.springframework.ws.transport.mail.MailMessageReceiver");
    }

    private static boolean isJmsTransportConfigured(DomFileElement<Beans> domFileElement, @NotNull CommonSpringModel springModel) {
        if (springModel == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(11);
        }
        return SpringWebServicesConfigurationsInspection.hasBeansOfType(domFileElement, springModel, "org.springframework.jms.listener.AbstractJmsListeningContainer");
    }

    private static boolean isWiringUpSpringWebServicesInDispatcherServlet(DomFileElement<Beans> domFileElement, @NotNull CommonSpringModel springModel) {
        if (springModel == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(12);
        }
        return SpringWebServicesConfigurationsInspection.hasBeansOfType(domFileElement, springModel, "org.springframework.ws.transport.http.WebServiceMessageReceiverHandlerAdapter");
    }

    private static boolean hasBeansOfType(DomFileElement<Beans> domFileElement, CommonSpringModel springModel, String fqn) {
        PsiClass psiClass = DomJavaUtil.findClass((String)fqn, domFileElement);
        return psiClass != null && SpringModelSearchers.doesBeanExist((CommonSpringModel)springModel, (PsiClass)psiClass);
    }

    private static void checkFileNameAndLocation(@NotNull DomFileElement<Beans> domFileElement, @NotNull DomElementAnnotationHolder holder, @NotNull Servlet messageDispatcherServlet) {
        if (domFileElement == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(14);
        }
        if (messageDispatcherServlet == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(15);
        }
        if (SpringWebServicesUtil.getContextConfigurationParam(messageDispatcherServlet) != null) {
            return;
        }
        XmlFile xmlFile = domFileElement.getFile();
        String servletName = messageDispatcherServlet.getServletName().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)servletName)) {
            String contextFileName = SpringWebServicesUtil.getApplicationContextFileName(servletName);
            if (contextFileName.equals(xmlFile.getName())) {
                if (!SpringWebServicesConfigurationsInspection.isFileInWebInfDirectory(xmlFile)) {
                    holder.createProblem(domFileElement.getRootElement(), HighlightSeverity.ERROR, SpringWebServicesBundle.message("SpringWebServicesConfigurationsInspection.should.be.located.in.web.inf", new Object[0]));
                }
            } else {
                holder.createProblem(domFileElement.getRootElement(), HighlightSeverity.ERROR, SpringWebServicesBundle.message("SpringWebServicesConfigurationsInspection.should.be.configured.with.specific.file.name", SpringWebServicesUtil.getApplicationContextRelativePath(servletName)));
            }
        }
    }

    private static boolean isFileInWebInfDirectory(@NotNull XmlFile xmlFile) {
        PsiDirectory psiDirectory;
        if (xmlFile == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(16);
        }
        return (psiDirectory = xmlFile.getParent()) != null && "WEB-INF".equals(psiDirectory.getName());
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringWebServicesConfigurationsInspection" == null) {
            SpringWebServicesConfigurationsInspection.$$$reportNull$$$0(17);
        }
        return "SpringWebServicesConfigurationsInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domFileElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageDispatcherServlet";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFixes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerEmbeddedHttpTransportFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerEmailTransportFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerJmsTransportFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getWebApp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getServletName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSpringWebServiceTransportConfigured";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isJmsTransportConfigured";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isWiringUpSpringWebServicesInDispatcherServlet";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkFileNameAndLocation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isFileInWebInfDirectory";
                break;
            }
            case 17: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

