/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.ImportFilter;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportClassFixBase<T extends PsiElement, R extends PsiReference>
implements HintAction,
HighPriorityAction {
    @NotNull
    private final T myElement;
    @NotNull
    private final R myRef;

    protected ImportClassFixBase(@NotNull T elem, @NotNull R ref) {
        if (elem == null) {
            ImportClassFixBase.$$$reportNull$$$0(0);
        }
        if (ref == null) {
            ImportClassFixBase.$$$reportNull$$$0(1);
        }
        this.myElement = elem;
        this.myRef = ref;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiFile file) {
        PsiExpression expression2;
        if (project == null) {
            ImportClassFixBase.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ImportClassFixBase.$$$reportNull$$$0(3);
        }
        if (!this.myElement.isValid()) {
            return false;
        }
        PsiElement parent = this.myElement.getParent();
        if (parent instanceof PsiNewExpression && ((PsiNewExpression)parent).getQualifier() != null) {
            return false;
        }
        if (parent instanceof PsiReferenceExpression && (expression2 = ((PsiReferenceExpression)parent).getQualifierExpression()) != null && expression2 != this.myElement) {
            return false;
        }
        return !this.getClassesToImport(true).isEmpty();
    }

    @Nullable
    protected abstract String getReferenceName(@NotNull R var1);

    protected abstract PsiElement getReferenceNameElement(@NotNull R var1);

    protected abstract boolean hasTypeParameters(@NotNull R var1);

    @NotNull
    public List<PsiClass> getClassesToImport() {
        List<PsiClass> list = this.getClassesToImport(false);
        if (list == null) {
            ImportClassFixBase.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<PsiClass> getClassesToImport(boolean acceptWrongNumberOfTypeParams) {
        List<PsiClass> filtered;
        JavaResolveResult result;
        PsiElement element;
        if (this.myRef instanceof PsiJavaReference && (element = (result = ((PsiJavaReference)this.myRef).advancedResolve(true)).getElement()) instanceof PsiClass && result.isValidResult()) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                ImportClassFixBase.$$$reportNull$$$0(5);
            }
            return list;
        }
        String name = this.getReferenceName(this.myRef);
        GlobalSearchScope scope = this.myElement.getResolveScope();
        if (name == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                ImportClassFixBase.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (!this.canReferenceClass(this.myRef)) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                ImportClassFixBase.$$$reportNull$$$0(7);
            }
            return list;
        }
        boolean referenceHasTypeParameters = this.hasTypeParameters(this.myRef);
        Project project = this.myElement.getProject();
        PsiClass[] classes2 = PsiShortNamesCache.getInstance((Project)project).getClassesByName(name, scope);
        if (classes2.length == 0) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                ImportClassFixBase.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<PsiClass> classList = new ArrayList<PsiClass>(classes2.length);
        boolean isAnnotationReference = this.myElement.getParent() instanceof PsiAnnotation;
        PsiFile file = this.myElement.getContainingFile();
        for (PsiClass aClass2 : classes2) {
            String qName;
            if (isAnnotationReference && !aClass2.isAnnotationType() || JavaCompletionUtil.isInExcludedPackage((PsiMember)aClass2, false) || !acceptWrongNumberOfTypeParams && referenceHasTypeParameters && !aClass2.hasTypeParameters() || (qName = aClass2.getQualifiedName()) == null || qName.indexOf(46) == -1 || !PsiNameHelper.getInstance((Project)project).isQualifiedName(qName) || !qName.endsWith(name) || file != null && !ImportFilter.shouldImport((PsiFile)file, (String)qName)) continue;
            classList.add(aClass2);
        }
        boolean anyAccessibleFound = classList.stream().anyMatch(aClass -> this.isAccessible((PsiMember)aClass, this.myElement));
        PsiManager manager = this.myElement.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        classList.removeIf(aClass -> (anyAccessibleFound || !BaseIntentionAction.canModify((PsiElement)aClass) || facade.arePackagesTheSame((PsiElement)aClass, this.myElement)) && !this.isAccessible((PsiMember)aClass, this.myElement));
        if (acceptWrongNumberOfTypeParams && referenceHasTypeParameters) {
            ArrayList<PsiClass> candidates = new ArrayList<PsiClass>();
            Iterator<PsiClass> iterator = classList.iterator();
            while (iterator.hasNext()) {
                PsiClass aClass3 = iterator.next();
                if (aClass3.hasTypeParameters()) continue;
                iterator.remove();
                candidates.add(aClass3);
            }
            if (classList.isEmpty()) {
                classList.addAll(candidates);
            }
        }
        if (!(filtered = this.filterByContext(classList = this.filterByRequiredMemberName(classList), this.myElement)).isEmpty()) {
            classList = filtered;
        }
        this.filerByPackageName(classList, file);
        List<PsiClass> list = ImportClassFixBase.removeDuplicates(classList);
        if (list == null) {
            ImportClassFixBase.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static List<PsiClass> removeDuplicates(List<PsiClass> classList) {
        HashSet uniqueNames = new HashSet();
        classList.removeIf(aClass -> !uniqueNames.add(aClass.getQualifiedName()));
        return classList;
    }

    protected void filerByPackageName(List<PsiClass> classList, PsiFile file) {
        String packageName = StringUtil.getPackageName((String)this.getQualifiedName(this.myElement));
        if (!packageName.isEmpty() && file instanceof PsiJavaFile && Arrays.binarySearch(((PsiJavaFile)file).getImplicitlyImportedPackages(), packageName) < 0) {
            Iterator<PsiClass> iterator = classList.iterator();
            while (iterator.hasNext()) {
                String classQualifiedName = iterator.next().getQualifiedName();
                if (classQualifiedName == null || packageName.equals(StringUtil.getPackageName((String)classQualifiedName))) continue;
                iterator.remove();
            }
        }
    }

    protected boolean canReferenceClass(R ref) {
        return true;
    }

    private List<PsiClass> filterByRequiredMemberName(List<PsiClass> classList) {
        List filtered;
        String memberName = this.getRequiredMemberName(this.myElement);
        if (memberName != null && !(filtered = ContainerUtil.findAll(classList, psiClass -> {
            PsiField field = psiClass.findFieldByName(memberName, true);
            if (field != null && field.hasModifierProperty("static") && this.isAccessible((PsiMember)field, this.myElement)) {
                return true;
            }
            PsiClass inner = psiClass.findInnerClassByName(memberName, true);
            if (inner != null && this.isAccessible((PsiMember)inner, this.myElement)) {
                return true;
            }
            for (PsiMethod method : psiClass.findMethodsByName(memberName, true)) {
                if (!method.hasModifierProperty("static") || !this.isAccessible((PsiMember)method, this.myElement)) continue;
                return true;
            }
            return false;
        })).isEmpty()) {
            classList = filtered;
        }
        return classList;
    }

    private void filterAlreadyImportedButUnresolved(@NotNull List<PsiClass> list) {
        PsiElement element;
        PsiFile containingFile;
        if (list == null) {
            ImportClassFixBase.$$$reportNull$$$0(10);
        }
        PsiFile psiFile = containingFile = (element = this.myRef.getElement()) == null ? null : element.getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)containingFile;
        PsiImportList importList = javaFile.getImportList();
        PsiImportStatementBase[] importStatements = importList == null ? PsiImportStatementBase.EMPTY_ARRAY : importList.getAllImportStatements();
        THashSet importedNames = new THashSet(importStatements.length);
        for (PsiImportStatementBase statement : importStatements) {
            String name;
            PsiJavaCodeReferenceElement ref = statement.getImportReference();
            String string = name = ref == null ? null : ref.getReferenceName();
            if (name == null || ref.resolve() != null) continue;
            importedNames.add(name);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            PsiClass aClass = list.get(i);
            String className = aClass.getName();
            if (className == null || !importedNames.contains(className)) continue;
            list.remove(i);
        }
    }

    @Nullable
    protected String getRequiredMemberName(T reference) {
        return null;
    }

    @NotNull
    protected List<PsiClass> filterByContext(@NotNull List<PsiClass> candidates, @NotNull T ref) {
        if (candidates == null) {
            ImportClassFixBase.$$$reportNull$$$0(11);
        }
        if (ref == null) {
            ImportClassFixBase.$$$reportNull$$$0(12);
        }
        List<PsiClass> list = candidates;
        if (list == null) {
            ImportClassFixBase.$$$reportNull$$$0(13);
        }
        return list;
    }

    protected abstract boolean isAccessible(PsiMember var1, T var2);

    protected abstract String getQualifiedName(T var1);

    protected static List<PsiClass> filterAssignableFrom(PsiType type2, List<PsiClass> candidates) {
        PsiClass actualClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (actualClass != null) {
            return ContainerUtil.findAll(candidates, psiClass -> InheritanceUtil.isInheritorOrSelf((PsiClass)actualClass, (PsiClass)psiClass, (boolean)true));
        }
        return candidates;
    }

    protected static List<PsiClass> filterBySuperMethods(PsiParameter parameter2, List<PsiClass> candidates) {
        PsiMethod method;
        PsiElement granny;
        PsiElement parent = parameter2.getParent();
        if (parent instanceof PsiParameterList && (granny = parent.getParent()) instanceof PsiMethod && (method = (PsiMethod)granny).getModifierList().hasAnnotation("java.lang.Override")) {
            PsiClass aClass = method.getContainingClass();
            HashSet probableTypes = new HashSet();
            InheritanceUtil.processSupers((PsiClass)aClass, (boolean)false, psiClass -> {
                for (PsiMethod psiMethod : psiClass.findMethodsByName(method.getName(), false)) {
                    for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                        ContainerUtil.addIfNotNull((Collection)probableTypes, (Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)psiParameter.getType()));
                    }
                }
                return true;
            });
            List filtered = ContainerUtil.filter(candidates, psiClass -> probableTypes.contains(psiClass));
            if (!filtered.isEmpty()) {
                return filtered;
            }
        }
        return candidates;
    }

    public Result doFix(@NotNull Editor editor, boolean allowPopup, boolean allowCaretNearRef) {
        boolean isInModlessContext;
        if (editor == null) {
            ImportClassFixBase.$$$reportNull$$$0(14);
        }
        List<PsiClass> classesToImport = this.getClassesToImport();
        this.filterAlreadyImportedButUnresolved(classesToImport);
        if (classesToImport.isEmpty()) {
            return Result.POPUP_NOT_SHOWN;
        }
        try {
            Pattern pattern;
            Matcher matcher;
            String name = this.getQualifiedName(this.myElement);
            if (name != null && (matcher = (pattern = Pattern.compile(DaemonCodeAnalyzerSettings.getInstance().NO_AUTO_IMPORT_PATTERN)).matcher(name)).matches()) {
                return Result.POPUP_NOT_SHOWN;
            }
        }
        catch (PatternSyntaxException name) {
            // empty catch block
        }
        PsiFile psiFile = this.myElement.getContainingFile();
        if (classesToImport.size() > 1) {
            ImportClassFixBase.reduceSuggestedClassesBasedOnDependencyRuleViolation(psiFile, classesToImport);
        }
        PsiClass[] classes2 = classesToImport.toArray(PsiClass.EMPTY_ARRAY);
        Project project = this.myElement.getProject();
        CodeInsightUtil.sortIdenticalShortNamedMembers((PsiMember[])classes2, this.myRef);
        AddImportAction action = this.createAddImportAction(classes2, project, editor);
        boolean canImportHere = true;
        boolean bl = Registry.is((String)"ide.perProjectModality") ? !LaterInvocator.isInModalContextForProject((Project)editor.getProject()) : (isInModlessContext = !LaterInvocator.isInModalContext());
        if (classes2.length == 1 && (canImportHere = this.canImportHere(allowCaretNearRef, editor, psiFile, classes2[0].getName())) && ImportClassFixBase.isAddUnambiguousImportsOnTheFlyEnabled(psiFile) && (ApplicationManager.getApplication().isUnitTestMode() || DaemonListeners.canChangeFileSilently((PsiFileSystemItem)psiFile)) && isInModlessContext && !ImportClassFixBase.autoImportWillInsertUnexpectedCharacters(classes2[0])) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> action.execute());
            return Result.CLASS_AUTO_IMPORTED;
        }
        if (allowPopup && canImportHere) {
            String hintText = ShowAutoImportPass.getMessage((classes2.length > 1 ? 1 : 0) != 0, (String)classes2[0].getQualifiedName());
            if (!ApplicationManager.getApplication().isUnitTestMode() && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
                HintManager.getInstance().showQuestionHint(editor, hintText, this.getStartOffset(this.myElement, this.myRef), this.getEndOffset(this.myElement, this.myRef), (QuestionAction)action);
            }
            return Result.POPUP_SHOWN;
        }
        return Result.POPUP_NOT_SHOWN;
    }

    public static boolean isAddUnambiguousImportsOnTheFlyEnabled(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ImportClassFixBase.$$$reportNull$$$0(15);
        }
        return FileTypeUtils.isInServerPageFile((PsiElement)psiFile) ? CodeInsightSettings.getInstance().JSP_ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY : CodeInsightSettings.getInstance().ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY;
    }

    protected int getStartOffset(T element, R ref) {
        return element.getTextOffset();
    }

    protected int getEndOffset(T element, R ref) {
        return element.getTextRange().getEndOffset();
    }

    private static boolean autoImportWillInsertUnexpectedCharacters(PsiClass aClass) {
        PsiClass containingClass = aClass.getContainingClass();
        return containingClass != null && !((JavaCodeStyleSettings)CodeStyle.getSettings((PsiFile)aClass.getContainingFile()).getCustomSettings(JavaCodeStyleSettings.class)).INSERT_INNER_CLASS_IMPORTS;
    }

    private boolean canImportHere(boolean allowCaretNearRef, Editor editor, PsiFile psiFile, String exampleClassName) {
        return (allowCaretNearRef || !this.isCaretNearRef(editor, this.myRef)) && !this.hasUnresolvedImportWhichCanImport(psiFile, exampleClassName);
    }

    protected abstract boolean isQualified(R var1);

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            ImportClassFixBase.$$$reportNull$$$0(16);
        }
        if (this.isQualified(this.myRef)) {
            return false;
        }
        Result result = this.doFix(editor, true, false);
        return result == Result.POPUP_SHOWN || result == Result.CLASS_AUTO_IMPORTED;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("import.class.fix", new Object[0]);
        if (string == null) {
            ImportClassFixBase.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("import.class.fix", new Object[0]);
        if (string == null) {
            ImportClassFixBase.$$$reportNull$$$0(18);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract boolean hasUnresolvedImportWhichCanImport(PsiFile var1, String var2);

    private static void reduceSuggestedClassesBasedOnDependencyRuleViolation(PsiFile file, List<? extends PsiClass> availableClasses) {
        Project project = file.getProject();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)project);
        for (int i = availableClasses.size() - 1; i >= 0; --i) {
            DependencyRule[] violated;
            PsiClass psiClass = availableClasses.get(i);
            PsiFile targetFile = psiClass.getContainingFile();
            if (targetFile == null || (violated = validationManager.getViolatorDependencyRules(file, targetFile)).length == 0) continue;
            availableClasses.remove(i);
            if (availableClasses.size() == 1) break;
        }
    }

    private boolean isCaretNearRef(@NotNull Editor editor, @NotNull R ref) {
        PsiElement nameElement;
        if (editor == null) {
            ImportClassFixBase.$$$reportNull$$$0(19);
        }
        if (ref == null) {
            ImportClassFixBase.$$$reportNull$$$0(20);
        }
        if ((nameElement = this.getReferenceNameElement(ref)) == null) {
            return false;
        }
        TextRange range = nameElement.getTextRange();
        int offset = editor.getCaretModel().getOffset();
        return offset == range.getEndOffset();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ImportClassFixBase.$$$reportNull$$$0(21);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            List<PsiClass> classesToImport;
            PsiClass[] classes2;
            if (project == null) {
                ImportClassFixBase.$$$reportNull$$$0(22);
            }
            if ((classes2 = (classesToImport = this.getClassesToImport(true)).toArray(PsiClass.EMPTY_ARRAY)).length == 0) {
                return;
            }
            AddImportAction action = this.createAddImportAction(classes2, project, editor);
            action.execute();
        });
    }

    protected void bindReference(PsiReference reference, PsiClass targetClass) {
        reference.bindToElement((PsiElement)targetClass);
    }

    protected AddImportAction createAddImportAction(PsiClass[] classes2, Project project, Editor editor) {
        return new AddImportAction(project, (PsiReference)this.myRef, editor, classes2){

            @Override
            protected void bindReference(PsiReference ref, PsiClass targetClass) {
                ImportClassFixBase.this.bindReference(ref, targetClass);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 1: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesToImport";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByContext";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterAlreadyImportedButUnresolved";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterByContext";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAddUnambiguousImportsOnTheFlyEnabled";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isCaretNearRef";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$8";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Result {
        POPUP_SHOWN,
        CLASS_AUTO_IMPORTED,
        POPUP_NOT_SHOWN;

    }
}

