/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class SwitchStatementBranch {
    private final Set<PsiElement> myPendingDeclarations = new HashSet<PsiElement>(5);
    private final List<String> myCaseValues = new ArrayList<String>(2);
    private final List<PsiElement> myBodyElements = new ArrayList<PsiElement>(5);
    private final List<PsiElement> myPendingWhiteSpace = new ArrayList<PsiElement>(2);
    private boolean myDefault;
    private boolean myHasStatements;
    private boolean myAlwaysExecuted;

    SwitchStatementBranch() {
    }

    public void addCaseValue(String labelString) {
        this.myCaseValues.add(labelString);
    }

    public void addStatement(PsiStatement statement) {
        this.myHasStatements = this.myHasStatements || !ControlFlowUtils.isEmpty((PsiElement)statement, false, true);
        this.addElement((PsiElement)statement);
    }

    public void addComment(PsiElement comment) {
        this.addElement(comment);
    }

    private void addElement(PsiElement element) {
        this.myBodyElements.addAll(this.myPendingWhiteSpace);
        this.myPendingWhiteSpace.clear();
        this.myBodyElements.add(element);
    }

    public void addWhiteSpace(PsiElement statement) {
        if (!this.myBodyElements.isEmpty()) {
            this.myPendingWhiteSpace.add(statement);
        }
    }

    public List<String> getCaseValues() {
        return Collections.unmodifiableList(this.myCaseValues);
    }

    public List<PsiElement> getBodyElements() {
        return Collections.unmodifiableList(this.myBodyElements);
    }

    public boolean isDefault() {
        return this.myDefault;
    }

    public void setDefault() {
        this.myDefault = true;
    }

    boolean isAlwaysExecuted() {
        return this.myAlwaysExecuted;
    }

    void setAlwaysExecuted(boolean alwaysExecuted) {
        this.myAlwaysExecuted = alwaysExecuted;
    }

    public boolean hasStatements() {
        return this.myHasStatements;
    }

    public void addPendingDeclarations(Set<? extends PsiElement> vars) {
        this.myPendingDeclarations.addAll(vars);
    }

    public Set<PsiElement> getPendingDeclarations() {
        return Collections.unmodifiableSet(this.myPendingDeclarations);
    }
}

