/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CreateFieldFromParameterAction;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.codeInsight.intention.impl.ParameterClassMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BindFieldsFromParametersAction
extends BaseIntentionAction
implements HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(CreateFieldFromParameterAction.class);
    private static final Key<Map<SmartPsiElementPointer<PsiParameter>, Boolean>> PARAMS = Key.create((String)"FIELDS_FROM_PARAMS");
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiParameter psiParameter;
        PsiMethod method;
        if (project == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(0);
        }
        if ((method = BindFieldsFromParametersAction.findMethod(psiParameter = FieldFromParameterUtils.findParameterAtCursor(file, editor), editor, file)) == null) {
            return false;
        }
        List<PsiParameter> parameters2 = BindFieldsFromParametersAction.getAvailableParameters(method);
        Object object = LOCK;
        synchronized (object) {
            Collection<SmartPsiElementPointer<PsiParameter>> params = BindFieldsFromParametersAction.getUnboundedParams(method);
            params.clear();
            for (PsiParameter parameter2 : parameters2) {
                params.add((SmartPsiElementPointer<PsiParameter>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)parameter2));
            }
            if (params.size() == 1 && psiParameter != null) {
                return false;
            }
            Iterator<SmartPsiElementPointer<PsiParameter>> iterator = params.iterator();
            if (!iterator.hasNext()) {
                return false;
            }
            if (psiParameter == null) {
                psiParameter = (PsiParameter)iterator.next().getElement();
                LOG.assertTrue(psiParameter != null);
            }
            this.setText(CodeInsightBundle.message((String)"intention.bind.fields.from.parameters.text", (Object[])new Object[]{method.isConstructor() ? "constructor" : "method"}));
        }
        return BindFieldsFromParametersAction.isAvailable(psiParameter);
    }

    @Nullable
    private static PsiMethod findMethod(@Nullable PsiParameter parameter2, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(2);
        }
        if (parameter2 == null) {
            PsiElement parent;
            PsiElement elementAt = file.findElementAt(editor.getCaretModel().getOffset());
            if (elementAt instanceof PsiIdentifier && (parent = elementAt.getParent()) instanceof PsiMethod) {
                return (PsiMethod)parent;
            }
        } else {
            PsiElement declarationScope = parameter2.getDeclarationScope();
            if (declarationScope instanceof PsiMethod) {
                return (PsiMethod)declarationScope;
            }
        }
        return null;
    }

    @NotNull
    private static List<PsiParameter> getAvailableParameters(@NotNull PsiMethod method) {
        if (method == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(3);
        }
        ArrayList<PsiParameter> parameters2 = new ArrayList<PsiParameter>();
        for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
            if (!BindFieldsFromParametersAction.isAvailable(parameter2)) continue;
            parameters2.add(parameter2);
        }
        ArrayList<PsiParameter> arrayList = parameters2;
        if (arrayList == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static boolean isAvailable(PsiParameter psiParameter) {
        PsiClass targetClass;
        PsiType type2 = FieldFromParameterUtils.getSubstitutedType(psiParameter);
        return FieldFromParameterUtils.isAvailable(psiParameter, type2, targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiParameter, PsiClass.class)) && psiParameter.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @NotNull
    private static Collection<SmartPsiElementPointer<PsiParameter>> getUnboundedParams(PsiMethod psiMethod) {
        Map params = (Map)psiMethod.getUserData(PARAMS);
        if (params == null) {
            params = ContainerUtil.createConcurrentWeakMap();
            psiMethod.putUserData(PARAMS, (Object)params);
        }
        final Map finalParams = params;
        AbstractCollection<SmartPsiElementPointer<PsiParameter>> abstractCollection = new AbstractCollection<SmartPsiElementPointer<PsiParameter>>(){

            @Override
            public boolean add(SmartPsiElementPointer<PsiParameter> psiVariable) {
                return finalParams.put(psiVariable, Boolean.TRUE) == null;
            }

            @Override
            public Iterator<SmartPsiElementPointer<PsiParameter>> iterator() {
                return finalParams.keySet().iterator();
            }

            @Override
            public int size() {
                return finalParams.size();
            }

            @Override
            public void clear() {
                finalParams.clear();
            }
        };
        if (abstractCollection == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(5);
        }
        return abstractCollection;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.bind.fields.from.parameters.family", (Object[])new Object[0]);
        if (string == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(7);
        }
        BindFieldsFromParametersAction.invoke(project, editor, file, !ApplicationManager.getApplication().isUnitTestMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invoke(Project project, Editor editor, PsiFile file, boolean isInteractive) {
        PsiParameter psiParameter = FieldFromParameterUtils.findParameterAtCursor(file, editor);
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiMethod method = psiParameter != null ? (PsiMethod)psiParameter.getDeclarationScope() : (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PsiMethod.class);
        LOG.assertTrue(method != null);
        HashSet usedNames = new HashSet();
        Iterable<PsiParameter> parameters2 = BindFieldsFromParametersAction.selectParameters(project, method, BindFieldsFromParametersAction.copyUnboundedParamsAndClearOriginal(method), isInteractive);
        MultiMap types = new MultiMap();
        for (PsiParameter parameter2 : parameters2) {
            types.putValue((Object)parameter2.getType(), (Object)parameter2);
        }
        JavaCodeStyleSettings settings = JavaCodeStyleSettings.getInstance(file);
        boolean preferLongerNames = settings.PREFER_LONGER_NAMES;
        for (PsiParameter selected : parameters2) {
            try {
                settings.PREFER_LONGER_NAMES = preferLongerNames || types.get((Object)selected.getType()).size() > 1;
                BindFieldsFromParametersAction.processParameter(project, selected, usedNames);
            }
            finally {
                settings.PREFER_LONGER_NAMES = preferLongerNames;
            }
        }
    }

    @NotNull
    private static Iterable<PsiParameter> selectParameters(@NotNull Project project, @NotNull PsiMethod method, @NotNull Collection<SmartPsiElementPointer<PsiParameter>> unboundedParams, boolean isInteractive) {
        if (project == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(8);
        }
        if (method == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(9);
        }
        if (unboundedParams == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(10);
        }
        if (unboundedParams.size() < 2 || !isInteractive) {
            List<PsiParameter> list = BindFieldsFromParametersAction.revealPointers(unboundedParams);
            if (list == null) {
                BindFieldsFromParametersAction.$$$reportNull$$$0(11);
            }
            return list;
        }
        ParameterClassMember[] members = BindFieldsFromParametersAction.sortByParameterIndex(BindFieldsFromParametersAction.toClassMemberArray(unboundedParams), method);
        MemberChooser<ParameterClassMember> chooser = BindFieldsFromParametersAction.showChooser(project, method, members);
        List selectedElements = chooser.getSelectedElements();
        if (chooser.getExitCode() != 0 || selectedElements == null) {
            List<PsiParameter> list = Collections.emptyList();
            if (list == null) {
                BindFieldsFromParametersAction.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<PsiParameter> list = BindFieldsFromParametersAction.revealParameterClassMembers(selectedElements);
        if (list == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private static MemberChooser<ParameterClassMember> showChooser(@NotNull Project project, @NotNull PsiMethod method, @NotNull ParameterClassMember[] members) {
        if (project == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(14);
        }
        if (method == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(15);
        }
        if (members == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(16);
        }
        MemberChooser chooser = new MemberChooser((ClassMember[])members, false, true, project);
        chooser.selectElements((ClassMember[])BindFieldsFromParametersAction.getInitialSelection(method, members));
        chooser.setTitle("Choose " + (method.isConstructor() ? "Constructor" : "Method") + " Parameters");
        chooser.show();
        MemberChooser memberChooser = chooser;
        if (memberChooser == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(17);
        }
        return memberChooser;
    }

    private static ParameterClassMember[] getInitialSelection(@NotNull PsiMethod method, @NotNull ParameterClassMember[] members) {
        PsiMethod calledMethod;
        PsiExpression expression2;
        if (method == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(18);
        }
        if (members == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(19);
        }
        HashSet resolvedInSuperOrThis = new HashSet();
        PsiCodeBlock body2 = method.getBody();
        LOG.assertTrue(body2 != null);
        PsiStatement[] statements = body2.getStatements();
        if (statements.length > 0 && statements[0] instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && (calledMethod = ((PsiMethodCallExpression)expression2).resolveMethod()) != null && calledMethod.isConstructor()) {
            for (PsiExpression arg : ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions()) {
                if (!(arg instanceof PsiReferenceExpression)) continue;
                ContainerUtil.addIfNotNull(resolvedInSuperOrThis, (Object)((PsiReferenceExpression)arg).resolve());
            }
        }
        return ContainerUtil.findAll((Object[])members, member -> !resolvedInSuperOrThis.contains(member.getParameter())).toArray(ParameterClassMember.EMPTY_ARRAY);
    }

    @NotNull
    private static ParameterClassMember[] sortByParameterIndex(@NotNull ParameterClassMember[] members, @NotNull PsiMethod method) {
        if (members == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(20);
        }
        if (method == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(21);
        }
        PsiParameterList parameterList = method.getParameterList();
        Arrays.sort(members, Comparator.comparingInt(o -> parameterList.getParameterIndex(o.getParameter())));
        if (members == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(22);
        }
        return members;
    }

    @NotNull
    private static <T extends PsiElement> List<T> revealPointers(@NotNull Iterable<SmartPsiElementPointer<T>> pointers) {
        if (pointers == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(23);
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (SmartPsiElementPointer<T> pointer : pointers) {
            result.add(pointer.getElement());
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiParameter> revealParameterClassMembers(@NotNull Iterable<ParameterClassMember> parameterClassMembers) {
        if (parameterClassMembers == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(25);
        }
        ArrayList<PsiParameter> result = new ArrayList<PsiParameter>();
        for (ParameterClassMember parameterClassMember : parameterClassMembers) {
            result.add(parameterClassMember.getParameter());
        }
        ArrayList<PsiParameter> arrayList = result;
        if (arrayList == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    private static ParameterClassMember[] toClassMemberArray(@NotNull Collection<SmartPsiElementPointer<PsiParameter>> unboundedParams) {
        if (unboundedParams == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(27);
        }
        ParameterClassMember[] result = new ParameterClassMember[unboundedParams.size()];
        int i = 0;
        for (SmartPsiElementPointer<PsiParameter> pointer : unboundedParams) {
            result[i++] = new ParameterClassMember((PsiParameter)pointer.getElement());
        }
        if (result == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(28);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static Collection<SmartPsiElementPointer<PsiParameter>> copyUnboundedParamsAndClearOriginal(@NotNull PsiMethod method) {
        if (method == null) {
            BindFieldsFromParametersAction.$$$reportNull$$$0(29);
        }
        Object object = LOCK;
        // MONITORENTER : object
        Collection<SmartPsiElementPointer<PsiParameter>> unboundedParams = BindFieldsFromParametersAction.getUnboundedParams(method);
        ArrayList<SmartPsiElementPointer<PsiParameter>> result = new ArrayList<SmartPsiElementPointer<PsiParameter>>(unboundedParams);
        unboundedParams.clear();
        ArrayList<SmartPsiElementPointer<PsiParameter>> arrayList = result;
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        BindFieldsFromParametersAction.$$$reportNull$$$0(30);
        return arrayList;
    }

    private static void processParameter(Project project, PsiParameter parameter2, Set<? super String> usedNames) {
        IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
        PsiType type2 = FieldFromParameterUtils.getSubstitutedType(parameter2);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        String parameterName = parameter2.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parameter2, PsiClass.class);
        PsiElement declarationScope = parameter2.getDeclarationScope();
        if (!(declarationScope instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)declarationScope;
        boolean isMethodStatic = method.hasModifierProperty("static");
        VariableKind kind2 = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind2, propertyName, null, type2);
        String[] names = suggestedNameInfo.names;
        boolean isFinal = !isMethodStatic && method.isConstructor();
        String name = names[0];
        if (targetClass != null) {
            for (String curName : names) {
                PsiField fieldByName;
                if (usedNames.contains(curName) || (fieldByName = targetClass.findFieldByName(curName, false)) == null || method.isConstructor() && BindFieldsFromParametersAction.isFieldAssigned(fieldByName, method) || !fieldByName.getType().isAssignableFrom(parameter2.getType())) continue;
                name = curName;
                break;
            }
        }
        if (usedNames.contains(name)) {
            for (String curName : names) {
                if (usedNames.contains(curName)) continue;
                name = curName;
                break;
            }
        }
        String fieldName = usedNames.add(name) ? name : JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(name, (PsiElement)parameter2, true);
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                FieldFromParameterUtils.createFieldAndAddAssignment(project, targetClass, method, parameter2, type2, fieldName, isMethodStatic, isFinal);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private static boolean isFieldAssigned(PsiField field, PsiMethod method) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement)method))) {
            if (!(reference instanceof PsiReferenceExpression) || !PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiReferenceExpression)reference))) continue;
            return true;
        }
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 9: 
            case 15: 
            case 18: 
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction";
                break;
            }
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unboundedParams";
                break;
            }
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterClassMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnboundedParams";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "selectParameters";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "showChooser";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "sortByParameterIndex";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "revealPointers";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "revealParameterClassMembers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "toClassMemberArray";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "copyUnboundedParamsAndClearOriginal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableParameters";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectParameters";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showChooser";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getInitialSelection";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sortByParameterIndex";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "revealPointers";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "revealParameterClassMembers";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toClassMemberArray";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "copyUnboundedParamsAndClearOriginal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

