/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSwitchIntention
extends BaseElementAtCaretIntentionAction
implements LowPriorityAction {
    public static final String TEXT = "Create switch statement";

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiJavaToken lBrace;
        if (project == null) {
            CreateSwitchIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            CreateSwitchIntention.$$$reportNull$$$0(1);
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionStatement.class, (boolean)false);
        String valueToSwitch = expressionStatement.getExpression().getText();
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)new CommentTracker().replaceAndRestoreComments((PsiElement)expressionStatement, "switch (" + valueToSwitch + ") {}");
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)switchStatement);
        PsiCodeBlock body2 = switchStatement.getBody();
        PsiJavaToken psiJavaToken = lBrace = body2 == null ? null : body2.getLBrace();
        if (lBrace != null) {
            editor.getCaretModel().moveToOffset(lBrace.getTextRange().getEndOffset());
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiExpressionStatement expressionStatement;
        if (project == null) {
            CreateSwitchIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            CreateSwitchIntention.$$$reportNull$$$0(3);
        }
        return (expressionStatement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionStatement.class, (boolean)false)) != null && expressionStatement.getParent() instanceof PsiCodeBlock && PsiTreeUtil.findChildOfType((PsiElement)expressionStatement.getExpression(), PsiErrorElement.class) == null && CreateSwitchIntention.isValidTypeForSwitch(expressionStatement.getExpression().getType(), (PsiElement)expressionStatement);
    }

    private static boolean isValidTypeForSwitch(@Nullable PsiType type2, PsiElement context) {
        if (type2 == null) {
            return false;
        }
        if (type2 instanceof PsiClassType) {
            PsiClass resolvedClass = ((PsiClassType)type2).resolve();
            if (resolvedClass == null) {
                return false;
            }
            return PsiUtil.isLanguageLevel5OrHigher((PsiElement)context) && resolvedClass.isEnum() || PsiUtil.isLanguageLevel7OrHigher((PsiElement)context) && "java.lang.String".equals(resolvedClass.getQualifiedName());
        }
        return type2.equals(PsiType.INT) || type2.equals(PsiType.BYTE) || type2.equals(PsiType.SHORT) || type2.equals(PsiType.CHAR);
    }

    @NotNull
    public String getFamilyName() {
        if (TEXT == null) {
            CreateSwitchIntention.$$$reportNull$$$0(4);
        }
        return TEXT;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            CreateSwitchIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/CreateSwitchIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/CreateSwitchIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

