/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyBooleanExpressionAction
implements IntentionAction {
    private String myText = this.getFamilyName();

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            SimplifyBooleanExpressionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SimplifyBooleanExpressionFix.FAMILY_NAME;
        if (string == null) {
            SimplifyBooleanExpressionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiExpression expression2;
        if (project == null) {
            SimplifyBooleanExpressionAction.$$$reportNull$$$0(2);
        }
        if ((expression2 = SimplifyBooleanExpressionAction.getExpressionToSimplify(editor, file)) != null && SimplifyBooleanExpressionFix.canBeSimplified(expression2)) {
            Object o = JavaConstantExpressionEvaluator.computeConstantExpression(expression2, false);
            this.myText = o instanceof Boolean ? SimplifyBooleanExpressionFix.getIntentionText(expression2, (Boolean)o) : this.getFamilyName();
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiExpression getExpressionToSimplify(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiExpression expression2;
        int offset;
        PsiElement element;
        if (editor == null) {
            SimplifyBooleanExpressionAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            SimplifyBooleanExpressionAction.$$$reportNull$$$0(4);
        }
        if ((element = file.findElementAt(offset = editor.getCaretModel().getOffset())) == null) {
            return null;
        }
        PsiExpression parent = expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class);
        while (parent instanceof PsiExpression && !(parent instanceof PsiAssignmentExpression) && (PsiType.BOOLEAN.equals((Object)parent.getType()) || parent instanceof PsiConditionalExpression)) {
            expression2 = parent;
            parent = parent.getParent();
        }
        return expression2;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiExpression expression2;
        if (project == null) {
            SimplifyBooleanExpressionAction.$$$reportNull$$$0(5);
        }
        if ((expression2 = SimplifyBooleanExpressionAction.getExpressionToSimplify(editor, file)) != null) {
            SimplifyBooleanExpressionFix.simplifyExpression(expression2);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SimplifyBooleanExpressionAction";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SimplifyBooleanExpressionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionToSimplify";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

