/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiRawStringLiteralUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SplitRawStringIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        int offset;
        int caretInTokenIdx;
        int trailingTicsSequence;
        if (project == null) {
            SplitRawStringIntentionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            SplitRawStringIntentionAction.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.RAW_STRING_LITERAL) {
            return false;
        }
        String text2 = token.getText();
        if (text2 == null) {
            return false;
        }
        int leadingTicsSequence = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)text2);
        return leadingTicsSequence == (trailingTicsSequence = PsiRawStringLiteralUtil.getTrailingTicksSequence((CharSequence)text2)) && (caretInTokenIdx = (offset = editor.getCaretModel().getOffset()) - token.getTextOffset()) > leadingTicsSequence && offset < token.getTextRange().getEndOffset() - trailingTicsSequence && text2.charAt(caretInTokenIdx) != '`' && text2.charAt(caretInTokenIdx - 1) != '`';
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            SplitRawStringIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SplitRawStringIntentionAction.$$$reportNull$$$0(3);
        }
        if (!(element instanceof PsiJavaToken)) {
            return;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.RAW_STRING_LITERAL) {
            return;
        }
        String text2 = token.getText();
        if (text2 == null) {
            return;
        }
        int ticsSequenceLength = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)text2);
        String breakSequence = StringUtil.repeat((String)"`", (int)ticsSequenceLength);
        int offset = editor.getCaretModel().getOffset();
        int splitIdx = offset - token.getTextOffset();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiBinaryExpression concatenation = (PsiBinaryExpression)token.getParent().replace((PsiElement)factory.createExpressionFromText(text2.substring(0, splitIdx) + breakSequence + " + " + breakSequence + text2.substring(splitIdx), element));
        editor.getCaretModel().moveToOffset(concatenation.getOperationSign().getTextOffset());
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            SplitRawStringIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Split raw string literal" == null) {
            SplitRawStringIntentionAction.$$$reportNull$$$0(5);
        }
        return "Split raw string literal";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SplitRawStringIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SplitRawStringIntentionAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

