/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import java.util.Arrays;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;

abstract class EffectQuantum {
    private final int myHash;
    static final EffectQuantum TopEffectQuantum = new EffectQuantum(-1){

        public String toString() {
            return "Top";
        }
    };
    static final EffectQuantum ThisChangeQuantum = new EffectQuantum(-2){

        public String toString() {
            return "Changes this";
        }
    };

    EffectQuantum(int hash) {
        this.myHash = hash;
    }

    Stream<EKey> dependencies() {
        return Stream.empty();
    }

    public final int hashCode() {
        return this.myHash;
    }

    static final class CallQuantum
    extends EffectQuantum {
        final EKey key;
        final DataValue[] data;
        final boolean isStatic;

        CallQuantum(EKey key2, DataValue[] data, boolean isStatic) {
            super((key2.hashCode() * 31 + Arrays.hashCode(data)) * 31 + (isStatic ? 1 : 0));
            this.key = key2;
            this.data = data;
            this.isStatic = isStatic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CallQuantum that = (CallQuantum)o;
            if (this.isStatic != that.isStatic) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
            return Arrays.equals(this.data, that.data);
        }

        @Override
        Stream<EKey> dependencies() {
            return StreamEx.of((Object[])this.data).flatMap(DataValue::dependencies).prepend((Object)this.key);
        }

        public String toString() {
            return "Calls " + this.key;
        }
    }

    static final class ParamChangeQuantum
    extends EffectQuantum {
        final int n;

        ParamChangeQuantum(int n) {
            super(n);
            this.n = n;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass() && this.n == ((ParamChangeQuantum)o).n;
        }

        public String toString() {
            return "Changes param#" + this.n;
        }
    }

    static final class ReturnChangeQuantum
    extends EffectQuantum {
        final EKey key;

        ReturnChangeQuantum(EKey key2) {
            super(key2.hashCode());
            this.key = key2;
        }

        @Override
        Stream<EKey> dependencies() {
            return Stream.of(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass() && this.key == ((ReturnChangeQuantum)o).key;
        }

        public String toString() {
            return "Changes return value of " + this.key;
        }
    }

    static final class FieldReadQuantum
    extends EffectQuantum {
        final EKey key;

        FieldReadQuantum(EKey key2) {
            super(key2.hashCode());
            this.key = key2;
        }

        @Override
        Stream<EKey> dependencies() {
            return Stream.of(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass() && this.key == ((FieldReadQuantum)o).key;
        }

        public String toString() {
            return "Reads field " + this.key;
        }
    }
}

