/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ConcurrencyAnnotationsManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JCiPUtil {
    static boolean isJCiPAnnotation(String ref) {
        return "Immutable".equals(ref) || "GuardedBy".equals(ref) || "ThreadSafe".equals(ref) || "NotThreadSafe".equals(ref);
    }

    private JCiPUtil() {
    }

    public static boolean isImmutable(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JCiPUtil.$$$reportNull$$$0(0);
        }
        return JCiPUtil.isImmutable(aClass, true);
    }

    public static boolean isImmutable(@NotNull PsiClass aClass, boolean checkDocComment) {
        PsiAnnotation annotation;
        if (aClass == null) {
            JCiPUtil.$$$reportNull$$$0(1);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (Collection)ConcurrencyAnnotationsManager.getInstance((Project)aClass.getProject()).getImmutableAnnotations())) != null) {
            return true;
        }
        if (checkDocComment) {
            PsiDocComment comment = aClass.getDocComment();
            return comment != null && comment.findTagByName("@Immutable") != null;
        }
        return false;
    }

    @Nullable
    public static String findGuardForMember(@NotNull PsiMember member) {
        PsiAnnotation annotation;
        if (member == null) {
            JCiPUtil.$$$reportNull$$$0(2);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (Collection)ConcurrencyAnnotationsManager.getInstance((Project)member.getProject()).getGuardedByAnnotations())) != null) {
            return JCiPUtil.getGuardValue(annotation);
        }
        if (member instanceof PsiCompiledElement && ((member = (PsiMember)member.getNavigationElement()) == null || member instanceof PsiCompiledElement)) {
            return null;
        }
        GuardedTagVisitor visitor = new GuardedTagVisitor();
        member.accept((PsiElementVisitor)visitor);
        return visitor.getGuardString();
    }

    static boolean isGuardedBy(@NotNull PsiMember member, @NotNull String guard) {
        List annotations2;
        PsiAnnotation annotation;
        if (member == null) {
            JCiPUtil.$$$reportNull$$$0(3);
        }
        if (guard == null) {
            JCiPUtil.$$$reportNull$$$0(4);
        }
        return (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (Collection)(annotations2 = ConcurrencyAnnotationsManager.getInstance((Project)member.getProject()).getGuardedByAnnotations()))) != null && guard.equals(JCiPUtil.getGuardValue(annotation));
    }

    public static boolean isGuardedBy(PsiMember member, PsiField field) {
        return JCiPUtil.isGuardedBy(member, field.getName());
    }

    static boolean isGuardedByAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            JCiPUtil.$$$reportNull$$$0(5);
        }
        return ConcurrencyAnnotationsManager.getInstance((Project)annotation.getProject()).getGuardedByAnnotations().contains(annotation.getQualifiedName());
    }

    static boolean isGuardedByTag(PsiDocTag tag) {
        String text2 = tag.getText();
        return text2.startsWith("@GuardedBy") && text2.contains("(") && text2.contains(")");
    }

    @Nullable
    static String getGuardValue(PsiAnnotation annotation) {
        PsiAnnotationMemberValue psiAnnotationMemberValue = annotation.findAttributeValue("value");
        if (psiAnnotationMemberValue instanceof PsiLiteralExpression) {
            PsiMember member;
            Object value2 = ((PsiLiteralExpression)psiAnnotationMemberValue).getValue();
            if ("itself".equals(value2) && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class)) != null) {
                return member.getName();
            }
            if (value2 instanceof String) {
                return (String)value2;
            }
        }
        return null;
    }

    @NotNull
    static String getGuardValue(PsiDocTag tag) {
        String text2 = tag.getText();
        String string = text2.substring(text2.indexOf(40) + 1, text2.indexOf(41)).trim();
        if (string == null) {
            JCiPUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guard";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/concurrencyAnnotations/JCiPUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/concurrencyAnnotations/JCiPUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuardValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isImmutable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findGuardForMember";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isGuardedBy";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isGuardedByAnnotation";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GuardedTagVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private String guardString;

        private GuardedTagVisitor() {
        }

        public void visitDocTag(PsiDocTag tag) {
            super.visitDocTag(tag);
            String text2 = tag.getText();
            if (text2.startsWith("@GuardedBy") && text2.contains("(") && text2.contains(")")) {
                this.guardString = text2.substring(text2.indexOf(40) + 1, text2.indexOf(41));
            }
        }

        @Nullable
        private String getGuardString() {
            return this.guardString;
        }
    }
}

