/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.inference.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.inference.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.inference.MethodData;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceResult;
import com.intellij.codeInspection.dataFlow.inference.PreContract;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaSourceInference {
    public static final int MAX_CONTRACT_COUNT = 10;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.inference.JavaSourceInference");

    @NotNull
    public static Nullability inferNullability(PsiMethodImpl method) {
        if (!InferenceFromSourceUtil.shouldInferFromSource(method)) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                JavaSourceInference.$$$reportNull$$$0(0);
            }
            return nullability;
        }
        PsiType type2 = method.getReturnType();
        if (type2 == null || type2 instanceof PsiPrimitiveType) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                JavaSourceInference.$$$reportNull$$$0(1);
            }
            return nullability;
        }
        Nullability nullability = (Nullability)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            Nullability nullability;
            MethodData data = ContractInferenceIndexKt.getIndexedData(method);
            MethodReturnInferenceResult result = data == null ? null : data.getMethodReturn();
            Nullability nullability2 = nullability = result == null ? null : (Nullability)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> result.getNullability(method, data.methodBody(method)));
            if (nullability == null) {
                nullability = Nullability.UNKNOWN;
            }
            return CachedValueProvider.Result.create((Object)nullability, (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (nullability == null) {
            JavaSourceInference.$$$reportNull$$$0(2);
        }
        return nullability;
    }

    public static Nullability inferNullability(@NotNull PsiParameter parameter2) {
        if (parameter2 == null) {
            JavaSourceInference.$$$reportNull$$$0(3);
        }
        if (!parameter2.isPhysical() || parameter2.getType() instanceof PsiPrimitiveType) {
            return Nullability.UNKNOWN;
        }
        PsiParameterList parent = (PsiParameterList)ObjectUtils.tryCast((Object)parameter2.getParent(), PsiParameterList.class);
        if (parent == null) {
            return Nullability.UNKNOWN;
        }
        PsiMethodImpl method = (PsiMethodImpl)((Object)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodImpl.class));
        if (method == null || !InferenceFromSourceUtil.shouldInferFromSource(method)) {
            return Nullability.UNKNOWN;
        }
        return (Nullability)CachedValuesManager.getCachedValue((PsiElement)parameter2, () -> {
            int index;
            BitSet notNullParameters;
            if (parameter2 == null) {
                JavaSourceInference.$$$reportNull$$$0(26);
            }
            Nullability nullability = Nullability.UNKNOWN;
            MethodData data = ContractInferenceIndexKt.getIndexedData(method);
            if (data != null && !(notNullParameters = data.getNotNullParameters()).isEmpty() && notNullParameters.get(index = ArrayUtil.indexOf((Object[])parent.getParameters(), (Object)parameter2))) {
                nullability = Nullability.NOT_NULL;
            }
            return CachedValueProvider.Result.create((Object)nullability, (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    @NotNull
    public static Mutability inferMutability(PsiMethodImpl method) {
        if (!InferenceFromSourceUtil.shouldInferFromSource(method)) {
            Mutability mutability = Mutability.UNKNOWN;
            if (mutability == null) {
                JavaSourceInference.$$$reportNull$$$0(4);
            }
            return mutability;
        }
        PsiType type2 = method.getReturnType();
        if (type2 == null || ClassUtils.isImmutable(type2, false)) {
            Mutability mutability = Mutability.UNKNOWN;
            if (mutability == null) {
                JavaSourceInference.$$$reportNull$$$0(5);
            }
            return mutability;
        }
        Mutability mutability = (Mutability)((Object)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            Mutability mutability;
            MethodData data = ContractInferenceIndexKt.getIndexedData(method);
            MethodReturnInferenceResult result = data == null ? null : data.getMethodReturn();
            Mutability mutability2 = mutability = result == null ? null : (Mutability)((Object)((Object)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> result.getMutability(method, data.methodBody(method)))));
            if (mutability == null) {
                mutability = Mutability.UNKNOWN;
            }
            return CachedValueProvider.Result.create((Object)((Object)mutability), (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        }));
        if (mutability == null) {
            JavaSourceInference.$$$reportNull$$$0(6);
        }
        return mutability;
    }

    @NotNull
    public static List<StandardMethodContract> inferContracts(@NotNull PsiMethodImpl method) {
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(7);
        }
        if (!InferenceFromSourceUtil.shouldInferFromSource(method)) {
            List<StandardMethodContract> list = Collections.emptyList();
            if (list == null) {
                JavaSourceInference.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            List<Object> preContracts;
            MethodData data;
            List result;
            if (method == null) {
                JavaSourceInference.$$$reportNull$$$0(24);
            }
            if ((result = (List)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> JavaSourceInference.lambda$null$5(method, data, preContracts = (data = ContractInferenceIndexKt.getIndexedData(method)) == null ? Collections.emptyList() : data.getContracts()))) == null) {
                result = Collections.emptyList();
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (list == null) {
            JavaSourceInference.$$$reportNull$$$0(9);
        }
        return list;
    }

    public static boolean inferPurity(@NotNull PsiMethodImpl method) {
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(10);
        }
        if (!InferenceFromSourceUtil.shouldInferFromSource(method) || PsiType.VOID.equals((Object)method.getReturnType()) || method.isConstructor()) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            MethodData data;
            if (method == null) {
                JavaSourceInference.$$$reportNull$$$0(22);
            }
            PurityInferenceResult result = (data = ContractInferenceIndexKt.getIndexedData(method)) == null ? null : data.getPurity();
            Boolean pure = (Boolean)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> {
                if (method == null) {
                    JavaSourceInference.$$$reportNull$$$0(23);
                }
                return result != null && result.isPure(method, data.methodBody(method));
            });
            return CachedValueProvider.Result.create((Object)(pure == Boolean.TRUE ? 1 : 0), (Object[])new Object[]{method});
        });
    }

    @NotNull
    private static List<StandardMethodContract> postProcessContracts(@NotNull PsiMethodImpl method, MethodData data, List<PreContract> rawContracts) {
        List compatible;
        List<StandardMethodContract> contracts2;
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(11);
        }
        if ((contracts2 = ContainerUtil.concat(rawContracts, c -> {
            if (method == null) {
                JavaSourceInference.$$$reportNull$$$0(21);
            }
            return c.toContracts(method, data.methodBody(method));
        })).isEmpty()) {
            List<StandardMethodContract> list = Collections.emptyList();
            if (list == null) {
                JavaSourceInference.$$$reportNull$$$0(12);
            }
            return list;
        }
        PsiType returnType = method.getReturnType();
        if (returnType != null && !(returnType instanceof PsiPrimitiveType)) {
            contracts2 = JavaSourceInference.boxReturnValues(contracts2);
        }
        if ((compatible = ContainerUtil.filter((Collection)contracts2, contract -> {
            if (method == null) {
                JavaSourceInference.$$$reportNull$$$0(20);
            }
            return JavaSourceInference.isContractCompatibleWithMethod(method, contract);
        })).size() > 10) {
            LOG.debug("Too many contracts for " + PsiUtil.getMemberQualifiedName((PsiMember)method) + ", shrinking the list");
            List<StandardMethodContract> list = compatible.subList(0, 10);
            if (list == null) {
                JavaSourceInference.$$$reportNull$$$0(13);
            }
            return list;
        }
        List list = compatible;
        if (list == null) {
            JavaSourceInference.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static boolean isContractCompatibleWithMethod(@NotNull PsiMethod method, StandardMethodContract contract) {
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(15);
        }
        if (JavaSourceInference.hasContradictoryExplicitParameterNullity(method, contract)) {
            return false;
        }
        if (JavaSourceInference.isReturnNullitySpecifiedExplicitly(method, contract)) {
            return false;
        }
        if (JavaSourceInference.isContradictingExplicitNullableReturn(method, contract)) {
            return false;
        }
        return contract.getReturnValue().isMethodCompatible(method);
    }

    private static boolean hasContradictoryExplicitParameterNullity(@NotNull PsiMethod method, StandardMethodContract contract) {
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(16);
        }
        for (int i = 0; i < contract.getParameterCount(); ++i) {
            if (contract.getParameterConstraint(i) != StandardMethodContract.ValueConstraint.NULL_VALUE || !NullableNotNullManager.isNotNull((PsiModifierListOwner)method.getParameterList().getParameters()[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isContradictingExplicitNullableReturn(@NotNull PsiMethod method, StandardMethodContract contract) {
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(17);
        }
        return contract.getReturnValue().isNotNull() && contract.isTrivial() && NullableNotNullManager.getInstance((Project)method.getProject()).isNullable((PsiModifierListOwner)method, false);
    }

    private static boolean isReturnNullitySpecifiedExplicitly(@NotNull PsiMethod method, StandardMethodContract contract) {
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(18);
        }
        if (!contract.getReturnValue().equals(ContractReturnValue.returnNotNull()) && !contract.getReturnValue().isNull()) {
            return false;
        }
        return NullableNotNullManager.getInstance((Project)method.getProject()).isNotNull((PsiModifierListOwner)method, false);
    }

    @NotNull
    private static List<StandardMethodContract> boxReturnValues(List<StandardMethodContract> contracts2) {
        List list = ContainerUtil.mapNotNull(contracts2, contract -> {
            if (contract.getReturnValue().isBoolean()) {
                return contract.withReturnValue(ContractReturnValue.returnNotNull());
            }
            return contract;
        });
        if (list == null) {
            JavaSourceInference.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static /* synthetic */ List lambda$null$5(@NotNull PsiMethodImpl method, MethodData data, List preContracts) {
        if (method == null) {
            JavaSourceInference.$$$reportNull$$$0(25);
        }
        return JavaSourceInference.postProcessContracts(method, data, preContracts);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/inference/JavaSourceInference";
                break;
            }
            case 3: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "inferNullability";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/inference/JavaSourceInference";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMutability";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "inferContracts";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcessContracts";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "boxReturnValues";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inferNullability";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inferContracts";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inferPurity";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "postProcessContracts";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isContractCompatibleWithMethod";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasContradictoryExplicitParameterNullity";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isContradictingExplicitNullableReturn";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isReturnNullitySpecifiedExplicitly";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postProcessContracts$10";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postProcessContracts$9";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$inferPurity$8";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$7";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$inferContracts$6";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$inferNullability$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

