/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.smartPointerPsiNodes.ClassSmartPointerNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiClassFavoriteNodeProvider
extends FavoriteNodeProvider {
    public Collection<AbstractTreeNode> getFavoriteNodes(DataContext context, @NotNull ViewSettings viewSettings) {
        PsiElement element;
        Project project;
        if (viewSettings == null) {
            PsiClassFavoriteNodeProvider.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(context)) == null) {
            return null;
        }
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        if (elements == null && (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context)) != null) {
            elements = new PsiElement[]{element};
        }
        if (elements != null) {
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            for (PsiElement element2 : elements) {
                if (!(element2 instanceof PsiClass) || !PsiClassFavoriteNodeProvider.checkClassUnderSources(element2, project)) continue;
                result.add((AbstractTreeNode)new ClassSmartPointerNode(project, (PsiClass)element2, viewSettings));
            }
            return result.isEmpty() ? null : result;
        }
        return null;
    }

    private static boolean checkClassUnderSources(PsiElement element, Project project) {
        PsiFile file = element.getContainingFile();
        if (file != null && file.getVirtualFile() != null) {
            VirtualFile vf;
            FileIndexFacade indexFacade = FileIndexFacade.getInstance((Project)project);
            return indexFacade.isInSource(vf = file.getVirtualFile()) || indexFacade.isInSourceContent(vf);
        }
        return false;
    }

    public AbstractTreeNode createNode(Project project, Object element, @NotNull ViewSettings viewSettings) {
        if (viewSettings == null) {
            PsiClassFavoriteNodeProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiClass && PsiClassFavoriteNodeProvider.checkClassUnderSources((PsiElement)element, project)) {
            return new ClassSmartPointerNode(project, (PsiClass)element, viewSettings);
        }
        return super.createNode(project, element, viewSettings);
    }

    public boolean elementContainsFile(Object element, VirtualFile vFile) {
        PsiFile file;
        return element instanceof PsiClass && (file = ((PsiClass)element).getContainingFile()) != null && Comparing.equal((Object)file.getVirtualFile(), (Object)vFile);
    }

    public int getElementWeight(Object value2, boolean isSortByType) {
        if (value2 instanceof PsiClass) {
            return isSortByType ? ClassTreeNode.getClassPosition((PsiClass)value2) : 3;
        }
        return -1;
    }

    public String getElementLocation(Object element) {
        if (element instanceof PsiClass) {
            return ClassPresentationUtil.getNameForClass((PsiClass)element, true);
        }
        return null;
    }

    public boolean isInvalidElement(Object element) {
        return element instanceof PsiClass && !((PsiClass)element).isValid();
    }

    @NotNull
    public String getFavoriteTypeId() {
        if ("class" == null) {
            PsiClassFavoriteNodeProvider.$$$reportNull$$$0(2);
        }
        return "class";
    }

    public String getElementUrl(Object element) {
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            return aClass.getQualifiedName();
        }
        return null;
    }

    public String getElementModuleName(Object element) {
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            return module != null ? module.getName() : null;
        }
        return null;
    }

    public Object[] createPathFromUrl(Project project, String url, String moduleName) {
        PsiClass aClass;
        Module module;
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        GlobalSearchScope scope = null;
        if (moduleName != null && (module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName)) != null) {
            scope = GlobalSearchScope.moduleScope((Module)module);
        }
        if (scope == null) {
            scope = GlobalSearchScope.allScope((Project)project);
        }
        if ((aClass = JavaPsiFacade.getInstance((Project)project).findClass(url, scope)) == null) {
            return null;
        }
        return new Object[]{aClass};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/favoritesTreeView/PsiClassFavoriteNodeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/favoritesTreeView/PsiClassFavoriteNodeProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoriteTypeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFavoriteNodes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

