/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.TodoDirNode;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoPackageNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class TodoJavaTreeHelper
extends TodoTreeHelper {
    public TodoJavaTreeHelper(Project project) {
        super(project);
    }

    public boolean skipDirectory(PsiDirectory directory) {
        return JavaDirectoryService.getInstance().getPackage(directory) != null;
    }

    public PsiElement getSelectedElement(Object userObject) {
        if (userObject instanceof TodoPackageNode) {
            TodoPackageNode descriptor = (TodoPackageNode)((Object)userObject);
            PackageElement packageElement = (PackageElement)descriptor.getValue();
            return packageElement != null ? packageElement.getPackage() : null;
        }
        return super.getSelectedElement(userObject);
    }

    public boolean contains(ProjectViewNode node, Object element) {
        if (element instanceof PackageElement) {
            for (VirtualFile virtualFile : ((PackageElement)element).getRoots()) {
                if (!node.contains(virtualFile)) continue;
                return true;
            }
        }
        return super.contains(node, element);
    }

    public void addPackagesToChildren(ArrayList<? super AbstractTreeNode> children, Module module, TodoTreeBuilder builder) {
        Project project = this.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList sourceRoots = new ArrayList();
        if (module == null) {
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
            ContainerUtil.addAll(sourceRoots, (Object[])projectRootManager.getContentSourceRoots());
        } else {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            ContainerUtil.addAll(sourceRoots, (Object[])moduleRootManager.getSourceRoots());
        }
        HashSet<PsiPackage> topLevelPackages = new HashSet<PsiPackage>();
        for (VirtualFile root : sourceRoots) {
            PsiDirectory directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage directoryPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (directoryPackage == null || PackageUtil.isPackageDefault(directoryPackage)) {
                PsiDirectory[] subdirectories = directory.getSubdirectories();
                for (PsiDirectory subdirectory : subdirectories) {
                    TodoDirNode dirNode;
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subdirectory);
                    if (aPackage != null && !PackageUtil.isPackageDefault(aPackage)) {
                        topLevelPackages.add(aPackage);
                        continue;
                    }
                    Iterator files = builder.getFiles(subdirectory);
                    if (!files.hasNext() || children.contains(dirNode = new TodoDirNode(project, subdirectory, builder))) continue;
                    children.add((AbstractTreeNode)dirNode);
                }
                Iterator filesUnderDirectory = builder.getFilesUnderDirectory(directory);
                while (filesUnderDirectory.hasNext()) {
                    PsiFile file = (PsiFile)filesUnderDirectory.next();
                    TodoFileNode todoFileNode = new TodoFileNode(project, file, builder, false);
                    if (children.contains(todoFileNode)) continue;
                    children.add((AbstractTreeNode)todoFileNode);
                }
                continue;
            }
            topLevelPackages.add(directoryPackage);
        }
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleScope((Module)module) : GlobalSearchScope.projectScope((Project)project);
        ArrayList<PsiPackage> packages = new ArrayList<PsiPackage>();
        for (PsiPackage psiPackage : topLevelPackages) {
            PsiPackage aPackage = TodoJavaTreeHelper.findNonEmptyPackage(psiPackage, module, project, builder, scope);
            if (aPackage == null) continue;
            packages.add(aPackage);
        }
        for (PsiPackage psiPackage : packages) {
            if (!builder.getTodoTreeStructure().getIsFlattenPackages()) {
                PackageElement element = new PackageElement(module, psiPackage, false);
                TodoPackageNode packageNode = new TodoPackageNode(project, element, builder, psiPackage.getQualifiedName());
                if (children.contains((Object)packageNode)) continue;
                children.add((AbstractTreeNode)packageNode);
                continue;
            }
            HashSet allPackages = new HashSet();
            TodoJavaTreeHelper.traverseSubPackages(psiPackage, module, builder, project, allPackages);
            for (PsiPackage aPackage : allPackages) {
                TodoPackageNode packageNode = new TodoPackageNode(project, new PackageElement(module, aPackage, false), builder);
                if (children.contains((Object)packageNode)) continue;
                children.add((AbstractTreeNode)packageNode);
            }
        }
        List roots = this.collectContentRoots(module);
        roots.removeAll(sourceRoots);
        this.addDirsToChildren(roots, children, builder);
    }

    @Nullable
    public static PsiPackage findNonEmptyPackage(PsiPackage rootPackage, Module module, Project project, TodoTreeBuilder builder, GlobalSearchScope scope) {
        if (!TodoJavaTreeHelper.isPackageEmpty(new PackageElement(module, rootPackage, false), builder, project)) {
            return rootPackage;
        }
        PsiPackage[] subPackages = rootPackage.getSubPackages(scope);
        PsiPackage suggestedNonEmptyPackage = null;
        int count = 0;
        for (PsiPackage aPackage : subPackages) {
            if (TodoJavaTreeHelper.isPackageEmpty(new PackageElement(module, aPackage, false), builder, project)) continue;
            if (++count > 1) {
                return rootPackage;
            }
            suggestedNonEmptyPackage = aPackage;
        }
        for (PsiPackage aPackage : subPackages) {
            PsiPackage subPackage;
            if (aPackage == suggestedNonEmptyPackage || (subPackage = TodoJavaTreeHelper.findNonEmptyPackage(aPackage, module, project, builder, scope)) == null) continue;
            if (count > 0) {
                return rootPackage;
            }
            ++count;
            suggestedNonEmptyPackage = subPackage;
        }
        return suggestedNonEmptyPackage;
    }

    private static void traverseSubPackages(PsiPackage psiPackage, Module module, TodoTreeBuilder builder, Project project, Set<? super PsiPackage> packages) {
        PsiPackage[] subPackages;
        if (!TodoJavaTreeHelper.isPackageEmpty(new PackageElement(module, psiPackage, false), builder, project)) {
            packages.add((PsiPackage)psiPackage);
        }
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleScope((Module)module) : GlobalSearchScope.projectScope((Project)project);
        for (PsiPackage subPackage : subPackages = psiPackage.getSubPackages(scope)) {
            TodoJavaTreeHelper.traverseSubPackages(subPackage, module, builder, project, packages);
        }
    }

    private static boolean isPackageEmpty(PackageElement packageElement, TodoTreeBuilder builder, Project project) {
        if (packageElement == null) {
            return true;
        }
        PsiPackage psiPackage = packageElement.getPackage();
        Module module = packageElement.getModule();
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleScope((Module)module) : GlobalSearchScope.projectScope((Project)project);
        PsiDirectory[] directories = psiPackage.getDirectories(scope);
        boolean isEmpty = true;
        for (PsiDirectory psiDirectory : directories) {
            isEmpty &= builder.isDirectoryEmpty(psiDirectory);
        }
        return isEmpty;
    }
}

