/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.actions.JavaQualifiedNameProvider;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.gotoByName.DefaultClassNavigationContributor;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSymbolNavigationContributor
implements ChooseByNameContributorEx,
GotoClassContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.DefaultSymbolNavigationContributor");

    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
        HashSet set = new HashSet();
        Collections.addAll(set, cache.getAllMethodNames());
        Collections.addAll(set, cache.getAllFieldNames());
        Collections.addAll(set, cache.getAllClassNames());
        String[] stringArray = ArrayUtil.toStringArray(set);
        if (stringArray == null) {
            DefaultSymbolNavigationContributor.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
        Condition<PsiMember> qualifiedMatcher = DefaultSymbolNavigationContributor.getQualifiedNameMatcher(pattern);
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : cache.getMethodsByName(name, scope)) {
            if (psiMethod.isConstructor() || !DefaultSymbolNavigationContributor.isOpenable((PsiMember)psiMethod) || DefaultSymbolNavigationContributor.hasSuperMethod(psiMethod, scope, qualifiedMatcher, pattern)) continue;
            result.add(psiMethod);
        }
        for (PsiMethod psiMethod : cache.getFieldsByName(name, scope)) {
            if (!DefaultSymbolNavigationContributor.isOpenable((PsiMember)psiMethod)) continue;
            result.add(psiMethod);
        }
        for (PsiMethod psiMethod : cache.getClassesByName(name, scope)) {
            if (!DefaultSymbolNavigationContributor.isOpenable((PsiMember)psiMethod)) continue;
            result.add(psiMethod);
        }
        PsiMember[] array = result.toArray(PsiMember.EMPTY_ARRAY);
        Arrays.sort(array, MyComparator.INSTANCE);
        if (array == null) {
            DefaultSymbolNavigationContributor.$$$reportNull$$$0(1);
        }
        return array;
    }

    @Nullable
    public String getQualifiedName(NavigationItem item) {
        if (item instanceof PsiClass) {
            return DefaultClassNavigationContributor.getQualifiedNameForClass((PsiClass)item);
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return "$";
    }

    private static boolean isOpenable(PsiMember member) {
        PsiFile file = member.getContainingFile();
        return file != null && file.getVirtualFile() != null;
    }

    private static boolean hasSuperMethodCandidates(PsiMethod method, GlobalSearchScope scope, Condition<? super PsiMember> qualifiedMatcher) {
        if (method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        int parametersCount = method.getParameterList().getParametersCount();
        return !InheritanceUtil.processSupers((PsiClass)containingClass, (boolean)false, superClass -> {
            if (PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)superClass)) {
                for (PsiMethod candidate : superClass.findMethodsByName(method.getName(), false)) {
                    if (parametersCount != candidate.getParameterList().getParametersCount() || candidate.hasModifierProperty("private") || candidate.hasModifierProperty("static") || !qualifiedMatcher.value((Object)candidate)) continue;
                    return false;
                }
            }
            return true;
        });
    }

    private static boolean hasSuperMethod(PsiMethod method, GlobalSearchScope scope, Condition<PsiMember> qualifiedMatcher, String pattern) {
        if (pattern.contains(".") && Registry.is((String)"ide.goto.symbol.include.overrides.on.qualified.patterns")) {
            return false;
        }
        if (!DefaultSymbolNavigationContributor.hasSuperMethodCandidates(method, scope, qualifiedMatcher)) {
            return false;
        }
        for (HierarchicalMethodSignature signature : method.getHierarchicalMethodSignature().getSuperSignatures()) {
            PsiMethod superMethod = signature.getMethod();
            if (!PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)superMethod) || !qualifiedMatcher.value((Object)superMethod)) continue;
            return true;
        }
        return false;
    }

    public void processNames(@NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            DefaultSymbolNavigationContributor.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            DefaultSymbolNavigationContributor.$$$reportNull$$$0(3);
        }
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)scope.getProject());
        cache.processAllClassNames(processor, scope, filter);
        cache.processAllFieldNames(processor, scope, filter);
        cache.processAllMethodNames(processor, scope, filter);
    }

    public void processElementsWithName(@NotNull String name, @NotNull Processor<NavigationItem> processor, @NotNull FindSymbolParameters parameters2) {
        boolean success;
        if (name == null) {
            DefaultSymbolNavigationContributor.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            DefaultSymbolNavigationContributor.$$$reportNull$$$0(5);
        }
        if (parameters2 == null) {
            DefaultSymbolNavigationContributor.$$$reportNull$$$0(6);
        }
        GlobalSearchScope scope = parameters2.getSearchScope();
        IdFilter filter = parameters2.getIdFilter();
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)scope.getProject());
        String completePattern = parameters2.getCompletePattern();
        Condition<PsiMember> qualifiedMatcher = DefaultSymbolNavigationContributor.getQualifiedNameMatcher(completePattern);
        THashSet collectedMethods = new THashSet();
        boolean bl = success = cache.processFieldsWithName(name, field -> {
            if (processor == null) {
                DefaultSymbolNavigationContributor.$$$reportNull$$$0(8);
            }
            if (DefaultSymbolNavigationContributor.isOpenable((PsiMember)field) && qualifiedMatcher.value(field)) {
                return processor.process(field);
            }
            return true;
        }, scope, filter) && cache.processClassesWithName(name, aClass -> {
            if (processor == null) {
                DefaultSymbolNavigationContributor.$$$reportNull$$$0(7);
            }
            if (DefaultSymbolNavigationContributor.isOpenable((PsiMember)aClass) && qualifiedMatcher.value(aClass)) {
                return processor.process(aClass);
            }
            return true;
        }, scope, filter) && cache.processMethodsWithName(name, arg_0 -> DefaultSymbolNavigationContributor.lambda$processElementsWithName$3(qualifiedMatcher, (Set)collectedMethods, arg_0), scope, filter);
        if (success) {
            Iterator iterator = collectedMethods.iterator();
            while (iterator.hasNext()) {
                PsiMethod method = (PsiMethod)iterator.next();
                if (!DefaultSymbolNavigationContributor.hasSuperMethod(method, scope, qualifiedMatcher, completePattern) && !processor.process((Object)method)) {
                    return;
                }
                ProgressManager.checkCanceled();
                iterator.remove();
            }
        }
    }

    private static Condition<PsiMember> getQualifiedNameMatcher(String completePattern) {
        if (completePattern.contains("#") && completePattern.endsWith(")")) {
            return member -> member instanceof PsiMethod && JavaQualifiedNameProvider.hasQualifiedName(completePattern, (PsiMethod)member);
        }
        if (completePattern.contains(".") || completePattern.contains("#")) {
            String normalized = StringUtil.replace((String)StringUtil.replace((String)completePattern, (String)"#", (String)".*"), (String)".", (String)".*");
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + normalized)).build();
            return member -> {
                String qualifiedName = PsiUtil.getMemberQualifiedName((PsiMember)member);
                return qualifiedName != null && matcher.matches(qualifiedName);
            };
        }
        return Conditions.alwaysTrue();
    }

    private static /* synthetic */ boolean lambda$processElementsWithName$3(Condition qualifiedMatcher, Set collectedMethods, PsiMethod method) {
        if (!method.isConstructor() && DefaultSymbolNavigationContributor.isOpenable((PsiMember)method) && qualifiedMatcher.value((Object)method)) {
            collectedMethods.add(method);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/DefaultSymbolNavigationContributor";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsByName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/DefaultSymbolNavigationContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processNames";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementsWithName$2";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementsWithName$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JavadocSeparatorContributor
    implements ChooseByNameContributor,
    GotoClassContributor {
        @Nullable
        public String getQualifiedName(NavigationItem item) {
            return null;
        }

        @Nullable
        public String getQualifiedNameSeparator() {
            return "#";
        }

        @NotNull
        public String[] getNames(Project project, boolean includeNonProjectItems) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                JavadocSeparatorContributor.$$$reportNull$$$0(0);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }

        @NotNull
        public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
            if (NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY == null) {
                JavadocSeparatorContributor.$$$reportNull$$$0(1);
            }
            return NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ide/util/gotoByName/DefaultSymbolNavigationContributor$JavadocSeparatorContributor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNames";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItemsByName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MyComparator
    implements Comparator<PsiModifierListOwner> {
        public static final MyComparator INSTANCE = new MyComparator();
        private final DefaultPsiElementCellRenderer myRenderer = new DefaultPsiElementCellRenderer();

        private MyComparator() {
        }

        @Override
        public int compare(PsiModifierListOwner element1, PsiModifierListOwner element2) {
            String text2;
            String text1;
            int kind2;
            int level2;
            if (element1 == element2) {
                return 0;
            }
            PsiModifierList modifierList1 = element1.getModifierList();
            PsiModifierList modifierList2 = element2.getModifierList();
            int level1 = modifierList1 == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList1);
            int n = level2 = modifierList2 == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList2);
            if (level1 != level2) {
                return level2 - level1;
            }
            int kind1 = MyComparator.getElementTypeLevel((PsiElement)element1);
            if (kind1 != (kind2 = MyComparator.getElementTypeLevel((PsiElement)element2))) {
                return kind1 - kind2;
            }
            if (element1 instanceof PsiMethod) {
                LOG.assertTrue(element2 instanceof PsiMethod);
                PsiParameter[] params1 = ((PsiMethod)element1).getParameterList().getParameters();
                PsiParameter[] params2 = ((PsiMethod)element2).getParameterList().getParameters();
                if (params1.length != params2.length) {
                    return params1.length - params2.length;
                }
            }
            if (!(text1 = this.myRenderer.getElementText((PsiElement)element1)).equals(text2 = this.myRenderer.getElementText((PsiElement)element2))) {
                return text1.compareTo(text2);
            }
            String containerText1 = this.myRenderer.getContainerText((PsiElement)element1, text1);
            String containerText2 = this.myRenderer.getContainerText((PsiElement)element2, text2);
            if (containerText1 == null) {
                containerText1 = "";
            }
            if (containerText2 == null) {
                containerText2 = "";
            }
            return containerText1.compareTo(containerText2);
        }

        private static int getElementTypeLevel(PsiElement element) {
            if (element instanceof PsiMethod) {
                return 1;
            }
            if (element instanceof PsiField) {
                return 2;
            }
            if (element instanceof PsiClass) {
                return 3;
            }
            LOG.error((Object)element);
            return 0;
        }
    }
}

