/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

public class ClassHierarchyScopeDescriptor
extends ScopeDescriptor {
    private SearchScope myCachedScope;
    private final Project myProject;
    private final PsiClass myRootClass;

    public ClassHierarchyScopeDescriptor(Project project) {
        super(null);
        PsiFile file;
        this.myProject = project;
        DataContext dataContext = DataManager.getInstance().getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element = editor != null ? ((file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext)) != null ? file.findElementAt(editor.getCaretModel().getOffset()) : null) : (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        this.myRootClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
    }

    public String getDisplay() {
        return IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]);
    }

    @Nullable
    public SearchScope getScope() {
        if (this.myCachedScope == null) {
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)this.myProject).createAllProjectScopeChooser(IdeBundle.message((String)"prompt.choose.base.class.of.the.hierarchy", (Object[])new Object[0]));
            if (this.myRootClass != null) {
                chooser.select(this.myRootClass);
            }
            chooser.showDialog();
            PsiClass aClass = chooser.getSelected();
            if (aClass == null) {
                this.myCachedScope = GlobalSearchScope.EMPTY_SCOPE;
            } else {
                LinkedList<PsiClass> classesToSearch = new LinkedList<PsiClass>();
                classesToSearch.add(aClass);
                classesToSearch.addAll(ClassInheritorsSearch.search((PsiClass)aClass).findAll());
                FunctionalExpressionSearch.search((PsiClass)aClass).forEach(expression2 -> {
                    classesToSearch.add((PsiClass)expression2);
                    return true;
                });
                this.myCachedScope = new LocalSearchScope(PsiUtilCore.toPsiElementArray(classesToSearch), IdeBundle.message((String)"scope.hierarchy", (Object[])new Object[]{ClassPresentationUtil.getNameForClass(aClass, true)}));
            }
        }
        return this.myCachedScope;
    }
}

