/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.IntroduceFunctionalParameterHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureHandler;
import com.intellij.refactoring.extractInterface.ExtractInterfaceHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractSuperclass.ExtractSuperclassHandler;
import com.intellij.refactoring.extractclass.ExtractClassHandler;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.introduceVariable.IntroduceFunctionalVariableHandler;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.refactoring.memberPullUp.JavaPullUpHandler;
import com.intellij.refactoring.memberPushDown.JavaPushDownHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRefactoringSupportProvider
extends RefactoringSupportProvider {
    public boolean isSafeDeleteAvailable(@NotNull PsiElement element) {
        if (element == null) {
            JavaRefactoringSupportProvider.$$$reportNull$$$0(0);
        }
        return element instanceof PsiClass || element instanceof PsiMethod || element instanceof PsiField || element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod || element instanceof PsiPackage || element instanceof PsiLocalVariable;
    }

    public RefactoringActionHandler getIntroduceConstantHandler() {
        return new IntroduceConstantHandler();
    }

    public RefactoringActionHandler getIntroduceFieldHandler() {
        return new IntroduceFieldHandler();
    }

    public boolean isInplaceRenameAvailable(@NotNull PsiElement element, PsiElement context) {
        if (element == null) {
            JavaRefactoringSupportProvider.$$$reportNull$$$0(1);
        }
        return JavaRefactoringSupportProvider.mayRenameInplace(element, context);
    }

    public boolean isMemberInplaceRenameAvailable(@NotNull PsiElement elementToRename, @Nullable PsiElement context) {
        if (elementToRename == null) {
            JavaRefactoringSupportProvider.$$$reportNull$$$0(2);
        }
        return elementToRename instanceof PsiMember || elementToRename instanceof PsiJavaModule;
    }

    public RefactoringActionHandler getIntroduceVariableHandler() {
        return new IntroduceVariableHandler();
    }

    @Nullable
    public RefactoringActionHandler getExtractMethodHandler() {
        return new ExtractMethodHandler();
    }

    public RefactoringActionHandler getIntroduceParameterHandler() {
        return new IntroduceParameterHandler();
    }

    @Nullable
    public RefactoringActionHandler getIntroduceFunctionalParameterHandler() {
        return new IntroduceFunctionalParameterHandler();
    }

    public RefactoringActionHandler getIntroduceFunctionalVariableHandler() {
        return new IntroduceFunctionalVariableHandler();
    }

    public RefactoringActionHandler getPullUpHandler() {
        return new JavaPullUpHandler();
    }

    public RefactoringActionHandler getPushDownHandler() {
        return new JavaPushDownHandler();
    }

    public RefactoringActionHandler getExtractInterfaceHandler() {
        return new ExtractInterfaceHandler();
    }

    public RefactoringActionHandler getExtractSuperClassHandler() {
        return new ExtractSuperclassHandler();
    }

    public ChangeSignatureHandler getChangeSignatureHandler() {
        return new JavaChangeSignatureHandler();
    }

    public RefactoringActionHandler getExtractClassHandler() {
        return new ExtractClassHandler();
    }

    public boolean isInplaceIntroduceAvailable(@NotNull PsiElement element, PsiElement context) {
        if (element == null) {
            JavaRefactoringSupportProvider.$$$reportNull$$$0(3);
        }
        if (!(element instanceof PsiExpression)) {
            return false;
        }
        return context != null && context.getContainingFile() == element.getContainingFile();
    }

    public static boolean mayRenameInplace(PsiElement elementToRename, PsiElement nameSuggestionContext) {
        if (nameSuggestionContext != null && nameSuggestionContext.getContainingFile() != elementToRename.getContainingFile()) {
            return false;
        }
        if (!(elementToRename instanceof PsiLocalVariable || elementToRename instanceof PsiParameter || elementToRename instanceof PsiLabeledStatement)) {
            return false;
        }
        SearchScope useScope = PsiSearchHelper.getInstance((Project)elementToRename.getProject()).getUseScope(elementToRename);
        if (!(useScope instanceof LocalSearchScope)) {
            return false;
        }
        PsiElement[] scopeElements = ((LocalSearchScope)useScope).getScope();
        if (scopeElements.length > 1 && !JavaRefactoringSupportProvider.isElementWithComment(scopeElements) && !JavaRefactoringSupportProvider.isResourceVariable(scopeElements)) {
            return false;
        }
        PsiFile containingFile = elementToRename.getContainingFile();
        return PsiTreeUtil.isAncestor((PsiElement)containingFile, (PsiElement)scopeElements[0], (boolean)false);
    }

    private static boolean isElementWithComment(PsiElement[] scopeElements) {
        if (scopeElements.length > 2) {
            return false;
        }
        PsiDocComment comment = null;
        PsiDocCommentOwner owner = null;
        for (PsiElement element : scopeElements) {
            if (element instanceof PsiDocComment) {
                comment = (PsiDocComment)element;
                continue;
            }
            if (!(element instanceof PsiDocCommentOwner)) continue;
            owner = (PsiDocCommentOwner)element;
        }
        return comment != null && comment.getOwner() == owner;
    }

    private static boolean isResourceVariable(PsiElement[] scopeElements) {
        return scopeElements.length == 2 && scopeElements[0] instanceof PsiResourceList && scopeElements[1] instanceof PsiCodeBlock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/java/JavaRefactoringSupportProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSafeDeleteAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInplaceRenameAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isMemberInplaceRenameAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInplaceIntroduceAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

