/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ReflectionAccessorBase<T extends ItemToReplaceDescriptor>
implements ReflectionAccessor {
    private final PsiClass myPsiClass;
    private final PsiElementFactory myElementFactory;
    private final Logger log;

    protected ReflectionAccessorBase(@NotNull PsiClass psiClass, @NotNull PsiElementFactory elementFactory) {
        if (psiClass == null) {
            ReflectionAccessorBase.$$$reportNull$$$0(0);
        }
        if (elementFactory == null) {
            ReflectionAccessorBase.$$$reportNull$$$0(1);
        }
        this.log = Logger.getInstance(this.getClass());
        this.myPsiClass = psiClass;
        this.myElementFactory = elementFactory;
    }

    @Override
    public void accessThroughReflection(@NotNull PsiElement element) {
        if (element == null) {
            ReflectionAccessorBase.$$$reportNull$$$0(2);
        }
        List<T> toReplace = this.findItemsToReplace(element);
        this.log.info("Found " + toReplace.size() + " items to replace");
        for (ItemToReplaceDescriptor item : toReplace) {
            this.grantAccess(item);
        }
        List<T> remaining = this.findItemsToReplace(element);
        if (!remaining.isEmpty()) {
            this.log.warn("Some inaccessible items were not replaced");
        }
    }

    @NotNull
    protected PsiElementFactory getElementFactory() {
        PsiElementFactory psiElementFactory = this.myElementFactory;
        if (psiElementFactory == null) {
            ReflectionAccessorBase.$$$reportNull$$$0(3);
        }
        return psiElementFactory;
    }

    @NotNull
    protected PsiClass getOuterClass() {
        PsiClass psiClass = this.myPsiClass;
        if (psiClass == null) {
            ReflectionAccessorBase.$$$reportNull$$$0(4);
        }
        return psiClass;
    }

    protected abstract List<T> findItemsToReplace(@NotNull PsiElement var1);

    protected abstract void grantAccess(@NotNull T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessorBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accessThroughReflection";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

