/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.NavigationItemFileStatus;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.FileGroupingRule;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassGroupingRule
extends SingleParentUsageGroupingRule
implements DumbAware {
    @Nullable
    protected UsageGroup getParentGroupFor(@NotNull Usage usage, @NotNull UsageTarget[] targets) {
        PsiElement containingClass;
        if (usage == null) {
            ClassGroupingRule.$$$reportNull$$$0(0);
        }
        if (targets == null) {
            ClassGroupingRule.$$$reportNull$$$0(1);
        }
        if (!(usage instanceof PsiElementUsage)) {
            return null;
        }
        PsiElement psiElement = ((PsiElementUsage)usage).getElement();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getTopLevelFile((PsiElement)containingFile);
        if (!(topLevelFile instanceof PsiJavaFile) || topLevelFile instanceof ServerPageFile) {
            return null;
        }
        Object object = containingClass = topLevelFile == containingFile ? psiElement : InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
        while ((containingClass = PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class, (boolean)true)) != null && ((PsiClass)containingClass).getQualifiedName() == null) {
        }
        if (containingClass == null) {
            PsiImportList importList = (PsiImportList)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiImportList.class, (boolean)true);
            if (importList != null) {
                PsiClass[] classes2;
                String fileName = ClassGroupingRule.getFileNameWithoutExtension(topLevelFile);
                for (PsiClass aClass : classes2 = ((PsiJavaFile)topLevelFile).getClasses()) {
                    if (!fileName.equals(aClass.getName())) continue;
                    containingClass = aClass;
                    break;
                }
            }
        } else if (containingClass.getParent() instanceof PsiFile && FileTypeUtils.isInServerPageFile((PsiElement)containingClass)) {
            containingClass = null;
        }
        if (containingClass != null) {
            return new ClassUsageGroup((PsiClass)containingClass);
        }
        VirtualFile virtualFile = topLevelFile.getVirtualFile();
        if (virtualFile != null) {
            return new FileGroupingRule.FileUsageGroup(topLevelFile.getProject(), virtualFile);
        }
        return null;
    }

    private static String getFileNameWithoutExtension(PsiFile file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        return index < 0 ? name : name.substring(0, index);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "usage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "targets";
                break;
            }
        }
        objectArray[1] = "com/intellij/usages/impl/rules/ClassGroupingRule";
        objectArray[2] = "getParentGroupFor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ClassUsageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final SmartPsiElementPointer myClassPointer;
        private final String myText;
        private final String myQName;
        private final Icon myIcon;

        ClassUsageGroup(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ClassUsageGroup.$$$reportNull$$$0(0);
            }
            this.myQName = aClass.getQualifiedName();
            this.myText = ClassUsageGroup.createText(aClass);
            this.myClassPointer = SmartPointerManager.getInstance((Project)aClass.getProject()).createSmartPsiElementPointer((PsiElement)aClass);
            this.myIcon = aClass.getIcon(3);
        }

        public void update() {
        }

        private static String createText(PsiClass aClass) {
            String text2 = aClass.getName();
            for (PsiClass containingClass = aClass.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
                text2 = containingClass.getName() + '.' + text2;
            }
            return text2;
        }

        public Icon getIcon(boolean isOpen) {
            return this.myIcon;
        }

        @NotNull
        public String getText(UsageView view) {
            String string = this.myText;
            if (string == null) {
                ClassUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        public FileStatus getFileStatus() {
            return this.isValid() ? NavigationItemFileStatus.get((NavigationItem)this.getPsiClass()) : null;
        }

        private PsiClass getPsiClass() {
            return (PsiClass)this.myClassPointer.getElement();
        }

        public boolean isValid() {
            PsiClass psiClass = this.getPsiClass();
            return psiClass != null && psiClass.isValid();
        }

        public int hashCode() {
            return this.myQName.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof ClassUsageGroup && this.myQName.equals(((ClassUsageGroup)object).myQName);
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            if (this.canNavigate()) {
                this.getPsiClass().navigate(focus);
            }
        }

        public boolean canNavigate() {
            return this.isValid();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                ClassUsageGroup.$$$reportNull$$$0(2);
            }
            return this.getText(null).compareToIgnoreCase(usageGroup.getText(null));
        }

        public void calcData(@NotNull DataKey key2, @NotNull DataSink sink) {
            PsiClass psiClass;
            if (key2 == null) {
                ClassUsageGroup.$$$reportNull$$$0(3);
            }
            if (sink == null) {
                ClassUsageGroup.$$$reportNull$$$0(4);
            }
            if (!this.isValid()) {
                return;
            }
            if (CommonDataKeys.PSI_ELEMENT == key2) {
                sink.put(CommonDataKeys.PSI_ELEMENT, (Object)this.getPsiClass());
            }
            if (UsageView.USAGE_INFO_KEY == key2 && (psiClass = this.getPsiClass()) != null) {
                sink.put(UsageView.USAGE_INFO_KEY, (Object)new UsageInfo((PsiElement)psiClass));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/ClassGroupingRule$ClassUsageGroup";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageGroup";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/ClassGroupingRule$ClassUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "calcData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

