/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.abstraction.ConcreteClassUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceofInterfacesInspection
extends BaseInspection {
    private static final CallMatcher OBJECT_GET_CLASS = CallMatcher.exactInstanceCall("java.lang.Object", "getClass").parameterCount(0);
    public boolean ignoreAbstractClasses = false;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("InstanceofConcreteClass" == null) {
            InstanceofInterfacesInspection.$$$reportNull$$$0(0);
        }
        return "InstanceofConcreteClass";
    }

    @Nullable
    public String getAlternativeID() {
        return "InstanceofInterfaces";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("instanceof.concrete.class.display.name", new Object[0]);
        if (string == null) {
            InstanceofInterfacesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message(infos[0] instanceof PsiInstanceOfExpression ? "instanceof.concrete.class.problem.descriptor" : "instanceof.concrete.class.equality.problem.descriptor", new Object[0]);
        if (string == null) {
            InstanceofInterfacesInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("instanceof.interfaces.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAbstractClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofInterfacesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/InstanceofInterfacesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class InstanceofInterfacesVisitor
    extends BaseInspectionVisitor {
        private InstanceofInterfacesVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            PsiExpression other;
            if (OBJECT_GET_CLASS.test(call) && (other = ExpressionUtils.getExpressionComparedTo((PsiExpression)call)) instanceof PsiClassObjectAccessExpression) {
                this.checkTypeElement(((PsiClassObjectAccessExpression)other).getOperand());
            }
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression2) {
            if (expression2 == null) {
                InstanceofInterfacesVisitor.$$$reportNull$$$0(0);
            }
            this.checkTypeElement(expression2.getCheckType());
        }

        public void checkTypeElement(PsiTypeElement typeElement) {
            if (!ConcreteClassUtil.typeIsConcreteClass(typeElement, InstanceofInterfacesInspection.this.ignoreAbstractClasses)) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (MethodUtils.isEquals(method)) {
                return;
            }
            this.registerError((PsiElement)typeElement, typeElement.getParent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/abstraction/InstanceofInterfacesInspection$InstanceofInterfacesVisitor", "visitInstanceOfExpression"));
        }
    }
}

