/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfiniteLoopStatementInspection
extends BaseInspection {
    boolean myIgnoreInThreadTopLevel = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore when placed in Thread.run", (InspectionProfileEntry)this, "myIgnoreInThreadTopLevel");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("infinite.loop.statement.display.name", new Object[0]);
        if (string == null) {
            InfiniteLoopStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("infinite.loop.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            InfiniteLoopStatementInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InfiniteLoopStatementsVisitor(this.myIgnoreInThreadTopLevel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/InfiniteLoopStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class InfiniteLoopStatementsVisitor
    extends BaseInspectionVisitor {
        final boolean myIgnoreInThreadTopLevel;

        InfiniteLoopStatementsVisitor(boolean ignoreInThreadTopLevel) {
            this.myIgnoreInThreadTopLevel = ignoreInThreadTopLevel;
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                InfiniteLoopStatementsVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement);
            this.checkStatement((PsiStatement)statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                InfiniteLoopStatementsVisitor.$$$reportNull$$$0(1);
            }
            super.visitWhileStatement(statement);
            this.checkStatement((PsiStatement)statement);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                InfiniteLoopStatementsVisitor.$$$reportNull$$$0(2);
            }
            super.visitDoWhileStatement(statement);
            this.checkStatement((PsiStatement)statement);
        }

        private void checkStatement(PsiStatement statement) {
            PsiExpression argument;
            PsiClass maybeAnonymous;
            PsiClass aClass;
            boolean allUsagesAreInThreadStart;
            PsiMethod method;
            PsiElement parent;
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) {
                return;
            }
            if (ControlFlowUtils.containsReturn((PsiElement)statement)) {
                return;
            }
            if (ControlFlowUtils.containsSystemExit((PsiElement)statement)) {
                return;
            }
            if (this.myIgnoreInThreadTopLevel && ((parent = PsiTreeUtil.findFirstParent((PsiElement)statement, element -> element instanceof PsiMethod || element instanceof PsiLambdaExpression || element instanceof PsiAnonymousClass)) instanceof PsiMethod ? ((method = (PsiMethod)parent).hasModifier(JvmModifier.PRIVATE) ? (allUsagesAreInThreadStart = ((StreamEx)StreamEx.ofTree((Object)(aClass = method.getContainingClass()), element -> StreamEx.of((Object[])element.getChildren())).filter(element -> {
                if (element instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression call = (PsiMethodCallExpression)element;
                    return call.getMethodExpression().isReferenceTo((PsiElement)method);
                }
                if (element instanceof PsiMethodReferenceExpression) {
                    PsiMethodReferenceExpression methodReference = (PsiMethodReferenceExpression)element;
                    return methodReference.isReferenceTo((PsiElement)method);
                }
                return false;
            })).select(PsiExpression.class).allMatch(inArgument -> {
                if (inArgument instanceof PsiMethodCallExpression) {
                    return InfiniteLoopStatementsVisitor.isArgumentInThreadConstructor(inArgument);
                }
                if (inArgument instanceof PsiMethodReferenceExpression) {
                    return InfiniteLoopStatementsVisitor.isInThreadConstructor(inArgument);
                }
                return false;
            })) : (maybeAnonymous = (PsiClass)ObjectUtils.tryCast((Object)method.getContainingClass(), PsiAnonymousClass.class)) != null && "run".equals(method.getName()) && method.getParameterList().isEmpty() && InfiniteLoopStatementsVisitor.isInThreadConstructor(argument = (PsiExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)maybeAnonymous.getParent()), PsiExpression.class))) : parent instanceof PsiLambdaExpression && InfiniteLoopStatementsVisitor.isInThreadConstructor((PsiExpression)parent))) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private static boolean isArgumentInThreadConstructor(@Nullable PsiExpression inArgument) {
            PsiElement skipped = PsiUtil.skipParenthesizedExprUp((PsiElement)inArgument);
            if (skipped == null) {
                return false;
            }
            PsiElement argParent = skipped.getParent();
            PsiExpression argument = null;
            if (argParent instanceof PsiLambdaExpression) {
                argument = (PsiExpression)argParent;
            } else if (argParent instanceof PsiAnonymousClass) {
                argument = (PsiExpression)ObjectUtils.tryCast((Object)argParent, PsiNewExpression.class);
            }
            return InfiniteLoopStatementsVisitor.isInThreadConstructor(argument);
        }

        private static boolean isInThreadConstructor(PsiExpression argument) {
            PsiClass aClass;
            PsiMethod constructor;
            PsiElement argumentParent;
            PsiConstructorCall constructorCall;
            return argument != null && (constructorCall = (PsiConstructorCall)ObjectUtils.tryCast((Object)(argumentParent = PsiUtil.skipParenthesizedExprUp((PsiElement)PsiUtil.skipParenthesizedExprUp((PsiElement)argument).getParent())).getParent(), PsiConstructorCall.class)) != null && (constructor = constructorCall.resolveConstructor()) != null && (aClass = constructor.getContainingClass()) != null && "java.lang.Thread".equals(aClass.getQualifiedName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/controlflow/InfiniteLoopStatementInspection$InfiniteLoopStatementsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

