/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingDeprecatedAnnotationInspection
extends BaseInspection {
    public boolean warnOnMissingJavadoc = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("missing.deprecated.annotation.display.name", new Object[0]);
        if (string == null) {
            MissingDeprecatedAnnotationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean annotationWarning = (Boolean)infos[0];
        String string = annotationWarning ? InspectionGadgetsBundle.message("missing.deprecated.annotation.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("missing.deprecated.tag.problem.descriptor", new Object[0]);
        if (string == null) {
            MissingDeprecatedAnnotationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("missing.deprecated.tag.option", new Object[0]), (InspectionProfileEntry)this, "warnOnMissingJavadoc");
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean annotationWarning = (Boolean)infos[0];
        if (!annotationWarning) {
            return null;
        }
        return new MissingDeprecatedAnnotationFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MissingDeprecatedAnnotationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MissingDeprecatedAnnotationVisitor
    extends BaseInspectionVisitor {
        private MissingDeprecatedAnnotationVisitor() {
        }

        public void visitModule(@NotNull PsiJavaModule module) {
            if (module == null) {
                MissingDeprecatedAnnotationVisitor.$$$reportNull$$$0(0);
            }
            super.visitModule(module);
            if (this.hasDeprecatedAnnotation((PsiModifierListOwner)module)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !this.hasDeprecatedComment((PsiJavaDocumentedElement)module, true)) {
                    this.registerModuleError(module, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment((PsiJavaDocumentedElement)module, false)) {
                this.registerModuleError(module, Boolean.TRUE);
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                MissingDeprecatedAnnotationVisitor.$$$reportNull$$$0(1);
            }
            super.visitClass(aClass);
            if (this.hasDeprecatedAnnotation((PsiModifierListOwner)aClass)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !this.hasDeprecatedComment((PsiJavaDocumentedElement)aClass, true)) {
                    this.registerClassError(aClass, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment((PsiJavaDocumentedElement)aClass, false)) {
                this.registerClassError(aClass, Boolean.TRUE);
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MissingDeprecatedAnnotationVisitor.$$$reportNull$$$0(2);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (this.hasDeprecatedAnnotation((PsiModifierListOwner)method)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc) {
                    PsiMethod m = method;
                    while (m != null) {
                        if (this.hasDeprecatedComment((PsiJavaDocumentedElement)m, true)) {
                            return;
                        }
                        m = MethodUtils.getSuper(m);
                    }
                    this.registerMethodError(method, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment((PsiJavaDocumentedElement)method, false)) {
                this.registerMethodError(method, Boolean.TRUE);
            }
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                MissingDeprecatedAnnotationVisitor.$$$reportNull$$$0(3);
            }
            if (this.hasDeprecatedAnnotation((PsiModifierListOwner)field)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !this.hasDeprecatedComment((PsiJavaDocumentedElement)field, true)) {
                    this.registerFieldError(field, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment((PsiJavaDocumentedElement)field, false)) {
                this.registerFieldError(field, Boolean.TRUE);
            }
        }

        private boolean hasDeprecatedAnnotation(PsiModifierListOwner element) {
            PsiModifierList modifierList = element.getModifierList();
            return modifierList != null && modifierList.hasAnnotation("java.lang.Deprecated");
        }

        private boolean hasDeprecatedComment(PsiJavaDocumentedElement element, boolean checkContent) {
            PsiDocComment comment = element.getDocComment();
            if (comment == null) {
                return false;
            }
            PsiDocTag deprecatedTag = comment.findTagByName("deprecated");
            if (deprecatedTag == null) {
                return false;
            }
            return !checkContent || deprecatedTag.getValueElement() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModule";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MissingDeprecatedAnnotationFix
    extends InspectionGadgetsFix {
        private MissingDeprecatedAnnotationFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("missing.deprecated.annotation.add.quickfix", new Object[0]);
            if (string == null) {
                MissingDeprecatedAnnotationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement identifier = descriptor.getPsiElement();
            PsiModifierListOwner parent = (PsiModifierListOwner)identifier.getParent();
            if (parent == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiAnnotation annotation = factory.createAnnotationFromText("@java.lang.Deprecated", (PsiElement)parent);
            PsiModifierList modifierList = parent.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.addAfter((PsiElement)annotation, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationFix", "getFamilyName"));
        }
    }
}

