/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.migration.ForCanBeForeachInspection;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhileCanBeForeachInspection
extends BaseInspection {
    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new WhileCanBeForeachFix();
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("WhileLoopReplaceableByForEach" == null) {
            WhileCanBeForeachInspection.$$$reportNull$$$0(0);
        }
        return "WhileLoopReplaceableByForEach";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("while.can.be.foreach.display.name", new Object[0]);
        if (string == null) {
            WhileCanBeForeachInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("while.can.be.foreach.problem.descriptor", new Object[0]);
        if (string == null) {
            WhileCanBeForeachInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WhileCanBeForeachVisitor();
    }

    @Nullable
    static PsiStatement getPreviousStatement(PsiElement context) {
        PsiElement prevStatement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)context);
        if (!(prevStatement instanceof PsiStatement)) {
            return null;
        }
        return (PsiStatement)prevStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/migration/WhileCanBeForeachInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class IteratorHasNextVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean hasNextCalled;
        private final PsiVariable iterator;

        private IteratorHasNextVisitor(@NotNull PsiVariable iterator) {
            if (iterator == null) {
                IteratorHasNextVisitor.$$$reportNull$$$0(0);
            }
            this.iterator = iterator;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                IteratorHasNextVisitor.$$$reportNull$$$0(1);
            }
            if (!this.hasNextCalled) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                IteratorHasNextVisitor.$$$reportNull$$$0(2);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"hasNext".equals(name)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (this.iterator.equals(target)) {
                this.hasNextCalled = true;
            }
        }

        boolean isHasNextCalled() {
            return this.hasNextCalled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/WhileCanBeForeachInspection$IteratorHasNextVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NumberCallsToIteratorNextVisitor
    extends JavaRecursiveElementVisitor {
        private int numCallsToIteratorNext;
        private final PsiVariable iterator;

        private NumberCallsToIteratorNextVisitor(PsiVariable iterator) {
            this.iterator = iterator;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression callExpression) {
            if (callExpression == null) {
                NumberCallsToIteratorNextVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(callExpression);
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"next".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!this.iterator.equals(target)) {
                return;
            }
            ++this.numCallsToIteratorNext;
        }

        int getNumCallsToIteratorNext() {
            return this.numCallsToIteratorNext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/siyeh/ig/migration/WhileCanBeForeachInspection$NumberCallsToIteratorNextVisitor", "visitMethodCallExpression"));
        }
    }

    private static class WhileCanBeForeachVisitor
    extends BaseInspectionVisitor {
        private WhileCanBeForeachVisitor() {
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement whileStatement) {
            if (whileStatement == null) {
                WhileCanBeForeachVisitor.$$$reportNull$$$0(0);
            }
            super.visitWhileStatement(whileStatement);
            if (!WhileCanBeForeachVisitor.isCollectionLoopStatement(whileStatement)) {
                return;
            }
            this.registerStatementError((PsiStatement)whileStatement, new Object[0]);
        }

        private static boolean isCollectionLoopStatement(PsiWhileStatement whileStatement) {
            PsiStatement initialization = WhileCanBeForeachInspection.getPreviousStatement((PsiElement)whileStatement);
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration2.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            if (!TypeUtils.variableHasTypeOrSubtype(variable, "java.util.Iterator", "java.util.ListIterator")) {
                return false;
            }
            PsiExpression initialValue = variable.getInitializer();
            if (initialValue == null) {
                return false;
            }
            if (!(initialValue instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression initialCall = (PsiMethodCallExpression)initialValue;
            if (!initialCall.getArgumentList().isEmpty()) {
                return false;
            }
            PsiReferenceExpression initialMethodExpression = initialCall.getMethodExpression();
            String initialCallName = initialMethodExpression.getReferenceName();
            if (!"iterator".equals(initialCallName) && !"listIterator".equals(initialCallName)) {
                return false;
            }
            PsiExpression qualifier = ExpressionUtils.getQualifierOrThis(initialMethodExpression);
            if (qualifier instanceof PsiSuperExpression) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            if (!(qualifierType instanceof PsiClassType)) {
                return false;
            }
            PsiClass qualifierClass = ((PsiClassType)qualifierType).resolve();
            if (!InheritanceUtil.isInheritor((PsiClass)qualifierClass, (String)"java.lang.Iterable")) {
                return false;
            }
            PsiExpression condition2 = whileStatement.getCondition();
            if (!ForCanBeForeachInspection.isHasNext(condition2, variable)) {
                return false;
            }
            PsiStatement body2 = whileStatement.getBody();
            if (body2 == null) {
                return false;
            }
            if (WhileCanBeForeachVisitor.calculateCallsToIteratorNext(variable, (PsiElement)body2) != 1) {
                return false;
            }
            if (ForCanBeForeachInspection.isIteratorMethodCalled(variable, body2)) {
                return false;
            }
            if (WhileCanBeForeachVisitor.isIteratorHasNextCalled(variable, (PsiElement)body2)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, (PsiElement)body2)) {
                return false;
            }
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, (PsiElement)body2)) {
                return false;
            }
            for (PsiElement nextSibling = whileStatement.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                if (!VariableAccessUtils.variableValueIsUsed(variable, nextSibling)) continue;
                return false;
            }
            return true;
        }

        private static int calculateCallsToIteratorNext(PsiVariable iterator, PsiElement context) {
            NumberCallsToIteratorNextVisitor visitor = new NumberCallsToIteratorNextVisitor(iterator);
            context.accept((PsiElementVisitor)visitor);
            return visitor.getNumCallsToIteratorNext();
        }

        private static boolean isIteratorHasNextCalled(PsiVariable iterator, PsiElement context) {
            IteratorHasNextVisitor visitor = new IteratorHasNextVisitor(iterator);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isHasNextCalled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whileStatement", "com/siyeh/ig/migration/WhileCanBeForeachInspection$WhileCanBeForeachVisitor", "visitWhileStatement"));
        }
    }

    private static class WhileCanBeForeachFix
    extends InspectionGadgetsFix {
        private WhileCanBeForeachFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("foreach.replace.quickfix", new Object[0]);
            if (string == null) {
                WhileCanBeForeachFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement whileElement = descriptor.getPsiElement();
            PsiWhileStatement whileStatement = (PsiWhileStatement)whileElement.getParent();
            WhileCanBeForeachFix.replaceWhileWithForEach(whileStatement);
        }

        private static void replaceWhileWithForEach(@NotNull PsiWhileStatement whileStatement) {
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            PsiStatement body2;
            if (whileStatement == null) {
                WhileCanBeForeachFix.$$$reportNull$$$0(1);
            }
            if ((body2 = whileStatement.getBody()) == null) {
                return;
            }
            PsiStatement initialization = WhileCanBeForeachInspection.getPreviousStatement((PsiElement)whileStatement);
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
            if (declaration2 == null) {
                return;
            }
            PsiElement declaredElement = declaration2.getDeclaredElements()[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable iterator = (PsiLocalVariable)declaredElement;
            PsiMethodCallExpression initializer = (PsiMethodCallExpression)iterator.getInitializer();
            if (initializer == null) {
                return;
            }
            PsiReferenceExpression methodExpression = initializer.getMethodExpression();
            PsiExpression collection = ExpressionUtils.getQualifierOrThis(methodExpression);
            PsiType collectionType = collection.getType();
            if (collectionType == null) {
                return;
            }
            PsiType contentType = ForCanBeForeachInspection.getContentType(collectionType, "java.lang.Iterable");
            if (contentType == null) {
                return;
            }
            PsiType iteratorContentType = ForCanBeForeachInspection.getContentType(iterator.getType(), "java.util.Iterator");
            if (TypeUtils.isJavaLangObject(iteratorContentType)) {
                iteratorContentType = ForCanBeForeachInspection.getContentType(initializer.getType(), "java.util.Iterator");
            }
            if (iteratorContentType == null) {
                return;
            }
            PsiStatement firstStatement = ForCanBeForeachInspection.getFirstStatement(body2);
            boolean isDeclaration = ForCanBeForeachInspection.isIteratorNextDeclaration(firstStatement, (PsiVariable)iterator, contentType);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiLocalVariable localVariable = (PsiLocalVariable)declaredElements[0];
                contentVariableName = localVariable.getName();
                iteratorContentType = localVariable.getType();
                statementToSkip = declarationStatement;
            } else {
                if (collection instanceof PsiReferenceExpression) {
                    PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)collection;
                    String collectionName = referenceElement.getReferenceName();
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)whileStatement, iteratorContentType, collectionName);
                } else {
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)whileStatement, iteratorContentType, null);
                }
                statementToSkip = null;
            }
            StringBuilder out = new StringBuilder();
            out.append("for(");
            if (JavaCodeStyleSettings.getInstance((PsiFile)whileStatement.getContainingFile()).GENERATE_FINAL_PARAMETERS) {
                out.append("final ");
            }
            String canonicalText = iteratorContentType.getCanonicalText();
            out.append(canonicalText).append(' ').append(contentVariableName).append(": ");
            if (!TypeConversionUtil.isAssignable((PsiType)iteratorContentType, (PsiType)contentType)) {
                out.append("(java.lang.Iterable<").append(canonicalText).append(">)");
            }
            out.append(collection.getText()).append(')');
            ForCanBeForeachInspection.replaceIteratorNext((PsiElement)body2, contentVariableName, (PsiVariable)iterator, contentType, (PsiElement)statementToSkip, out);
            Query query = ReferencesSearch.search((PsiElement)iterator);
            boolean deleteIterator = true;
            for (PsiReference usage : query) {
                PsiElement element = usage.getElement();
                if (PsiTreeUtil.isAncestor((PsiElement)whileStatement, (PsiElement)element, (boolean)true)) continue;
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAssignmentExpression.class);
                if (assignment == null) {
                    deleteIterator = false;
                    break;
                }
                PsiExpression expression2 = assignment.getRExpression();
                PsiTypeElement typeElement = iterator.getTypeElement();
                if (typeElement.isInferredType() && (expression2 == null || PsiType.NULL.equals((Object)expression2.getType()) || expression2 instanceof PsiArrayInitializerExpression || expression2 instanceof PsiFunctionalExpression) && PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)typeElement) == null) {
                    deleteIterator = false;
                    break;
                }
                iterator.setInitializer(expression2);
                PsiElement statement = assignment.getParent();
                PsiElement lastChild = statement.getLastChild();
                if (lastChild instanceof PsiComment) {
                    iterator.add(lastChild);
                }
                statement.replace((PsiElement)iterator);
                break;
            }
            if (deleteIterator) {
                iterator.delete();
            }
            String result = out.toString();
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)whileStatement, result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/migration/WhileCanBeForeachInspection$WhileCanBeForeachFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "whileStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/migration/WhileCanBeForeachInspection$WhileCanBeForeachFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceWhileWithForEach";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

