/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalVariableHidingMemberVariableInspection
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;
    public boolean m_ignoreStaticMethods = true;

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @NotNull
    public String getID() {
        if ("LocalVariableHidesMemberVariable" == null) {
            LocalVariableHidingMemberVariableInspection.$$$reportNull$$$0(0);
        }
        return "LocalVariableHidesMemberVariable";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("local.variable.hides.member.variable.display.name", new Object[0]);
        if (string == null) {
            LocalVariableHidingMemberVariableInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("local.variable.hides.member.variable.problem.descriptor", aClass.getName());
        if (string == null) {
            LocalVariableHidingMemberVariableInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("field.name.hides.in.superclass.ignore.option", new Object[0]), "m_ignoreInvisibleFields");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("local.variable.hides.member.variable.ignore.option", new Object[0]), "m_ignoreStaticMethods");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LocalVariableHidingMemberVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class LocalVariableHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private LocalVariableHidingMemberVariableVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                LocalVariableHidingMemberVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitLocalVariable(variable);
            if (LocalVariableHidingMemberVariableInspection.this.m_ignoreStaticMethods && this.isContainedInStaticMethod((PsiElement)variable)) {
                return;
            }
            PsiClass aClass = this.checkFieldNames((PsiVariable)variable);
            if (aClass == null) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, aClass);
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            if (variable == null) {
                LocalVariableHidingMemberVariableVisitor.$$$reportNull$$$0(1);
            }
            super.visitParameter(variable);
            PsiElement declarationScope = variable.getDeclarationScope();
            if (!(declarationScope instanceof PsiCatchSection) && !(declarationScope instanceof PsiForeachStatement)) {
                return;
            }
            if (LocalVariableHidingMemberVariableInspection.this.m_ignoreStaticMethods && this.isContainedInStaticMethod((PsiElement)variable)) {
                return;
            }
            PsiClass aClass = this.checkFieldNames((PsiVariable)variable);
            if (aClass == null) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, aClass);
        }

        @Nullable
        private PsiClass checkFieldNames(PsiVariable variable) {
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)variable);
            String variableName = variable.getName();
            if (variableName == null) {
                return null;
            }
            while (aClass != null) {
                PsiField[] fields;
                for (PsiField field : fields = aClass.getAllFields()) {
                    String fieldName = field.getName();
                    if (!variableName.equals(fieldName) || LocalVariableHidingMemberVariableInspection.this.m_ignoreInvisibleFields && !ClassUtils.isFieldVisible(field, aClass)) continue;
                    return aClass;
                }
                if (LocalVariableHidingMemberVariableInspection.this.m_ignoreStaticMethods && (aClass.hasModifierProperty("static") || this.isContainedInStaticMethod((PsiElement)aClass))) {
                    return null;
                }
                aClass = ClassUtils.getContainingClass((PsiElement)aClass);
            }
            return null;
        }

        private boolean isContainedInStaticMethod(PsiElement element) {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class, PsiClass.class});
            if (member instanceof PsiClass) {
                return false;
            }
            return member != null && member.hasModifierProperty("static");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "variable";
            objectArray2[1] = "com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspection$LocalVariableHidingMemberVariableVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

