/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.bool.ConjunctionPredicate;
import org.jetbrains.annotations.NotNull;

public class DemorgansIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)element;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.ANDAND)) {
            return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"&&", "||"});
        }
        return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"||", "&&"});
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConjunctionPredicate conjunctionPredicate = new ConjunctionPredicate();
        if (conjunctionPredicate == null) {
            DemorgansIntention.$$$reportNull$$$0(0);
        }
        return conjunctionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            DemorgansIntention.$$$reportNull$$$0(1);
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element;
        CommentTracker tracker = new CommentTracker();
        String newExpression = DemorgansIntention.convertConjunctionExpression(polyadicExpression, tracker);
        DemorgansIntention.replaceExpressionWithNegatedExpressionString(newExpression, (PsiExpression)polyadicExpression, tracker);
    }

    private static String convertConjunctionExpression(PsiPolyadicExpression polyadicExpression, CommentTracker tracker) {
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        boolean tokenTypeAndAnd = tokenType.equals(JavaTokenType.ANDAND);
        String flippedConjunction = tokenTypeAndAnd ? "||" : "&&";
        StringBuilder result = new StringBuilder();
        for (PsiExpression operand2 : polyadicExpression.getOperands()) {
            if (result.length() != 0) {
                result.append(flippedConjunction);
            }
            result.append(DemorgansIntention.convertLeafExpression(operand2, tokenTypeAndAnd, tracker));
        }
        return result.toString();
    }

    private static String convertLeafExpression(PsiExpression expression2, boolean tokenTypeAndAnd, CommentTracker tracker) {
        if (BoolUtils.isNegation(expression2)) {
            PsiExpression negatedExpression = BoolUtils.getNegated(expression2);
            if (negatedExpression == null) {
                return "";
            }
            return tracker.text(negatedExpression, tokenTypeAndAnd ? 14 : 13);
        }
        if (ComparisonUtils.isComparison(expression2)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            String negatedComparison = ComparisonUtils.getNegatedComparison(binaryExpression.getOperationTokenType());
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            assert (rhs != null);
            return tracker.text((PsiElement)lhs) + negatedComparison + tracker.text((PsiElement)rhs);
        }
        return '!' + tracker.text(expression2, 3);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/bool/DemorgansIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/bool/DemorgansIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

