/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.jsf;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.FacesDomModelManager;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.facet.SpringConfigurator;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SpringJsfConfigurator
implements SpringConfigurator {
    private static void configure(FacesConfig config) {
        if (!config.getXmlTag().isWritable()) {
            return;
        }
        GenericDomValue resolver = config.getApplication().getVariableResolver();
        if (resolver.getStringValue() == null) {
            resolver.setStringValue("org.springframework.web.jsf.DelegatingVariableResolver");
        }
    }

    public boolean configure(@NotNull Module module) {
        if (module == null) {
            SpringJsfConfigurator.$$$reportNull$$$0(0);
        }
        if (!JsfCommonUtils.isJsfSupported((Module)module)) {
            return false;
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        if (webFacets.isEmpty()) {
            return false;
        }
        for (WebFacet webFacet : webFacets) {
            for (FacesDomModel facesDomModel : FacesDomModelManager.getInstance((Project)webFacet.getModule().getProject()).getAllModels(webFacet)) {
                FacesConfig facesConfig = facesDomModel.getFacesConfig();
                WriteCommandAction.writeCommandAction((Project)module.getProject()).run(() -> SpringJsfConfigurator.configure(facesConfig));
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/jsf/SpringJsfConfigurator", "configure"));
    }
}

