/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.AbstractSimpleSpringModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.visitors.CommonSpringModelVisitorContext;
import com.intellij.spring.contexts.model.visitors.SpringModelVisitors;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.PsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringModelVisitorUtils {
    private static final CommonSpringModelVisitorContext.Exec<SpringBeanPointer> DOM_BEANS = (m, p) -> {
        if (m instanceof LocalXmlModel) {
            for (SpringBeanPointer pointer : ((LocalXmlModel)m).getLocalBeans()) {
                if (p.process((Object)pointer)) continue;
                return false;
            }
        }
        return true;
    };
    private static final CommonSpringModelVisitorContext.Exec<SpringBeanPointer> PLACEHOLDERS = (m, p) -> {
        if (m instanceof LocalXmlModel) {
            for (SpringBeanPointer pointer : ((LocalXmlModel)m).getPlaceholderConfigurerBeans()) {
                if (p.process((Object)pointer)) continue;
                return false;
            }
        }
        return true;
    };
    private static final CommonSpringModelVisitorContext.Exec<SpringBeansPackagesScan> SCANS = (m, p) -> {
        if (m instanceof LocalModel) {
            for (SpringBeansPackagesScan scan : ((LocalModel)m).getPackagesScans()) {
                if (p.process((Object)scan)) continue;
                return false;
            }
        }
        return true;
    };
    private static final CommonSpringModelVisitorContext.Exec<SpringBeanPointer> ANNO_CONFIGS = (m, p) -> {
        if (m instanceof LocalXmlModel) {
            for (SpringBeanPointer pointer : ((LocalXmlModel)m).getAnnotationConfigAppContexts()) {
                if (p.process((Object)pointer)) continue;
                return false;
            }
        }
        return true;
    };
    private static final CommonSpringModelVisitorContext.Exec<String> PROFILES = (m, p) -> {
        if (m instanceof AbstractSimpleSpringModel) {
            for (String s : ((AbstractSimpleSpringModel)m).getProfiles()) {
                if (p.process((Object)s)) continue;
                return false;
            }
        }
        return true;
    };

    @NotNull
    public static Set<String> getProfiles(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(0);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        SpringModelVisitors.visitRelatedModels(model, CommonSpringModelVisitorContext.context(processor, PROFILES));
        HashSet hashSet = ContainerUtil.newHashSet((Iterable)processor.getResults());
        if (hashSet == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<SpringBeanPointer> getAllDomBeans(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(2);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        SpringModelVisitors.visitRelatedModels(model, CommonSpringModelVisitorContext.context(processor, DOM_BEANS));
        Collection collection = processor.getResults();
        if (collection == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public static Collection<PsiElementPointer> getDuplicatedNames(@NotNull CommonSpringModel model, @NotNull String beanName) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(4);
        }
        if (beanName == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(5);
        }
        ArrayList pointers = ContainerUtil.newArrayList();
        SpringModelVisitors.visitRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor((Collection)pointers), (m, p) -> {
            if (beanName == null) {
                SpringModelVisitorUtils.$$$reportNull$$$0(33);
            }
            if (m instanceof LocalXmlModel) {
                for (PsiElementPointer pointer : ((LocalXmlModel)m).getDuplicatedBeanNames(beanName)) {
                    if (p.process((Object)pointer)) continue;
                    return false;
                }
            }
            return true;
        }));
        return pointers;
    }

    @NotNull
    public static List<SpringBeanPointer> getPlaceholderConfigurers(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(6);
        }
        ArrayList placeholders = ContainerUtil.newArrayList();
        SpringModelVisitors.visitRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor((Collection)placeholders), PLACEHOLDERS));
        ArrayList arrayList = placeholders;
        if (arrayList == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public static List<SpringBeansPackagesScan> getComponentScans(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(8);
        }
        ArrayList scans = ContainerUtil.newArrayList();
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor((Collection)scans), SCANS));
        ArrayList arrayList = scans;
        if (arrayList == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static boolean hasComponentScans(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(10);
        }
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(processor, SCANS));
        return processor.isFound();
    }

    @NotNull
    public static List<SpringBeanPointer> getAnnotationConfigApplicationContexts(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(11);
        }
        LinkedList pointers = ContainerUtil.newLinkedList();
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor((Collection)pointers), ANNO_CONFIGS));
        LinkedList linkedList = pointers;
        if (linkedList == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(12);
        }
        return linkedList;
    }

    public static Collection<XmlTag> getCustomBeanCandidates(@NotNull CommonSpringModel model, String id) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(13);
        }
        HashSet tags = ContainerUtil.newHashSet();
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor((Collection)tags), (m, p) -> {
            if (m instanceof LocalXmlModel) {
                for (XmlTag xmlTag : ((LocalXmlModel)m).getCustomBeans(id)) {
                    if (p.process((Object)xmlTag)) continue;
                    return false;
                }
            }
            return true;
        }));
        return tags;
    }

    @NotNull
    public static List<SpringBeanPointer> getDescendants(@NotNull CommonSpringModel model, @NotNull SpringBeanPointer context) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(14);
        }
        if (context == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(15);
        }
        LinkedList pointers = ContainerUtil.newLinkedList();
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor((Collection)pointers), (m, p) -> {
            if (context == null) {
                SpringModelVisitorUtils.$$$reportNull$$$0(32);
            }
            if (m instanceof LocalXmlModel) {
                for (SpringBeanPointer pointer : ((LocalXmlModel)m).getDescendantBeans(context)) {
                    if (p.process((Object)pointer)) continue;
                    return false;
                }
            }
            return true;
        }));
        LinkedList linkedList = pointers;
        if (linkedList == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(16);
        }
        return linkedList;
    }

    @NotNull
    public static Set<String> getAllBeanNames(@NotNull CommonSpringModel model, @NotNull SpringBeanPointer pointer) {
        String name;
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(17);
        }
        if (pointer == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(18);
        }
        if (StringUtil.isEmptyOrSpaces((String)(name = pointer.getName()))) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringModelVisitorUtils.$$$reportNull$$$0(19);
            }
            return set;
        }
        HashSet results = ContainerUtil.newHashSet();
        SpringModelVisitors.visitRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor((Collection)results), (m, p) -> {
            if (pointer == null) {
                SpringModelVisitorUtils.$$$reportNull$$$0(31);
            }
            if (m instanceof AbstractSimpleSpringModel) {
                for (String s : ((AbstractSimpleSpringModel)m).getAllBeanNames(pointer)) {
                    if (p.process((Object)s)) continue;
                    return false;
                }
            }
            return true;
        }));
        Set<Object> set = results.size() > 0 ? ContainerUtil.newHashSet((Iterable)results) : Collections.singleton(name);
        if (set == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    public static List<SpringBeanPointer> findQualifiedBeans(@NotNull CommonSpringModel model, @NotNull SpringQualifier qualifier) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(21);
        }
        if (qualifier == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(22);
        }
        LinkedList pointers = ContainerUtil.newLinkedList();
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor((Collection)pointers), (m, p) -> {
            if (qualifier == null) {
                SpringModelVisitorUtils.$$$reportNull$$$0(30);
            }
            if (m instanceof AbstractSimpleSpringModel) {
                for (SpringBeanPointer pointer : ((AbstractSimpleSpringModel)m).findQualified(qualifier)) {
                    if (p.process((Object)pointer)) continue;
                    return false;
                }
            }
            return true;
        }));
        LinkedList linkedList = pointers;
        if (linkedList == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(23);
        }
        return linkedList;
    }

    @NotNull
    public static Set<PsiFile> getConfigFiles(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(24);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor((Collection)ContainerUtil.newHashSet());
        SpringModelVisitorUtils.processConfigFiles(model, (Processor<? super PsiFile>)processor);
        HashSet hashSet = ContainerUtil.newHashSet((Iterable)processor.getResults());
        if (hashSet == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(25);
        }
        return hashSet;
    }

    public static boolean hasConfigFile(@NotNull CommonSpringModel model, final @NotNull PsiFile configFile) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(26);
        }
        if (configFile == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(27);
        }
        CommonProcessors.FindFirstProcessor<PsiFile> findProcessor = new CommonProcessors.FindFirstProcessor<PsiFile>(){

            protected boolean accept(PsiFile file) {
                return configFile.equals(file);
            }
        };
        SpringModelVisitorUtils.processConfigFiles(model, (Processor<? super PsiFile>)findProcessor);
        return findProcessor.isFound();
    }

    public static void processConfigFiles(@NotNull CommonSpringModel model, @NotNull Processor<? super PsiFile> processor) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(28);
        }
        if (processor == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(29);
        }
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(processor, (m, p) -> {
            PsiFile file;
            return !(m instanceof LocalModel) || (file = ((LocalModel)m).getConfig().getContainingFile()) == null || p.process((Object)file);
        }), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/SpringModelVisitorUtils";
                break;
            }
            case 5: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
            case 15: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/SpringModelVisitorUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDomBeans";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderConfigurers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentScans";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationConfigApplicationContexts";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescendants";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBeanNames";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findQualifiedBeans";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProfiles";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 25: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllDomBeans";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicatedNames";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderConfigurers";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getComponentScans";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasComponentScans";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationConfigApplicationContexts";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCustomBeanCandidates";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDescendants";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllBeanNames";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findQualifiedBeans";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFiles";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFile";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processConfigFiles";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findQualifiedBeans$9";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllBeanNames$8";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDescendants$7";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDuplicatedNames$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

