/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleLocalAnnotationModel
extends LocalAnnotationModel {
    @NotNull
    protected final PsiClass myClass;
    @NotNull
    protected final Module myModule;
    @NotNull
    protected final Set<String> myActiveProfiles;

    public AbstractSimpleLocalAnnotationModel(@NotNull PsiClass aClass, @NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (aClass == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(0);
        }
        if (module == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(1);
        }
        if (activeProfiles == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(2);
        }
        this.myClass = aClass;
        this.myModule = module;
        this.myActiveProfiles = activeProfiles;
    }

    @Override
    @NotNull
    public PsiClass getConfig() {
        PsiClass psiClass = this.myClass;
        if (psiClass == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(3);
        }
        return psiClass;
    }

    @Override
    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        Set beans = (Set)RecursionManager.createGuard((String)"AbstractSimpleLocalAnnotationModel#calculateAllBeans").doPreventingRecursion((Object)this.myClass, true, () -> {
            LinkedHashSet allBeans = ContainerUtil.newLinkedHashSet();
            ContainerUtil.addIfNotNull((Collection)allBeans, (Object)AbstractSimpleLocalAnnotationModel.getBeanForClass(this.myClass));
            allBeans.addAll(SpringJamUtils.getInstance().getContextBeans(this.myClass, this.getActiveProfiles()));
            return BeanService.getInstance().mapSpringBeans(allBeans);
        });
        return beans == null ? Collections.emptySet() : beans;
    }

    @Nullable
    private static CommonSpringBean getBeanForClass(@NotNull PsiClass aClass) {
        JamPsiMemberSpringBean psiMemberSpringBean;
        if (aClass == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(4);
        }
        if ((psiMemberSpringBean = (JamPsiMemberSpringBean)JamService.getJamService((Project)aClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)aClass)) != null) {
            return psiMemberSpringBean;
        }
        if (!aClass.isInterface() && !aClass.hasModifierProperty("abstract") && SpringCommonUtils.isSpringBeanCandidateClass(aClass)) {
            return new CustomSpringComponent(aClass);
        }
        return null;
    }

    @Override
    public Set<CommonSpringModel> getRelatedModels() {
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        ContainerUtil.addAllNotNull((Collection)models, this.getRelatedLocalModels());
        ContainerUtil.addAllNotNull((Collection)models, this.getCachedPackageScanModel());
        ContainerUtil.addAllNotNull((Collection)models, this.getCachedInnerStaticClassConfigurations());
        ContainerUtil.addAllNotNull((Collection)models, (Object[])new CommonSpringModel[]{this.getCustomDiscoveredBeansModel()});
        return models;
    }

    @NotNull
    private Set<CommonSpringModel> getCachedPackageScanModel() {
        Set set = (Set)CachedValuesManager.getManager((Project)this.getConfig().getProject()).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create(this.getPackageScanModels(Collections.singleton(this), this.getModule(), this.getActiveProfiles()), (Object[])this.getOutsideModelDependencies(this)));
        if (set == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    protected Set<CommonSpringModel> getCachedInnerStaticClassConfigurations() {
        Set set = (Set)CachedValuesManager.getManager((Project)this.getConfig().getProject()).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create(this.getInnerStaticClassConfigurations(this.getConfig()), (Object[])this.getOutsideModelDependencies(this)));
        if (set == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(6);
        }
        return set;
    }

    public Set<CommonSpringModel> getInnerStaticClassConfigurations(@NotNull PsiClass config) {
        if (config == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(7);
        }
        return AbstractSimpleLocalAnnotationModel.getInnerStaticClassModels(config, aClass -> this.getLocalAnnotationModel((PsiClass)aClass));
    }

    public static Set<CommonSpringModel> getInnerStaticClassModels(@NotNull PsiClass config, Function<? super PsiClass, ? extends CommonSpringModel> mapper) {
        if (config == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(8);
        }
        return Arrays.stream(config.getAllInnerClasses()).filter(psiClass -> psiClass.hasModifierProperty("static") && JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass) != null).map(mapper).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(9);
        }
        return module;
    }

    @Override
    @NotNull
    public Set<String> getProfiles() {
        LinkedHashSet allProfiles = ContainerUtil.newLinkedHashSet();
        SpringConfiguration configuration = this.getConfiguration();
        if (configuration != null) {
            allProfiles.addAll(configuration.getProfile().getNames());
            for (SpringJavaBean springJavaBean : configuration.getBeans()) {
                allProfiles.addAll(springJavaBean.getProfile().getNames());
            }
        }
        LinkedHashSet linkedHashSet = allProfiles;
        if (linkedHashSet == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(10);
        }
        return linkedHashSet;
    }

    @Nullable
    public SpringConfiguration getConfiguration() {
        return (SpringConfiguration)JamService.getJamService((Project)this.myClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)this.myClass);
    }

    @Override
    @NotNull
    public List<SpringBeansPackagesScan> getPackagesScans() {
        List packageScans = ContainerUtil.newSmartList();
        packageScans.addAll(SpringJamUtils.getInstance().getBeansPackagesScan(this.myClass));
        for (PsiClass superClass : InheritanceUtil.getSuperClasses((PsiClass)this.myClass)) {
            if ("java.lang.Object".equals(superClass.getQualifiedName())) continue;
            packageScans.addAll(SpringJamUtils.getInstance().getBeansPackagesScan(superClass));
        }
        List list = packageScans;
        if (list == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(12);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        Set set = (Set)CachedValuesManager.getManager((Project)this.getConfig().getProject()).getCachedValue((UserDataHolder)this, () -> {
            Module module = this.getModule();
            HashSet models = ContainerUtil.newHashSet();
            if (!module.isDisposed()) {
                SpringJamUtils.getInstance().processImportedResources(this.myClass, (Processor<Pair<List<XmlFile>, ? extends PsiElement>>)((Processor)pair -> {
                    for (XmlFile xmlFile : (List)pair.first) {
                        AbstractSimpleLocalAnnotationModel.addNotNullModel(models, SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(xmlFile, module, this.getActiveProfiles()), LocalModelDependency.create(LocalModelDependencyType.IMPORT, (PsiElement)pair.second));
                    }
                    return true;
                }), this.myModule);
                SpringJamUtils.getInstance().processImportedClasses(this.myClass, (Processor<Pair<PsiClass, ? extends PsiElement>>)((Processor)pair -> {
                    AbstractSimpleLocalAnnotationModel.addNotNullModel(models, this.getLocalAnnotationModel((PsiClass)pair.first), LocalModelDependency.create(LocalModelDependencyType.IMPORT, (PsiElement)pair.second));
                    return true;
                }));
                AbstractSimpleLocalAnnotationModel.processScannedConfigurations(this.myClass, (Processor<Pair<PsiPackage, ? extends PsiElement>>)((Processor)pair -> {
                    if (module.isDisposed()) {
                        return false;
                    }
                    GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                    GlobalSearchScope searchScope = moduleScope.intersectWith(PackageScope.packageScope((PsiPackage)((PsiPackage)pair.first), (boolean)true));
                    List<SpringConfiguration> configurations = SpringJamModel.getModel(module).getConfigurations(searchScope);
                    for (SpringConfiguration configuration : configurations) {
                        if (!SpringCommonUtils.isSpringBeanCandidateClass(configuration.getPsiElement()) || !SpringProfileUtils.isProfileAccepted(configuration.getProfile(), this.getActiveProfiles())) continue;
                        PsiElement identifyingElementForDependency = (PsiElement)pair.second;
                        LocalModelDependency dependency = LocalModelDependency.create(LocalModelDependencyType.COMPONENT_SCAN, identifyingElementForDependency == null ? (PsiElement)pair.first : identifyingElementForDependency);
                        AbstractSimpleLocalAnnotationModel.addNotNullModel(models, this.getLocalAnnotationModel(configuration), dependency);
                    }
                    return true;
                }));
                SpringJamUtils.getInstance().processCustomAnnotations(this.myClass, (Processor<Pair<PsiClass, LocalModelDependency>>)((Processor)enableAnnotation -> {
                    AbstractSimpleLocalAnnotationModel.addNotNullModel(models, this.getLocalAnnotationModel((PsiClass)enableAnnotation.getFirst()), (LocalModelDependency)enableAnnotation.getSecond());
                    return true;
                }));
                SpringJamUtils.getInstance().processCustomDependentLocalModels(this, (PairProcessor<? super LocalModel, ? super LocalModelDependency>)((PairProcessor)(model, dependency) -> {
                    AbstractSimpleLocalAnnotationModel.addNotNullModel(models, model, dependency);
                    return true;
                }));
            }
            LinkedHashSet dependencies = ContainerUtil.newLinkedHashSet();
            ContainerUtil.addAll((Collection)dependencies, (Object[])this.getOutsideModelDependencies(this));
            ContainerUtil.addAll((Collection)dependencies, (Iterable)models.stream().map(pair -> ((LocalModel)pair.first).getConfig()).collect(Collectors.toSet()));
            return CachedValueProvider.Result.create((Object)models, (Object[])ArrayUtil.toObjectArray((Collection)dependencies));
        });
        if (set == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(13);
        }
        return set;
    }

    @Nullable
    protected LocalAnnotationModel getLocalAnnotationModel(@NotNull PsiClass aClass) {
        if (aClass == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(14);
        }
        return SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(aClass, this.getModule(), this.getActiveProfiles());
    }

    @Nullable
    private LocalAnnotationModel getLocalAnnotationModel(@NotNull SpringConfiguration configuration) {
        if (configuration == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(15);
        }
        return SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(configuration.getPsiElement(), this.getModule(), this.getActiveProfiles());
    }

    private static boolean processScannedConfigurations(@NotNull PsiClass classToProcess, @NotNull Processor<Pair<PsiPackage, ? extends PsiElement>> processor) {
        if (classToProcess == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            AbstractSimpleLocalAnnotationModel.$$$reportNull$$$0(17);
        }
        List<? extends SpringBeansPackagesScan> scans = SpringJamUtils.getInstance().getBeansPackagesScan(classToProcess);
        for (SpringBeansPackagesScan springBeansPackagesScan : scans) {
            if (springBeansPackagesScan instanceof SpringComponentScan) {
                SpringComponentScan componentScan = (SpringComponentScan)springBeansPackagesScan;
                if (componentScan.processPsiPackages(processor)) continue;
                return false;
            }
            for (PsiPackage aPackage : springBeansPackagesScan.getPsiPackages()) {
                if (processor.process((Object)Pair.create((Object)aPackage, (Object)springBeansPackagesScan.getIdentifyingPsiElement()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractSimpleLocalAnnotationModel)) {
            return false;
        }
        AbstractSimpleLocalAnnotationModel model = (AbstractSimpleLocalAnnotationModel)o;
        if (!this.myClass.equals(model.myClass)) {
            return false;
        }
        if (!this.myModule.equals(model.myModule)) {
            return false;
        }
        return SpringProfileUtils.profilesAsString(this.myActiveProfiles).equals(SpringProfileUtils.profilesAsString(model.myActiveProfiles));
    }

    public int hashCode() {
        int result = this.myClass.hashCode();
        result = 31 * result + this.myModule.hashCode();
        result = 31 * result + SpringProfileUtils.profilesAsString(this.myActiveProfiles).hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/AbstractSimpleLocalAnnotationModel";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToProcess";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/AbstractSimpleLocalAnnotationModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedPackageScanModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedInnerStaticClassConfigurations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesScans";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentLocalModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBeanForClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInnerStaticClassConfigurations";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInnerStaticClassModels";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAnnotationModel";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processScannedConfigurations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

