/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.AbstractSimpleSpringModel;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LazyModelDependenciesGraph;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleLocalModel<T extends PsiElement>
extends AbstractSimpleSpringModel
implements LocalModel<T> {
    private final NotNullLazyValue<CommonSpringModel> myCustomDiscoveredBeansModel = new VolatileNotNullLazyValue<CommonSpringModel>(){

        @NotNull
        protected CommonSpringModel compute() {
            BeansSpringModel beansSpringModel = new BeansSpringModel(AbstractSimpleLocalModel.this.getModule(), new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                @NotNull
                protected Collection<? extends SpringBeanPointer> compute() {
                    Collection collection = AbstractSimpleLocalModel.this.computeCustomBeans();
                    if (collection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return collection;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel$1$1", "compute"));
                }
            });
            if (beansSpringModel == null) {
                1.$$$reportNull$$$0(0);
            }
            return beansSpringModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel$1", "compute"));
        }
    };

    protected static void addNotNullModel(@NotNull Set<? super Pair<LocalModel, LocalModelDependency>> models, @Nullable LocalModel model, @NotNull LocalModelDependency dependency) {
        if (models == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(0);
        }
        if (dependency == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(1);
        }
        if (model != null) {
            models.add((Pair<LocalModel, LocalModelDependency>)Pair.create((Object)model, (Object)dependency));
        }
    }

    private Collection<? extends SpringBeanPointer> computeCustomBeans() {
        LinkedHashSet customSpringComponents = ContainerUtil.newLinkedHashSet();
        for (CustomLocalComponentsDiscoverer discoverer : CustomLocalComponentsDiscoverer.EP_NAME.getExtensionList()) {
            customSpringComponents.addAll(discoverer.getCustomComponents(this));
        }
        return BeanService.getInstance().mapSpringBeans(customSpringComponents);
    }

    protected CommonSpringModel getCustomDiscoveredBeansModel() {
        return (CommonSpringModel)this.myCustomDiscoveredBeansModel.getValue();
    }

    @Override
    @NotNull
    public Set<LocalModel> getRelatedLocalModels() {
        Set<LocalModel> set = this.getDependentLocalModels().stream().map(pair -> (LocalModel)pair.first).filter(model -> !this.equals(model)).collect(Collectors.toSet());
        if (set == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(2);
        }
        return set;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getConfig() + "]";
    }

    @NotNull
    protected Object[] getOutsideModelDependencies(@NotNull LocalModel model) {
        if (model == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(3);
        }
        Project project = model.getConfig().getProject();
        Object[] objectArray = ArrayUtil.append((Object[])SpringModificationTrackersManager.getInstance(project).getOuterModelsDependencies(), model.getConfig());
        if (objectArray == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    @Deprecated
    @NotNull
    public static LazyModelDependenciesGraph getOrCreateLocalModelDependenciesGraph(@NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (module == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(5);
        }
        if (activeProfiles == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(6);
        }
        LazyModelDependenciesGraph lazyModelDependenciesGraph = LazyModelDependenciesGraph.getOrCreateLocalModelDependenciesGraph(module, activeProfiles);
        if (lazyModelDependenciesGraph == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(7);
        }
        return lazyModelDependenciesGraph;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/AbstractSimpleLocalModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/AbstractSimpleLocalModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedLocalModels";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutsideModelDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLocalModelDependenciesGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addNotNullModel";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOutsideModelDependencies";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLocalModelDependenciesGraph";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

