/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiType;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.CachedLocalModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.SpringCachingProcessor;
import com.intellij.spring.contexts.model.SpringComponentScanModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleSpringModel
extends CachedLocalModel {
    private final SpringCachingProcessor<SpringModelSearchParameters.BeanClass> myBeanTypeCachingProcessor = new LocalBeansCachingProcessor<SpringModelSearchParameters.BeanClass>(){

        @Override
        protected void doProcessBeans(@NotNull SpringModelSearchParameters.BeanClass parameters, Processor<SpringBeanPointer> collectProcessor) {
            if (parameters == null) {
                1.$$$reportNull$$$0(0);
            }
            AbstractSimpleSpringModel.this.processLocalBeans(parameters, (Processor<SpringBeanPointer>)collectProcessor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel$1", "doProcessBeans"));
        }
    };
    private final SpringCachingProcessor<SpringModelSearchParameters.BeanName> myBeanNameCachingProcessor = new LocalBeansCachingProcessor<SpringModelSearchParameters.BeanName>(){

        @Override
        protected void doProcessBeans(@NotNull SpringModelSearchParameters.BeanName params, Processor<SpringBeanPointer> processor) {
            if (params == null) {
                2.$$$reportNull$$$0(0);
            }
            for (SpringBeanPointer beanPointer : AbstractSimpleSpringModel.this.getLocalBeans()) {
                if (!AbstractSimpleSpringModel.matchesName(params, beanPointer) || processor.process((Object)beanPointer)) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel$2", "doProcessBeans"));
        }
    };
    private final Map<SpringQualifier, List<SpringBeanPointer>> myLocalBeansByQualifier = ConcurrentFactoryMap.createMap(key -> this.computeLocalBeansByQualifier((SpringQualifier)key));

    @NotNull
    public Set<String> getProfiles() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    public boolean processByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(3);
        }
        if (!params.canSearch()) {
            return true;
        }
        if (!this.processLocalBeansByClass(params, processor).booleanValue()) {
            return false;
        }
        return super.processByClass(params, processor);
    }

    private void processLocalBeans(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(5);
        }
        PsiType searchType = params.getSearchType();
        if (params.isEffectiveBeanTypes()) {
            for (SpringBeanPointer beanPointer : this.getLocalBeans()) {
                for (PsiType effectiveBeanType : beanPointer.getEffectiveBeanTypes()) {
                    if (AbstractSimpleSpringModel.processLocalBeanClass(processor, searchType, beanPointer, effectiveBeanType)) continue;
                    return;
                }
            }
        } else {
            for (SpringBeanPointer beanPointer : this.getLocalBeans()) {
                if (AbstractSimpleSpringModel.processLocalBeanClass(processor, searchType, beanPointer, beanPointer.getSpringBean().getBeanType())) continue;
                return;
            }
        }
    }

    private static boolean processLocalBeanClass(@NotNull Processor<? super SpringBeanPointer> processor, @NotNull PsiType searchType, SpringBeanPointer beanPointer, @Nullable PsiType beanType) {
        if (processor == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(6);
        }
        if (searchType == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(7);
        }
        if (beanType != null && searchType.isAssignableFrom(beanType)) {
            return processor.process((Object)beanPointer);
        }
        return true;
    }

    @Override
    public boolean processByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(9);
        }
        if (!params.canSearch()) {
            return true;
        }
        if (!this.processLocalBeansByName(params, processor).booleanValue()) {
            return false;
        }
        return super.processByName(params, processor);
    }

    @NotNull
    public Boolean processLocalBeansByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(11);
        }
        if (!params.canSearch()) {
            Boolean bl = true;
            if (bl == null) {
                AbstractSimpleSpringModel.$$$reportNull$$$0(12);
            }
            return bl;
        }
        Boolean bl = this.myBeanTypeCachingProcessor.process(params, processor, this.getActiveProfiles());
        if (bl == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(13);
        }
        return bl;
    }

    @NotNull
    public Boolean processLocalBeansByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(15);
        }
        if (!params.canSearch()) {
            Boolean bl = true;
            if (bl == null) {
                AbstractSimpleSpringModel.$$$reportNull$$$0(16);
            }
            return bl;
        }
        Boolean bl = this.myBeanNameCachingProcessor.process(params, processor, this.getActiveProfiles());
        if (bl == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(17);
        }
        return bl;
    }

    @Override
    public final boolean processAllBeans(@NotNull Processor<SpringBeanPointer> processor) {
        if (processor == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(18);
        }
        for (SpringBeanPointer pointer : this.getLocalBeans()) {
            if (processor.process((Object)pointer)) continue;
            return false;
        }
        return super.processAllBeans(processor);
    }

    private static boolean matchesName(SpringModelSearchParameters.BeanName params, SpringBeanPointer pointer) {
        String paramsBeanName = params.getBeanName();
        if (paramsBeanName.equals(pointer.getName())) {
            return true;
        }
        for (String aliasName : pointer.getAliases()) {
            if (!paramsBeanName.equals(aliasName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected Set<CommonSpringModel> getPackageScanModels(@NotNull Set<? extends LocalModel> localModels, @NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (localModels == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(19);
        }
        if (module == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(20);
        }
        if (activeProfiles == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(21);
        }
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        for (LocalModel localModel : localModels) {
            List<SpringBeansPackagesScan> scans = localModel.getPackagesScans();
            for (SpringBeansPackagesScan scan : scans) {
                models.add(new SpringComponentScanModel<SpringBeansPackagesScan>(module, scan, activeProfiles));
            }
        }
        LinkedHashSet linkedHashSet = models;
        if (linkedHashSet == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(22);
        }
        return linkedHashSet;
    }

    @NotNull
    public Set<String> getAllBeanNames(@NotNull SpringBeanPointer beanPointer) {
        String beanName;
        if (beanPointer == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(23);
        }
        if (StringUtil.isEmptyOrSpaces((String)(beanName = beanPointer.getName()))) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                AbstractSimpleSpringModel.$$$reportNull$$$0(24);
            }
            return set;
        }
        HashSet names = ContainerUtil.newHashSet((Object[])new String[]{beanName});
        for (String aliasName : beanPointer.getAliases()) {
            if (StringUtil.isEmptyOrSpaces((String)aliasName)) continue;
            names.add(aliasName);
        }
        HashSet hashSet = names;
        if (hashSet == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(25);
        }
        return hashSet;
    }

    @NotNull
    public List<SpringBeanPointer> findQualified(@NotNull SpringQualifier qualifier) {
        if (qualifier == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(26);
        }
        List<SpringBeanPointer> list = this.myLocalBeansByQualifier.get(qualifier);
        if (list == null) {
            AbstractSimpleSpringModel.$$$reportNull$$$0(27);
        }
        return list;
    }

    private List<SpringBeanPointer> computeLocalBeansByQualifier(SpringQualifier springQualifier) {
        SmartList beans = new SmartList();
        Collection<SpringBeanPointer> pointers = this.getLocalBeans();
        for (SpringBeanPointer beanPointer : pointers) {
            if (!beanPointer.isValid()) continue;
            Object bean = beanPointer.getSpringBean();
            for (SpringQualifier qualifier : bean.getSpringQualifiers()) {
                if (!qualifier.compareQualifiers(springQualifier, this.getModule())) continue;
                beans.add(beanPointer);
            }
        }
        return beans.isEmpty() ? Collections.emptyList() : beans;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/AbstractSimpleSpringModel";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localModels";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/AbstractSimpleSpringModel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "processLocalBeansByClass";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "processLocalBeansByName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageScanModels";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBeanNames";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findQualified";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processByClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeans";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeanClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processByName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeansByClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeansByName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processAllBeans";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPackageScanModels";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAllBeanNames";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findQualified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class LocalBeansCachingProcessor<InParams extends SpringModelSearchParameters>
    extends SpringCachingProcessor<InParams> {
        private LocalBeansCachingProcessor() {
        }

        @Override
        @NotNull
        protected Collection<SpringBeanPointer> findPointers(@NotNull InParams parameters) {
            if (parameters == null) {
                LocalBeansCachingProcessor.$$$reportNull$$$0(0);
            }
            SmartList results = new SmartList();
            Processor collectProcessor = Processors.cancelableCollectProcessor((Collection)results);
            this.doProcessBeans(parameters, (Processor<SpringBeanPointer>)collectProcessor);
            SmartList smartList = results.isEmpty() ? Collections.emptyList() : results;
            if (smartList == null) {
                LocalBeansCachingProcessor.$$$reportNull$$$0(1);
            }
            return smartList;
        }

        @Override
        @Nullable
        protected SpringBeanPointer findFirstPointer(@NotNull InParams parameters) {
            if (parameters == null) {
                LocalBeansCachingProcessor.$$$reportNull$$$0(2);
            }
            CommonProcessors.FindFirstProcessor firstProcessor = new CommonProcessors.FindFirstProcessor();
            this.doProcessBeans(parameters, (Processor<SpringBeanPointer>)firstProcessor);
            return (SpringBeanPointer)firstProcessor.getFoundValue();
        }

        protected abstract void doProcessBeans(@NotNull InParams var1, Processor<SpringBeanPointer> var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/contexts/model/AbstractSimpleSpringModel$LocalBeansCachingProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/contexts/model/AbstractSimpleSpringModel$LocalBeansCachingProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findPointers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findPointers";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findFirstPointer";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

