/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.gutter;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.diagram.gutter.ModelDependenciesLineMarkerProviderBase;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastUtils;

public class ModelDependenciesLineMarkerProviderUast
extends ModelDependenciesLineMarkerProviderBase {
    public String getId() {
        return "ModelDependenciesLineMarkerProviderJava";
    }

    @Nullable
    public String getName() {
        return "Model Dependencies Graph";
    }

    @Override
    protected boolean isRelevantPsiElement(PsiElement psiElement) {
        UElement parent = UastUtils.getUParentForIdentifier((PsiElement)psiElement);
        if (!(parent instanceof UClass)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)parent, PsiClass.class);
        return psiClass != null && SpringCommonUtils.isConfigurationOrMeta(psiClass);
    }

    @Override
    @Nullable
    protected LineMarkerInfo doAnnotate(PsiElement element) {
        UElement parent = UastUtils.getUParentForIdentifier((PsiElement)element);
        if (!(parent instanceof UClass)) {
            return null;
        }
        PsiClass psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)parent, PsiClass.class);
        if (psiClass == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return null;
        }
        LocalAnnotationModel localAnnotationModel = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(psiClass, module, Collections.emptySet());
        if (localAnnotationModel == null) {
            return null;
        }
        return this.createLineMarkerInfo(element);
    }
}

