/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.factories.FactoriesBean;
import com.intellij.spring.factories.FactoryBeanInfo;
import com.intellij.spring.factories.ObjectTypeResolver;
import com.intellij.spring.factories.SpringFactoryBeanEP;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.factories.resolvers.BeanReferenceFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.FactoryPropertiesDependentTypeResolver;
import com.intellij.spring.factories.resolvers.JndiObjectFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.MethodInvokingFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.MyBatisPlaceMapperTypeResolver;
import com.intellij.spring.factories.resolvers.ProxyFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.ScopedProxyFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.SingleObjectTypeResolver;
import com.intellij.spring.factories.resolvers.SpringEjbTypeResolver;
import com.intellij.spring.factories.resolvers.TransactionProxyFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.UtilConstantTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.PsiTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class SpringFactoryBeansManagerImpl
extends SpringFactoryBeansManager {
    private static final Key<CachedValue<Set<PsiType>>> CACHED_OBJECT_TYPE = Key.create((String)"CACHED_OBJECT_TYPE");
    private final Map<String, ObjectTypeResolver> mySpringFactories = new HashMap<String, ObjectTypeResolver>();
    private final ObjectTypeResolver[] myCustomResolvers = new ObjectTypeResolver[]{new TransactionProxyFactoryBeanTypeResolver(), new JndiObjectFactoryBeanTypeResolver(), new SpringEjbTypeResolver(), new ProxyFactoryBeanTypeResolver(), new ScopedProxyFactoryBeanTypeResolver(), new BeanReferenceFactoryBeanTypeResolver(), new UtilConstantTypeResolver(), new MethodInvokingFactoryBeanTypeResolver(), new MyBatisPlaceMapperTypeResolver()};
    @NonNls
    private static final String FACTORIES_RESOURCE_XML = "/resources/factories/factories.xml";
    @NonNls
    private static final String PROPERTY_NAME_DELIMITER = ",";

    public SpringFactoryBeansManagerImpl() {
        FactoriesBean factoriesBean = (FactoriesBean)XmlSerializer.deserialize((URL)SpringFactoryBeansManagerImpl.class.getResource(FACTORIES_RESOURCE_XML), FactoriesBean.class);
        assert (factoriesBean.getFactories() != null);
        for (FactoryBeanInfo factoryBeanInfo : factoriesBean.getFactories()) {
            String factory = factoryBeanInfo.getFactory();
            if (factory == null || factory.trim().length() <= 0) continue;
            this.mySpringFactories.put(factory, this.getObjectTypeResolver(factoryBeanInfo));
        }
        for (SpringFactoryBeanEP extension : SpringFactoryBeanEP.EP_NAME.getExtensionList()) {
            this.mySpringFactories.put(extension.factoryClass, new SingleObjectTypeResolver(extension.productType));
        }
    }

    public int getIndexingVersion() {
        int result = 0;
        for (String key : this.mySpringFactories.keySet()) {
            result += key.hashCode();
        }
        return result;
    }

    @Nullable
    private ObjectTypeResolver getObjectTypeResolver(FactoryBeanInfo factoryBeanInfo) {
        String type = factoryBeanInfo.getObjectType();
        if (!StringUtil.isEmptyOrSpaces((String)type)) {
            return new SingleObjectTypeResolver(type);
        }
        String delimitedNames = factoryBeanInfo.getPropertyNames();
        if (!StringUtil.isEmptyOrSpaces((String)delimitedNames)) {
            return new FactoryPropertiesDependentTypeResolver(StringUtil.split((String)delimitedNames, (String)PROPERTY_NAME_DELIMITER));
        }
        String factoryClass = factoryBeanInfo.getFactory();
        for (ObjectTypeResolver customResolver : this.myCustomResolvers) {
            if (!customResolver.accept(factoryClass)) continue;
            return customResolver;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiType[] getObjectTypes(@NotNull PsiType factoryType, @Nullable CommonSpringBean context) {
        HashSet types;
        block5: {
            Set<String> names;
            PsiClass factoryClass;
            block3: {
                block4: {
                    if (factoryType == null) {
                        SpringFactoryBeansManagerImpl.$$$reportNull$$$0(0);
                    }
                    types = ContainerUtil.newHashSet();
                    factoryClass = factoryType instanceof PsiClassType ? ((PsiClassType)factoryType).resolve() : null;
                    Set<String> set = names = factoryClass != null ? this.getObjectTypeNames(factoryClass, context) : Collections.emptySet();
                    if (!names.isEmpty()) break block3;
                    Set<PsiType> psiTypes = SpringFactoryBeansManagerImpl.guessObjectTypes(factoryClass);
                    if (psiTypes.isEmpty()) break block4;
                    ContainerUtil.addAllNotNull((Collection)types, psiTypes);
                    break block5;
                }
                PsiType typeParameter = PsiUtil.substituteTypeParameter((PsiType)factoryType, (String)"org.springframework.beans.factory.FactoryBean", (int)0, (boolean)false);
                if (typeParameter == null || "java.lang.Object".equals(typeParameter.getCanonicalText())) break block5;
                types.add(typeParameter);
                break block5;
            }
            for (String typeName : names) {
                ContainerUtil.addIfNotNull((Collection)types, (Object)SpringFactoryBeansManagerImpl.createTypeByTypeName(factoryClass, typeName));
            }
        }
        PsiType[] psiTypeArray = types.toArray(PsiType.EMPTY_ARRAY);
        if (psiTypeArray == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(1);
        }
        return psiTypeArray;
    }

    @Nullable
    private static PsiType createTypeByTypeName(@Nullable PsiClass factoryClass, @Nullable String typeName) {
        if (factoryClass == null || StringUtil.isEmptyOrSpaces((String)typeName)) {
            return null;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)factoryClass.getProject()).findClass(typeName, factoryClass.getResolveScope());
        if (psiClass != null) {
            return PsiTypesUtil.getClassType((PsiClass)psiClass);
        }
        try {
            return JavaPsiFacade.getElementFactory((Project)factoryClass.getProject()).createTypeFromText(typeName, (PsiElement)factoryClass);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            return null;
        }
    }

    @Override
    public Set<PsiClass> getKnownBeanFactories(@NotNull Project project) {
        if (project == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(2);
        }
        HashSet factories = ContainerUtil.newHashSet();
        ContainerUtil.addAllNotNull((Collection)factories, this.getFactoryBeansFromLibs(project));
        ContainerUtil.addAllNotNull((Collection)factories, this.getUserDefinedFactoryBeans(project));
        return Collections.unmodifiableSet(factories);
    }

    @NotNull
    public Set<PsiClass> getFactoryBeansFromLibs(@NotNull Project project) {
        if (project == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(3);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                SpringFactoryBeansManagerImpl.$$$reportNull$$$0(32);
            }
            return CachedValueProvider.Result.create(this.getFactoryBeanInheritors(project, ProjectScope.getLibrariesScope((Project)project)), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
        if (set == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<PsiClass> getFactoryBeanInheritors(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(6);
        }
        PsiClass beanFactoryClass = JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.beans.factory.FactoryBean", ProjectScope.getLibrariesScope((Project)project));
        HashSet factories = ContainerUtil.newHashSet();
        if (beanFactoryClass != null) {
            factories.addAll(ClassInheritorsSearch.search((PsiClass)beanFactoryClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).findAll());
        }
        HashSet hashSet = factories;
        if (hashSet == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    public Set<PsiClass> getUserDefinedFactoryBeans(@NotNull Project project) {
        if (project == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(8);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                SpringFactoryBeansManagerImpl.$$$reportNull$$$0(31);
            }
            Set<PsiClass> factories = this.getFactoryBeanInheritors(project, ProjectScope.getContentScope((Project)project));
            return CachedValueProvider.Result.create(factories, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)project)});
        });
        if (set == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(9);
        }
        return set;
    }

    @Override
    public boolean isKnownBeanFactory(@Nullable String factoryClass) {
        return this.mySpringFactories.containsKey(factoryClass);
    }

    @NotNull
    private Set<String> getObjectTypeNames(@NotNull PsiClass factoryClass, @Nullable CommonSpringBean context) {
        ObjectTypeResolver objectTypeResolver;
        if (factoryClass == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(10);
        }
        Set<String> set = (objectTypeResolver = this.getObjectTypeResolver(factoryClass)) != null ? objectTypeResolver.getObjectType(context) : Collections.emptySet();
        if (set == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(11);
        }
        return set;
    }

    @Nullable
    private ObjectTypeResolver getObjectTypeResolver(@NotNull PsiClass factoryClass) {
        if (factoryClass == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(12);
        }
        return (ObjectTypeResolver)CachedValuesManager.getCachedValue((PsiElement)factoryClass, () -> {
            if (factoryClass == null) {
                SpringFactoryBeansManagerImpl.$$$reportNull$$$0(30);
            }
            return new CachedValueProvider.Result((Object)this.doGetObjectTypeResolver(factoryClass), new Object[]{factoryClass});
        });
    }

    @Nullable
    private ObjectTypeResolver doGetObjectTypeResolver(@NotNull PsiClass factoryClass) {
        String qualifiedName;
        ObjectTypeResolver typeResolver;
        if (factoryClass == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(13);
        }
        if ((typeResolver = this.mySpringFactories.get(qualifiedName = factoryClass.getQualifiedName())) != null) {
            return typeResolver;
        }
        GlobalSearchScope resolveScope = factoryClass.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)factoryClass.getProject());
        for (String factoryClassName : this.mySpringFactories.keySet()) {
            ObjectTypeResolver resolver;
            PsiClass psiClass = facade.findClass(factoryClassName, resolveScope);
            if (psiClass == null || !factoryClass.isInheritor(psiClass, false) || (resolver = this.mySpringFactories.get(factoryClassName)) == null) continue;
            return resolver;
        }
        return null;
    }

    private static Set<PsiType> guessObjectTypes(@Nullable PsiClass factoryClass) {
        if (factoryClass == null) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getManager((Project)factoryClass.getProject()).getCachedValue((UserDataHolder)factoryClass, CACHED_OBJECT_TYPE, () -> {
            Set<PsiType> types = SpringFactoryBeansManagerImpl.doGuessObjectType(factoryClass);
            return new CachedValueProvider.Result(types, SpringFactoryBeansManagerImpl.getDependencies(factoryClass, types));
        }, false);
    }

    private static Object[] getDependencies(@NotNull PsiClass factoryClass, @NotNull Set<PsiType> types) {
        if (factoryClass == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(14);
        }
        if (types == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(15);
        }
        HashSet deps = ContainerUtil.newHashSet();
        deps.add(factoryClass);
        for (PsiType type : types) {
            if (type instanceof PsiClassType) {
                ContainerUtil.addIfNotNull((Collection)deps, (Object)((PsiClassType)type).resolve());
                continue;
            }
            return new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT};
        }
        return ArrayUtil.toObjectArray((Collection)deps);
    }

    @Nullable
    private static PsiMethod getProductTypeMethod(PsiClass factoryClass) {
        for (PsiMethod psiMethod : factoryClass.findMethodsByName("getObjectType", true)) {
            if (psiMethod.getParameterList().getParameters().length != 0) continue;
            return psiMethod;
        }
        return null;
    }

    @NotNull
    private static Set<PsiType> doGuessObjectType(PsiClass factoryClass) {
        PsiType factoryBeanGenericType;
        PsiExpression value;
        PsiStatement[] statements;
        VirtualFile file;
        PsiMethod method = SpringFactoryBeansManagerImpl.getProductTypeMethod(factoryClass);
        if (method == null) {
            Set<PsiType> set = Collections.emptySet();
            if (set == null) {
                SpringFactoryBeansManagerImpl.$$$reportNull$$$0(16);
            }
            return set;
        }
        if (method instanceof PsiCompiledElement && (file = method.getContainingFile().getVirtualFile()) != null) {
            FactoryBeanObjectTypeReader reader = new FactoryBeanObjectTypeReader();
            try {
                new ClassReader(file.contentsToByteArray()).accept((ClassVisitor)reader, 2);
            }
            catch (IOException iOException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            String qName = reader.getResultQName();
            PsiType psiType = SpringFactoryBeansManagerImpl.createTypeByTypeName(factoryClass, qName);
            Set<Object> set = psiType != null ? Collections.singleton(psiType) : Collections.emptySet();
            if (set == null) {
                SpringFactoryBeansManagerImpl.$$$reportNull$$$0(17);
            }
            return set;
        }
        PsiCodeBlock body = method.getBody();
        if (body != null && (statements = body.getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement && (value = ((PsiReturnStatement)statements[0]).getReturnValue()) != null) {
            if (value instanceof PsiClassObjectAccessExpression) {
                Set<PsiType> set = Collections.singleton(((PsiClassObjectAccessExpression)value).getOperand().getType());
                if (set == null) {
                    SpringFactoryBeansManagerImpl.$$$reportNull$$$0(18);
                }
                return set;
            }
            PsiType psiType = value.getType();
            if (psiType instanceof PsiClassType) {
                PsiType classType = PsiTypeUtil.getInstance(factoryClass.getProject()).findType(Class.class);
                if (classType != null && psiType.isAssignableFrom(classType)) {
                    Set<PsiType> set = SpringFactoryBeansManagerImpl.getClassTypes((PsiClassType)psiType);
                    if (set == null) {
                        SpringFactoryBeansManagerImpl.$$$reportNull$$$0(19);
                    }
                    return set;
                }
            } else if (psiType != null && !psiType.equals(PsiType.NULL)) {
                Set<PsiType> set = Collections.singleton(psiType);
                if (set == null) {
                    SpringFactoryBeansManagerImpl.$$$reportNull$$$0(20);
                }
                return set;
            }
        }
        if ((factoryBeanGenericType = PsiUtil.substituteTypeParameter((PsiType)PsiTypesUtil.getClassType((PsiClass)factoryClass), (String)"org.springframework.beans.factory.FactoryBean", (int)0, (boolean)false)) != null) {
            Set<PsiType> set = Collections.singleton(factoryBeanGenericType);
            if (set == null) {
                SpringFactoryBeansManagerImpl.$$$reportNull$$$0(21);
            }
            return set;
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(22);
        }
        return set;
    }

    @NotNull
    private static Set<PsiType> getClassTypes(PsiClassType psiType) {
        PsiType type;
        List<PsiType> types = SpringCommonUtils.resolveGenerics(psiType);
        if (types.size() == 1 && (type = types.get(0)) instanceof PsiClassType) {
            PsiClass aClass = ((PsiClassType)type).resolve();
            if (aClass instanceof PsiTypeParameter) {
                HashSet classNames = ContainerUtil.newHashSet();
                Collections.addAll(classNames, aClass.getExtendsListTypes());
                HashSet hashSet = classNames;
                if (hashSet == null) {
                    SpringFactoryBeansManagerImpl.$$$reportNull$$$0(23);
                }
                return hashSet;
            }
            Set<PsiType> set = Collections.singleton(type);
            if (set == null) {
                SpringFactoryBeansManagerImpl.$$$reportNull$$$0(24);
            }
            return set;
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(25);
        }
        return set;
    }

    public void registerFactory(String className, ObjectTypeResolver resolver) {
        this.mySpringFactories.put(className, resolver);
    }

    public void unregisterFactory(String className) {
        this.mySpringFactories.remove(className);
    }

    @Override
    public boolean isFactoryBeanClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(26);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            if (psiClass == null) {
                SpringFactoryBeansManagerImpl.$$$reportNull$$$0(29);
            }
            boolean isBeanFactory = InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.beans.factory.FactoryBean");
            return CachedValueProvider.Result.createSingleDependency((Object)isBeanFactory, (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
    }

    @Override
    public boolean isValidFactoryMethod(@NotNull PsiMethod psiMethod, boolean isBeansXmlFactoryBean) {
        if (psiMethod == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(27);
        }
        if (psiMethod.isConstructor() || psiMethod.getReturnType() == null) {
            return false;
        }
        boolean isStatic = psiMethod.hasModifierProperty("static");
        return (isBeansXmlFactoryBean && !isStatic || !isBeansXmlFactoryBean && isStatic) && SpringFactoryBeansManagerImpl.hasFactoryReturnType(psiMethod);
    }

    public static boolean hasFactoryReturnType(@NotNull PsiMethod psiMethod) {
        PsiType returnType;
        if (psiMethod == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(28);
        }
        return (returnType = psiMethod.getReturnType()) instanceof PsiPrimitiveType || returnType instanceof PsiClassType || returnType instanceof PsiArrayType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryType";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/SpringFactoryBeansManagerImpl";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/SpringFactoryBeansManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryBeansFromLibs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryBeanInheritors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedFactoryBeans";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectTypeNames";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doGuessObjectType";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getObjectTypes";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKnownBeanFactories";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryBeansFromLibs";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryBeanInheritors";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUserDefinedFactoryBeans";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getObjectTypeNames";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getObjectTypeResolver";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doGetObjectTypeResolver";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isFactoryBeanClass";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isValidFactoryMethod";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasFactoryReturnType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isFactoryBeanClass$4";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getObjectTypeResolver$2";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getUserDefinedFactoryBeans$1";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFactoryBeansFromLibs$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FactoryBeanObjectTypeReader
    extends ClassVisitor {
        private String myResultQName;

        FactoryBeanObjectTypeReader() {
            super(458752);
        }

        public String getResultQName() {
            return this.myResultQName;
        }

        public MethodVisitor visitMethod(int access, @NonNls String name, String desc, String signature, String[] exceptions) {
            if ("getObjectType".equals(name) && (signature == null || signature.startsWith("()"))) {
                return new MethodVisitor(458752){
                    private String qname;
                    private int number;
                    {
                        super(x0);
                        this.number = 0;
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        if ((this.number == 0 || this.number == 7) && opcode == 178 || this.number == 5 && opcode == 179) {
                            ++this.number;
                        }
                    }

                    public void visitJumpInsn(int opcode, Label label) {
                        if (this.number == 1 && opcode == 199 || this.number == 6 && opcode == 167) {
                            ++this.number;
                        }
                    }

                    public void visitLdcInsn(Object cst) {
                        if (this.number == 2 && cst instanceof String) {
                            ++this.number;
                            this.qname = (String)cst;
                        } else if (this.number == 0 && cst instanceof Type) {
                            ++this.number;
                            this.qname = ((Type)cst).getClassName();
                        }
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if (this.number != 3 || opcode != 184 || !"class$".equals(name)) {
                            return;
                        }
                        ++this.number;
                    }

                    public void visitInsn(int opcode) {
                        if (this.number == 4 && opcode == 89) {
                            ++this.number;
                        }
                        if ((this.number == 8 || this.number == 1) && opcode == 176) {
                            if (myResultQName == null) {
                                myResultQName = this.qname;
                            }
                            ++this.number;
                        }
                    }
                };
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

