/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.gutter.NavigationGutterIconBuilderUtil;
import com.intellij.spring.gutter.SpringAnnotatorBase;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.beans.Autowire;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class SpringAutowiredAnnotator
extends SpringAnnotatorBase {
    public String getId() {
        return "SpringAutowiredAnnotator";
    }

    public String getName() {
        return "Autowired";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.ShowAutowiredDependencies;
    }

    @Override
    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        UElement element;
        if (psiElement == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(1);
        }
        if ((element = UastUtils.getUParentForIdentifier((PsiElement)psiElement)) instanceof UMethod) {
            this.annotateMethod((UMethod)element, result);
            return;
        }
        if (element instanceof UField) {
            SpringAutowiredAnnotator.annotateField(result, (UField)element);
            return;
        }
        if (element instanceof UParameter) {
            UElement parent = element.getUastParent();
            if (parent instanceof UMethod) {
                SpringAutowiredAnnotator.processAnnotatedMethod((UMethod)parent, psiElement, result);
            }
            return;
        }
        if (element instanceof UReferenceExpression) {
            element = element.getUastParent();
        }
        if (element instanceof UAnnotation) {
            SpringAutowiredAnnotator.annotateAnnotation(psiElement, result, (UAnnotation)element);
        }
    }

    private static void annotateAnnotation(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, UAnnotation uAnnotation) {
        UElement annotatedElement;
        if (psiElement == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(3);
        }
        if ((annotatedElement = uAnnotation.getUastParent()) instanceof UMethod) {
            UAnnotation annotationFromBean;
            PsiMethod method = ((UMethod)annotatedElement).getJavaPsi();
            if (method.isConstructor() || PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) {
                return;
            }
            ContextJavaBean bean = SpringAutowiredAnnotator.getStereotypeBean(method);
            if (bean != null && Objects.equals(annotationFromBean = (UAnnotation)UastContextKt.toUElement((PsiElement)bean.getPsiAnnotation(), UAnnotation.class), uAnnotation)) {
                SpringAutowiredAnnotator.addStereotypeBeanAutowiredCandidatesBeanGutterIcon(result, method, psiElement);
            }
        }
    }

    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, PsiElement identifier, Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiMethod method;
        if (uMethod == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(4);
        }
        if ((method = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)uMethod, PsiMethod.class)) == null) {
            return;
        }
        final PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        if (SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(psiClass)) {
            SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass);
            if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) {
                if (info.isAutowired()) {
                    SpringAutowiredAnnotator.checkAutowiredMethod(method, result, info, identifier);
                }
            } else if (uMethod.isConstructor() && info.isMappedConstructor(method)) {
                SpringAutowiredAnnotator.addConstructorArgsGutterIcon(result, identifier, new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                    @NotNull
                    protected Collection<? extends SpringBeanPointer> compute() {
                        SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass);
                        Collection<SpringBeanPointer> collection = info.getMappedConstructorDefinitions(method);
                        if (collection == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return collection;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringAutowiredAnnotator$1", "compute"));
                    }
                });
            }
        }
    }

    private static ContextJavaBean getStereotypeBean(@NotNull PsiMethod method) {
        if (method == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(5);
        }
        return (ContextJavaBean)JamService.getJamService((Project)method.getProject()).getJamElement(ContextJavaBean.BEAN_JAM_KEY, (PsiElement)method);
    }

    public static boolean checkAutowiredMethod(PsiMethod method, @Nullable Collection<? super RelatedItemLineMarkerInfo> result, SpringJavaClassInfo info, @NotNull PsiElement identifier) {
        CommonSpringModel model;
        if (identifier == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(6);
        }
        if ((model = SpringAutowireUtil.getProcessingSpringModel(method.getContainingClass())) != null) {
            for (Autowire autowire : info.getAutowires()) {
                if (autowire == Autowire.BY_TYPE) {
                    PsiType type = PropertyUtilBase.getPropertyType((PsiMember)method);
                    if (type == null) continue;
                    return SpringAutowiredAnnotator.processVariable((PsiModifierListOwner)method, result, model, identifier, type);
                }
                if (autowire != Autowire.BY_NAME) continue;
                return SpringAutowiredAnnotator.annotateByNameAutowiredMethod((PsiModifierListOwner)method, result, model, identifier);
            }
        }
        return false;
    }

    private static boolean annotateByNameAutowiredMethod(PsiModifierListOwner owner, @Nullable Collection<? super RelatedItemLineMarkerInfo> result, @NotNull CommonSpringModel model, @NotNull PsiElement identifier) {
        Collection<SpringBeanPointer> collection;
        if (model == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(7);
        }
        if (identifier == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(8);
        }
        if ((collection = SpringAutowiredAnnotator.getByNameAutowiredBean(owner, model)) != null && !collection.isEmpty()) {
            if (result != null) {
                NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(collection, result, identifier, SpringBundle.message("navigate.to.by.name.autowired.dependencies", new Object[0]));
            }
            return true;
        }
        return false;
    }

    private static Collection<SpringBeanPointer> getByNameAutowiredBean(@NotNull PsiModifierListOwner owner, @NotNull CommonSpringModel model) {
        SpringBeanPointer bean;
        if (owner == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(9);
        }
        if (model == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(10);
        }
        String name = null;
        if (owner instanceof PsiMethod) {
            name = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)((PsiMethod)owner));
        } else if (owner instanceof PsiField) {
            name = ((PsiField)owner).getName();
        }
        if (name != null && (bean = SpringModelSearchers.findBean(model, name)) != null) {
            return Collections.singleton(bean.getBasePointer());
        }
        return Collections.emptySet();
    }

    private static void annotateField(Collection<? super RelatedItemLineMarkerInfo> result, UField ufield) {
        CommonSpringModel processor;
        PsiElement identifier = UElementKt.getSourcePsiElement((UElement)ufield.getUastAnchor());
        if (identifier == null) {
            return;
        }
        PsiField field = (PsiField)UElementKt.getAsJavaPsiElement((UElement)ufield, PsiField.class);
        if (field == null) {
            return;
        }
        if (SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)field) && (processor = SpringAutowireUtil.getProcessingSpringModel(field.getContainingClass())) != null) {
            SpringAutowiredAnnotator.processVariable((PsiModifierListOwner)field, result, processor, identifier, field.getType());
        }
    }

    private static void processAnnotatedMethod(UMethod uMethod, PsiElement identifier, Collection<? super RelatedItemLineMarkerInfo> result) {
        block1: {
            CommonSpringModel model;
            block2: {
                PsiMethod method = uMethod.getJavaPsi();
                if (!SpringAutowireUtil.isInjectionPoint(method) || (model = SpringAutowireUtil.getProcessingSpringModel(method.getContainingClass())) == null) break block1;
                if (SpringAutowireUtil.getResourceAnnotation((PsiModifierListOwner)method) == null || !PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) break block2;
                UParameter uParameter = (UParameter)uMethod.getUastParameters().get(0);
                if (identifier != UElementKt.getSourcePsiElement((UElement)uParameter.getUastAnchor())) break block1;
                SpringAutowiredAnnotator.processVariable((PsiModifierListOwner)method, result, model, identifier, uParameter.getType());
                break block1;
            }
            for (UParameter parameter : uMethod.getUastParameters()) {
                if (identifier != UElementKt.getSourcePsiElement((UElement)parameter.getUastAnchor())) continue;
                PsiParameter psiParameter = (PsiParameter)UElementKt.getAsJavaPsiElement((UElement)parameter, PsiParameter.class);
                SpringAutowiredAnnotator.processVariable((PsiModifierListOwner)psiParameter, result, model, identifier, parameter.getType());
                break;
            }
        }
    }

    private static boolean processVariable(PsiModifierListOwner variable, @Nullable Collection<? super RelatedItemLineMarkerInfo> result, @NotNull CommonSpringModel model, @NotNull PsiElement identifier, @NotNull PsiType type) {
        Set<SpringBeanPointer> list;
        if (model == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(11);
        }
        if (identifier == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(12);
        }
        if (type == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(13);
        }
        if (!(list = SpringAutowireUtil.getAutowiredBeansFor(variable, SpringAutowiredAnnotator.getAutowiredType(type), model)).isEmpty()) {
            if (result != null) {
                NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(list, result, identifier);
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static PsiType getAutowiredType(@NotNull PsiType type) {
        PsiType optionalType;
        if (type == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(14);
        }
        if (SpringAutowireUtil.isJavaUtilOptional(type) && (optionalType = SpringAutowiredAnnotator.getOptionalType(type)) != null) {
            PsiType psiType = optionalType;
            if (psiType == null) {
                SpringAutowiredAnnotator.$$$reportNull$$$0(15);
            }
            return psiType;
        }
        PsiType psiType = type;
        if (psiType == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(16);
        }
        return psiType;
    }

    @Nullable
    private static PsiType getOptionalType(@NotNull PsiType type) {
        if (type == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(17);
        }
        return PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Optional", (int)0, (boolean)false);
    }

    private static void addStereotypeBeanAutowiredCandidatesBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, final @NotNull PsiMethod method, @NotNull PsiElement identifier) {
        if (method == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(18);
        }
        if (identifier == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(19);
        }
        SpringGutterIconBuilder<PsiElement> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.ShowAutowiredCandidates);
        builder.setPopupTitle(SpringBundle.message("gutter.choose.autowired.candidates.title", new Object[0])).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.autowired.candidates", new Object[0])).setTooltipText(SpringBundle.message("gutter.navigate.to.autowired.candidates.title", new Object[0])).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends PsiElement>>(){

            @NotNull
            protected Collection<? extends PsiElement> compute() {
                if (!method.isValid()) {
                    Set set = Collections.emptySet();
                    if (set == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return set;
                }
                PsiType type = method.getReturnType();
                if (type == null) {
                    Set set = Collections.emptySet();
                    if (set == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return set;
                }
                Module moduleForPsiElement = ModuleUtilCore.findModuleForPsiElement((PsiElement)method);
                if (moduleForPsiElement != null) {
                    Set<PsiModifierListOwner> set = SpringAutowireUtil.getAutowiredMembers(type, moduleForPsiElement, method);
                    if (set == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return set;
                }
                LinkedHashSet<PsiModifierListOwner> members = new LinkedHashSet<PsiModifierListOwner>();
                for (Module module : SpringAutowiredAnnotator.getRelatedSpringModules((PsiElement)method)) {
                    members.addAll(SpringAutowireUtil.getAutowiredMembers(type, module, method));
                }
                LinkedHashSet<PsiModifierListOwner> linkedHashSet = members;
                if (linkedHashSet == null) {
                    2.$$$reportNull$$$0(3);
                }
                return linkedHashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringAutowiredAnnotator$2", "compute"));
            }
        });
        result.add(builder.createSpringRelatedMergeableLineMarkerInfo(identifier));
    }

    private static void addConstructorArgsGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends SpringBeanPointer>> targets) {
        SpringGutterIconBuilder<SpringBeanPointer> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.SpringBeanMethod, NavigationGutterIconBuilderUtil.BEAN_POINTER_CONVERTOR, NavigationGutterIconBuilderUtil.BEAN_POINTER_GOTO_PROVIDER);
        builder.setTargets(targets).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setPopupTitle(SpringBundle.message("spring.bean.constructor.navigate.choose.class.title", new Object[0])).setTooltipText(SpringBundle.message("spring.bean.constructor.tooltip.navigate.declaration", new Object[0]));
        result.add(builder.createSpringRelatedMergeableLineMarkerInfo(psiIdentifier));
    }

    private static Set<Module> getRelatedSpringModules(@NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(20);
        }
        if ((psiFile = element.getContainingFile()) == null) {
            return Collections.emptySet();
        }
        VirtualFile virtualFile = psiFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return Collections.emptySet();
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        if (!fileIndex.isLibraryClassFile(virtualFile) && !fileIndex.isInLibrarySource(virtualFile)) {
            return Collections.emptySet();
        }
        boolean allowAutoConfig = SpringAutoConfiguredModels.isAllowAutoConfiguration(element.getProject());
        return fileIndex.getOrderEntriesForFile(virtualFile).stream().map(OrderEntry::getOwnerModule).filter(module -> SpringCommonUtils.hasSpringFacet(module) || allowAutoConfig && SpringModelUtils.getInstance().hasAutoConfiguredModels((Module)module)).collect(Collectors.toSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/gutter/SpringAutowiredAnnotator";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/gutter/SpringAutowiredAnnotator";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutowiredType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotateAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "annotateMethod";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypeBean";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkAutowiredMethod";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "annotateByNameAutowiredMethod";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getByNameAutowiredBean";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processVariable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredType";
                break;
            }
            case 15: 
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOptionalType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addStereotypeBeanAutowiredCandidatesBeanGutterIcon";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedSpringModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

