/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.annotator;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.cacheable.jam.SpringCachingGroupsForClass;
import com.intellij.spring.model.cacheable.jam.SpringCachingGroupsForMethod;
import com.intellij.spring.model.cacheable.jam.SpringJamCacheableElement;
import com.intellij.spring.model.cacheable.jam.SpringJamCustomCacheableElement;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCacheConfig;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheConfig;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheEvict;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCachePut;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheable;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCachingGroup;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class SpringCacheableAnnotator
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<SpringJamCacheableElement, Collection<? extends PsiElement>> CACHEABLE_CONVERTOR = cacheableElement -> ContainerUtil.createMaybeSingletonList((Object)cacheableElement.getAnnotation());
    private static final DefaultPsiElementCellRenderer CACHEABLE_CELL_RENDERER = new DefaultPsiElementCellRenderer(){

        public String getElementText(PsiElement element) {
            PsiMember psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
            return super.getElementText((PsiElement)(psiMember == null ? element : psiMember));
        }

        protected Icon getIcon(PsiElement element) {
            PsiMember psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
            return super.getIcon((PsiElement)(psiMember == null ? element : psiMember));
        }

        public String getContainerText(PsiElement element, String name) {
            PsiMember psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
            return super.getContainerText((PsiElement)(psiMember == null ? element : psiMember), name);
        }
    };

    public String getId() {
        return "SpringCacheableAnnotator";
    }

    public String getName() {
        return "Cacheable operations with the same names";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.ShowCacheable;
    }

    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringCommonUtils.hasSpringFacets(psiElement.getProject()) || !SpringLibraryUtil.hasSpringLibrary(psiElement.getProject())) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (!SpringLibraryUtil.isAtLeastVersion(module, SpringLibraryUtil.SpringVersion.V_4_2)) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiElement sourcePsi;
        UDeclaration elementToProcess;
        if (psiElement == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(3);
        }
        if (!((elementToProcess = UAnnotationUtils.getIdentifierAnnotationOwner((PsiElement)psiElement)) instanceof UMethod) && !(elementToProcess instanceof UClass)) {
            return;
        }
        JamService service = JamService.getJamService((Project)psiElement.getProject());
        if (elementToProcess instanceof UMethod) {
            PsiMethod psiMethod = (PsiMethod)elementToProcess.getJavaPsi();
            if (psiMethod == null) {
                return;
            }
            if (!psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static") || psiMethod.isConstructor()) {
                return;
            }
            SpringCacheableAnnotator.annotateCachingGroup(psiElement, (SpringJamCachingGroup)service.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringCachingGroupsForMethod.META}), result);
        }
        if (elementToProcess instanceof UClass) {
            PsiClass psiClass = (PsiClass)elementToProcess.getJavaPsi();
            if (psiClass == null) {
                return;
            }
            SpringCacheableAnnotator.annotateCachingGroup(psiElement, (SpringJamCachingGroup)service.getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringCachingGroupsForClass.META}), result);
        }
        if ((sourcePsi = elementToProcess.getSourcePsi()) == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
        if (module == null) {
            return;
        }
        List cacheableElements = SemService.getSemService((Project)psiElement.getProject()).getSemElements(SpringJamCacheableElement.CACHEABLE_ROOT_JAM_KEY, elementToProcess.getJavaPsi());
        if (cacheableElements.isEmpty() || SpringCacheableAnnotator.hasCustomCacheResolver(module)) {
            return;
        }
        for (SpringJamCacheableElement cacheableElement : cacheableElements) {
            SpringCacheableAnnotator.doAnnotateCacheable(psiElement, result, cacheableElement);
        }
    }

    private static void annotateCachingGroup(PsiElement identifierToReport, @Nullable SpringJamCachingGroup<? extends PsiMember> cachingGroups, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (cachingGroups != null) {
            for (SpringJamCacheable cacheable : cachingGroups.getCacheables()) {
                SpringCacheableAnnotator.doAnnotateCacheable(identifierToReport, result, cacheable);
            }
            for (SpringJamCachePut put : cachingGroups.getCachePuts()) {
                SpringCacheableAnnotator.doAnnotateCacheable(identifierToReport, result, put);
            }
            for (SpringJamCacheEvict evict : cachingGroups.getCacheEvict()) {
                SpringCacheableAnnotator.doAnnotateCacheable(identifierToReport, result, evict);
            }
        }
    }

    private static void doAnnotateCacheable(@NotNull PsiElement elementToAnnotate, Collection<? super RelatedItemLineMarkerInfo> result, SpringJamCacheableElement cacheableElement) {
        Set<SpringJamCacheableElement> cacheableElements;
        PsiElement psiAnnotationIdentifier;
        if (elementToAnnotate == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(4);
        }
        if ((psiAnnotationIdentifier = UAnnotationUtils.getNameElement((UElement)UastContextKt.toUElement((PsiElement)cacheableElement.getAnnotation()))) == elementToAnnotate && !(cacheableElements = SpringCacheableAnnotator.findCacheableWithTheSameName(cacheableElement)).isEmpty()) {
            SpringGutterIconBuilder<SpringJamCacheableElement> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.ShowCacheable, CACHEABLE_CONVERTOR, null);
            builder.setTargets(cacheableElements).setCellRenderer((PsiElementListCellRenderer)CACHEABLE_CELL_RENDERER).setPopupTitle(SpringBundle.message("spring.cacheable.element.choose.title", new Object[0])).setTooltipText(SpringBundle.message("spring.cacheable.element.tooltip.text", new Object[0]));
            result.add(builder.createSpringRelatedMergeableLineMarkerInfo(psiAnnotationIdentifier));
        }
    }

    private static boolean hasCustomCacheResolver(@NotNull Module module) {
        PsiClass cacheResolver;
        if (module == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(5);
        }
        if ((cacheResolver = SpringCommonUtils.findLibraryClass(module, "org.springframework.cache.interceptor.CacheResolver")) == null) {
            return true;
        }
        SpringModel combinedModel = SpringManager.getInstance(module.getProject()).getCombinedModel(module);
        return SpringModelSearchers.doesBeanExist((CommonSpringModel)combinedModel, cacheResolver);
    }

    public static Set<SpringJamCacheableElement> findCacheableWithTheSameName(@NotNull SpringJamCacheableElement<?> cacheableElement) {
        if (cacheableElement == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(6);
        }
        PsiAnnotation psiElement = cacheableElement.getAnnotation();
        HashSet cacheableElements = ContainerUtil.newHashSet();
        Set<String> cacheNames = cacheableElement.getCacheNames();
        if (cacheNames.isEmpty()) {
            cacheNames = SpringCacheableAnnotator.getDefaultCacheNames((PsiElement)psiElement);
        }
        if (!cacheNames.isEmpty()) {
            Set<SpringJamCacheableElement> allCacheable = SpringCacheableAnnotator.findAllCacheable((PsiElement)psiElement);
            for (SpringJamCacheableElement element : allCacheable) {
                if (element.equals(cacheableElement)) continue;
                Set<String> names = element.getCacheNames();
                if (names.isEmpty()) {
                    names = SpringCacheableAnnotator.getDefaultCacheNames((PsiElement)element.getAnnotation());
                }
                if (!SpringCacheableAnnotator.hasSameNames(names, cacheNames)) continue;
                cacheableElements.add(element);
            }
        }
        return cacheableElements;
    }

    @NotNull
    private static Set<String> getDefaultCacheNames(@Nullable PsiElement psiElement) {
        if (psiElement == null || !psiElement.isValid()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringCacheableAnnotator.$$$reportNull$$$0(7);
            }
            return set;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
        if (aClass != null) {
            SemService service = SemService.getSemService((Project)aClass.getProject());
            SpringJamCacheConfig cacheConfig = (SpringJamCacheConfig)service.getSemElement(SpringJamCacheConfig.CACHE_CONFIG_JAM_KEY, (PsiElement)aClass);
            if (cacheConfig != null) {
                Set<String> set = cacheConfig.getCacheNames();
                if (set == null) {
                    SpringCacheableAnnotator.$$$reportNull$$$0(8);
                }
                return set;
            }
            SpringJamCustomCacheConfig customCacheConfig = (SpringJamCustomCacheConfig)service.getSemElement(SpringJamCustomCacheConfig.JAM_KEY, (PsiElement)aClass);
            if (customCacheConfig != null) {
                Set<String> set = customCacheConfig.getCacheNames();
                if (set == null) {
                    SpringCacheableAnnotator.$$$reportNull$$$0(9);
                }
                return set;
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(10);
        }
        return set;
    }

    private static boolean hasSameNames(Set<String> names1, Set<String> names2) {
        for (String name1 : names1) {
            for (String name2 : names2) {
                if (!name1.equals(name2)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static Set<SpringJamCacheableElement> findAllCacheable(PsiElement psiElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            Set<SpringJamCacheableElement> set = Collections.emptySet();
            if (set == null) {
                SpringCacheableAnnotator.$$$reportNull$$$0(11);
            }
            return set;
        }
        JamService service = JamService.getJamService((Project)module.getProject());
        GlobalSearchScope scope = psiElement.getResolveScope();
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        result.addAll(service.getJamMethodElements(SpringJamCacheable.CACHEABLE_JAM_KEY, "org.springframework.cache.annotation.Cacheable", scope));
        result.addAll(service.getJamMethodElements(SpringJamCachePut.CACHE_PUT_JAM_KEY, "org.springframework.cache.annotation.CachePut", scope));
        result.addAll(service.getJamMethodElements(SpringJamCacheEvict.CACHE_EVICT_JAM_KEY, "org.springframework.cache.annotation.CacheEvict", scope));
        result.addAll(service.getJamClassElements(SpringJamCacheable.CACHEABLE_JAM_KEY, "org.springframework.cache.annotation.Cacheable", scope));
        result.addAll(service.getJamClassElements(SpringJamCachePut.CACHE_PUT_JAM_KEY, "org.springframework.cache.annotation.CachePut", scope));
        result.addAll(service.getJamClassElements(SpringJamCacheEvict.CACHE_EVICT_JAM_KEY, "org.springframework.cache.annotation.CacheEvict", scope));
        result.addAll(service.getJamClassElements(SpringJamCacheConfig.CACHE_CONFIG_JAM_KEY, "org.springframework.cache.annotation.CacheConfig", scope));
        result.addAll(SpringCacheableAnnotator.getCustomCacheableElements(scope, module, "org.springframework.cache.annotation.Cacheable"));
        result.addAll(SpringCacheableAnnotator.getCustomCacheableElements(scope, module, "org.springframework.cache.annotation.CachePut"));
        result.addAll(SpringCacheableAnnotator.getCustomCacheableElements(scope, module, "org.springframework.cache.annotation.CacheEvict"));
        for (SpringJamCachingGroup cachingGroups : service.getJamClassElements(SpringCachingGroupsForClass.META, "org.springframework.cache.annotation.Caching", scope)) {
            SpringCacheableAnnotator.addFromCachingGroups(result, cachingGroups);
        }
        for (SpringJamCachingGroup cachingGroups : service.getJamMethodElements(SpringCachingGroupsForMethod.META, "org.springframework.cache.annotation.Caching", scope)) {
            SpringCacheableAnnotator.addFromCachingGroups(result, cachingGroups);
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    private static void addFromCachingGroups(Set<SpringJamCacheableElement> result, SpringJamCachingGroup<? extends PsiMember> cachingGroups) {
        result.addAll(cachingGroups.getCacheables());
        result.addAll(cachingGroups.getCacheEvict());
        result.addAll(cachingGroups.getCachePuts());
    }

    private static List<SpringJamCustomCacheableElement> getCustomCacheableElements(@NotNull GlobalSearchScope scope, Module module, @NotNull String definingAnno) {
        if (scope == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(13);
        }
        if (definingAnno == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(14);
        }
        SmartList customCacheables = new SmartList();
        List customAnnotations = ContainerUtil.mapNotNull(JamAnnotationTypeUtil.getInstance(module).getAnnotationTypesWithChildren(definingAnno), PsiClass::getQualifiedName);
        JamService service = JamService.getJamService((Project)scope.getProject());
        for (String customAnno : customAnnotations) {
            customCacheables.addAll(service.getJamMethodElements(SpringJamCustomCacheableElement.CUSTOM_ROOT_JAM_KEY, customAnno, scope));
            customCacheables.addAll(service.getJamClassElements(SpringJamCustomCacheableElement.CUSTOM_ROOT_JAM_KEY, customAnno, scope));
        }
        return customCacheables;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToAnnotate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheableElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definingAnno";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCacheNames";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllCacheable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doAnnotateCacheable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasCustomCacheResolver";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findCacheableWithTheSameName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCustomCacheableElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

