/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixManager;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanResolveConverter
extends ResolvingConverter<SpringBeanPointer>
implements CustomReferenceConverter {
    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        return ReflectionUtil.isAssignable(SpringBeanPointer.class, elementClass);
    }

    @Nullable
    protected CommonSpringModel getSpringModel(ConvertContext context) {
        return SpringManager.getInstance(context.getFile().getProject()).getSpringModelByFile((PsiFile)context.getFile());
    }

    @NotNull
    public List<PsiClassType> getRequiredClasses(ConvertContext context) {
        List<PsiClassType> list = SpringConverterUtil.getRequiredBeanTypeClasses(context);
        if (list == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public SpringBeanPointer fromString(@Nullable String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        CommonSpringModel springModel = this.getSpringModel(context);
        if (springModel == null) {
            return null;
        }
        return SpringBeanUtils.getInstance().findBean(springModel, s);
    }

    public String toString(@Nullable SpringBeanPointer springBeanPointer, ConvertContext context) {
        return springBeanPointer == null ? null : springBeanPointer.getName();
    }

    public LookupElement createLookupElement(SpringBeanPointer springBeanPointer) {
        return SpringConverterUtil.createCompletionVariant(springBeanPointer);
    }

    public PsiElement getPsiElement(@Nullable SpringBeanPointer resolvedValue) {
        if (resolvedValue == null || !resolvedValue.isValid()) {
            return null;
        }
        return resolvedValue.getPsiElement();
    }

    public String getErrorMessage(String s, ConvertContext context) {
        return SpringApiBundle.message("model.bean.error.message", s);
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue value, PsiElement element, ConvertContext context) {
        if (SpringBeanResolveConverter.isPlaceholder(context)) {
            PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.append((Object[])PlaceholderUtils.getInstance().createPlaceholderPropertiesReferences(value), (Object)new GenericDomValueReference(value));
            if (psiReferenceArray == null) {
                SpringBeanResolveConverter.$$$reportNull$$$0(1);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(2);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        GenericDomValue element = (GenericDomValue)context.getInvocationElement();
        return SpringBeanResolveQuickFixManager.getInstance().getQuickFixes(context, (Beans)element.getParentOfType(Beans.class, false), null, this.getRequiredClasses(context));
    }

    @NotNull
    public Collection<SpringBeanPointer> getVariants(ConvertContext context) {
        if (SpringBeanResolveConverter.isPlaceholder(context)) {
            Set<SpringBeanPointer> set = Collections.emptySet();
            if (set == null) {
                SpringBeanResolveConverter.$$$reportNull$$$0(3);
            }
            return set;
        }
        Collection<SpringBeanPointer> collection = SpringBeanResolveConverter.getVariants(context, false, false, this.getRequiredClasses(context), this.getSpringModel(context));
        if (collection == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(4);
        }
        return collection;
    }

    protected static boolean isPlaceholder(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        return element instanceof GenericDomValue && PlaceholderUtils.getInstance().isRawTextPlaceholder((GenericDomValue)element);
    }

    protected static Collection<SpringBeanPointer> getVariants(ConvertContext context, boolean parentBeans, boolean allowAbstracts, List<PsiClassType> requiredClasses, CommonSpringModel model) {
        PsiClassType object;
        if (model == null) {
            return Collections.emptyList();
        }
        ArrayList<SpringBeanPointer> variants = new ArrayList<SpringBeanPointer>();
        CommonSpringBean currentBean = SpringConverterUtil.getCurrentBeanCustomAware(context);
        if (!requiredClasses.isEmpty() && requiredClasses.contains(object = PsiType.getJavaLangObject((PsiManager)context.getPsiManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)context.getProject())))) {
            requiredClasses = new ArrayList<PsiClassType>(requiredClasses);
            requiredClasses.remove(object);
        }
        Collection<SpringBeanPointer> pointers = SpringBeanResolveConverter.getModelVariants(parentBeans, model, requiredClasses, currentBean);
        SpringConverterUtil.processBeans(model, variants, pointers, allowAbstracts, currentBean);
        return variants;
    }

    private static Collection<SpringBeanPointer> getModelVariants(boolean parentBeans, CommonSpringModel model, @NotNull List<PsiClassType> requiredClasses, CommonSpringBean currentBean) {
        if (requiredClasses == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(5);
        }
        if (parentBeans) {
            if (model instanceof XmlSpringModel) {
                ArrayList<SpringBeanPointer> allBeans = new ArrayList<SpringBeanPointer>();
                for (SpringModel springModel : ((XmlSpringModel)model).getDependencies()) {
                    if (requiredClasses.isEmpty()) {
                        allBeans.addAll(springModel.getAllCommonBeans());
                        continue;
                    }
                    allBeans.addAll(SpringConverterUtil.getSmartVariants(currentBean, requiredClasses, model));
                }
                return allBeans;
            }
            return Collections.emptySet();
        }
        return requiredClasses.isEmpty() ? model.getAllCommonBeans() : SpringConverterUtil.getSmartVariants(currentBean, requiredClasses, model);
    }

    @NotNull
    protected static List<PsiClassType> getValueClasses(ConvertContext context) {
        TypeHolder valueHolder = (TypeHolder)context.getInvocationElement().getParentOfType(TypeHolder.class, false);
        if (valueHolder == null) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                SpringBeanResolveConverter.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = ContainerUtil.findAll(TypeHolderUtil.getRequiredTypes(valueHolder), PsiClassType.class);
        if (list == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/SpringBeanResolveConverter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredClasses";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/SpringBeanResolveConverter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueClasses";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModelVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Parent
    extends SpringBeanResolveConverter {
        @Override
        @NotNull
        public Collection<SpringBeanPointer> getVariants(ConvertContext context) {
            Collection<SpringBeanPointer> collection = Parent.getVariants(context, false, true, this.getRequiredClasses(context), this.getSpringModel(context));
            if (collection == null) {
                Parent.$$$reportNull$$$0(0);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverter$Parent", "getVariants"));
        }
    }

    public static class PropertyBean
    extends SpringBeanResolveConverter {
        @Override
        @NotNull
        public List<PsiClassType> getRequiredClasses(ConvertContext context) {
            List<PsiClassType> list = PropertyBean.getValueClasses(context);
            if (list == null) {
                PropertyBean.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverter$PropertyBean", "getRequiredClasses"));
        }
    }
}

