/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.RequiredBeanType;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringConverterUtil {
    private SpringConverterUtil() {
    }

    @Nullable
    public static SpringModel getSpringModel(ConvertContext context) {
        return SpringConverterUtil.getSpringModel(context.getInvocationElement());
    }

    @Nullable
    public static SpringModel getSpringModel(DomElement element) {
        XmlFile xmlFile = (XmlFile)DomUtil.getFile((DomElement)element).getOriginalFile();
        return SpringManager.getInstance(xmlFile.getProject()).getSpringModelByFile((PsiFile)xmlFile);
    }

    @Nullable
    public static DomSpringBean getCurrentBean(ConvertContext context) {
        return SpringConverterUtil.getCurrentBean(context.getInvocationElement());
    }

    @Nullable
    public static CommonSpringBean getCurrentBeanCustomAware(ConvertContext context) {
        CustomBeanWrapper wrapper;
        List<CustomBean> list;
        DomSpringBean bean = SpringConverterUtil.getCurrentBean(context);
        if (bean instanceof CustomBeanWrapper && !(list = (wrapper = (CustomBeanWrapper)bean).getCustomBeans()).isEmpty()) {
            return list.get(0);
        }
        return bean;
    }

    @Nullable
    public static DomSpringBean getCurrentBean(DomElement element) {
        DomSpringBean springBean;
        DomElement domElement;
        XmlTag originalElement;
        XmlTag tag = element.getXmlTag();
        if (tag != null && (originalElement = (XmlTag)CompletionUtil.getOriginalElement((PsiElement)tag)) != tag && (domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(originalElement)) != null && (springBean = (DomSpringBean)domElement.getParentOfType(DomSpringBean.class, false)) != null) {
            return springBean;
        }
        return (DomSpringBean)element.getParentOfType(DomSpringBean.class, false);
    }

    @NotNull
    public static Collection<PsiPackage> getPsiPackages(PsiReference ... psiReferences) {
        if (psiReferences == null) {
            SpringConverterUtil.$$$reportNull$$$0(0);
        }
        LinkedHashSet<PsiPackage> list = new LinkedHashSet<PsiPackage>();
        for (PsiReference psiReference : psiReferences) {
            if (!(psiReference instanceof PsiPackageReference)) continue;
            list.addAll(((PsiPackageReference)psiReference).getReferenceSet().resolvePackage());
        }
        LinkedHashSet<PsiPackage> linkedHashSet = list;
        if (linkedHashSet == null) {
            SpringConverterUtil.$$$reportNull$$$0(1);
        }
        return linkedHashSet;
    }

    @NotNull
    public static List<PsiClassType> getRequiredBeanTypeClasses(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        RequiredBeanType type = (RequiredBeanType)element.getAnnotation(RequiredBeanType.class);
        if (type == null) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                SpringConverterUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        SmartList types = new SmartList();
        for (String className : type.value()) {
            PsiClass psiClass = DomJavaUtil.findClass((String)className, (DomElement)element);
            if (psiClass == null) continue;
            types.add(PsiTypesUtil.getClassType((PsiClass)psiClass));
        }
        SmartList smartList = types;
        if (smartList == null) {
            SpringConverterUtil.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    public static Collection<SpringBeanPointer> getSmartVariants(CommonSpringBean currentBean, List<? extends PsiClassType> requiredClasses, CommonSpringModel model) {
        SmartList variants = new SmartList();
        for (PsiClassType psiClassType : requiredClasses) {
            PsiClass componentClass;
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiClassType);
            if (SpringConverterUtil.isSearchableClass(psiClass)) {
                SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(psiClass).withInheritors().effectiveBeanTypes();
                SpringConverterUtil.processBeans(model, (List<? super SpringBeanPointer>)variants, SpringModelSearchers.findBeans(model, searchParameters), false, currentBean);
            }
            if (!SpringConverterUtil.isSearchableClass(componentClass = PsiUtil.resolveClassInType((PsiType)PsiUtil.extractIterableTypeParameter((PsiType)psiClassType, (boolean)false)))) continue;
            SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(componentClass).withInheritors().effectiveBeanTypes();
            SpringConverterUtil.processBeans(model, (List<? super SpringBeanPointer>)variants, SpringModelSearchers.findBeans(model, searchParameters), false, currentBean);
        }
        return variants;
    }

    private static boolean isSearchableClass(@Nullable PsiClass psiClass) {
        return psiClass != null && psiClass.getQualifiedName() != null && !(psiClass instanceof PsiAnonymousClass);
    }

    public static void processBeans(@NotNull CommonSpringModel model, @NotNull List<? super SpringBeanPointer> variants, @NotNull Collection<? extends SpringBeanPointer> pointers, boolean acceptAbstract, @Nullable CommonSpringBean currentBean) {
        if (model == null) {
            SpringConverterUtil.$$$reportNull$$$0(4);
        }
        if (variants == null) {
            SpringConverterUtil.$$$reportNull$$$0(5);
        }
        if (pointers == null) {
            SpringConverterUtil.$$$reportNull$$$0(6);
        }
        for (SpringBeanPointer springBeanPointer : pointers) {
            if (!acceptAbstract && springBeanPointer.isAbstract() || springBeanPointer.isReferenceTo(currentBean)) continue;
            for (String string : SpringModelVisitorUtils.getAllBeanNames(model, springBeanPointer)) {
                if (!StringUtil.isNotEmpty((String)string)) continue;
                variants.add(springBeanPointer.derive(string));
            }
        }
    }

    @Nullable
    public static LookupElement createCompletionVariant(@NotNull SpringBeanPointer variant) {
        String name;
        if (variant == null) {
            SpringConverterUtil.$$$reportNull$$$0(7);
        }
        if ((name = variant.getName()) == null) {
            return null;
        }
        return SpringConverterUtil.createCompletionVariant(variant, name);
    }

    @Nullable
    public static LookupElement createCompletionVariant(@NotNull SpringBeanPointer pointer, @NotNull String name) {
        PomTarget target;
        if (pointer == null) {
            SpringConverterUtil.$$$reportNull$$$0(8);
        }
        if (name == null) {
            SpringConverterUtil.$$$reportNull$$$0(9);
        }
        if (!pointer.isValid()) {
            return null;
        }
        PsiElement element = pointer.getPsiElement();
        if (element instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)element).getTarget()) instanceof PsiTarget) {
            element = ((PsiTarget)target).getNavigationElement();
        }
        if (element == null) {
            return null;
        }
        LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)element, (String)name).withIcon(SpringPresentationProvider.getSpringIcon(pointer));
        PsiClass beanClass = pointer.getBeanClass();
        if (beanClass != null) {
            lookupElement = lookupElement.withTypeText(beanClass.getName()).withStrikeoutness(beanClass.isDeprecated());
        }
        return lookupElement.withTailText(" (" + SpringPresentationProvider.getSpringBeanLocation(pointer) + ")", true);
    }

    public static boolean containsPatternReferences(@Nullable String text) {
        return text != null && (StringUtil.containsChar((String)text, (char)'*') || StringUtil.containsChar((String)text, (char)'?'));
    }

    public static Collection<PsiPackage> getPackages(@Nullable String text, @NotNull Project project) {
        if (project == null) {
            SpringConverterUtil.$$$reportNull$$$0(10);
        }
        return SpringConverterUtil.getPackages(text, ",; \n\t", project);
    }

    public static Collection<PsiPackage> getPackages(final @Nullable String text, @NotNull String delimiters, @NotNull Project project) {
        if (delimiters == null) {
            SpringConverterUtil.$$$reportNull$$$0(11);
        }
        if (project == null) {
            SpringConverterUtil.$$$reportNull$$$0(12);
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return Collections.emptySet();
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        SmartList list = new SmartList();
        new DelimitedListProcessor(delimiters, (List)list, psiFacade){
            final /* synthetic */ List val$list;
            final /* synthetic */ JavaPsiFacade val$psiFacade;
            {
                this.val$list = list;
                this.val$psiFacade = javaPsiFacade;
                super(x0);
            }

            protected void processToken(int start, int end, boolean delimitersOnly) {
                String packageName = text.substring(start, end);
                ContainerUtil.addIfNotNull((Collection)this.val$list, (Object)this.val$psiFacade.findPackage(packageName.trim()));
            }
        }.processText(text);
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiReferences";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/SpringConverterUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/SpringConverterUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiPackages";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredBeanTypeClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPsiPackages";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processBeans";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionVariant";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPackages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

