/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.custom;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.custom.CustomModuleComponentsDiscoverer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomComponentsDiscovererHelper {
    @NotNull
    private final Module myModule;
    private final NotNullLazyValue<Set<CachedValue<CommonSpringModel>>> myCachedModels;

    public static CustomComponentsDiscovererHelper getInstance(@NotNull Module module) {
        if (module == null) {
            CustomComponentsDiscovererHelper.$$$reportNull$$$0(0);
        }
        return (CustomComponentsDiscovererHelper)ModuleServiceManager.getService((Module)module, CustomComponentsDiscovererHelper.class);
    }

    public CustomComponentsDiscovererHelper(@NotNull Module module) {
        if (module == null) {
            CustomComponentsDiscovererHelper.$$$reportNull$$$0(1);
        }
        this.myCachedModels = new VolatileNotNullLazyValue<Set<CachedValue<CommonSpringModel>>>(){

            @NotNull
            protected Set<CachedValue<CommonSpringModel>> compute() {
                LinkedHashSet set = ContainerUtil.newLinkedHashSet();
                for (CustomModuleComponentsDiscoverer discoverer : CustomModuleComponentsDiscoverer.EP_NAME.getExtensionList()) {
                    if (!discoverer.accepts(CustomComponentsDiscovererHelper.this.myModule)) continue;
                    set.add(this.createCachedModel(discoverer));
                }
                LinkedHashSet linkedHashSet = set;
                if (linkedHashSet == null) {
                    1.$$$reportNull$$$0(0);
                }
                return linkedHashSet;
            }

            private CachedValue<CommonSpringModel> createCachedModel(final @NotNull CustomModuleComponentsDiscoverer discoverer) {
                if (discoverer == null) {
                    1.$$$reportNull$$$0(1);
                }
                return CachedValuesManager.getManager((Project)CustomComponentsDiscovererHelper.this.myModule.getProject()).createCachedValue(() -> {
                    if (discoverer == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    CustomComponentDiscovererBeansModel model = new CustomComponentDiscovererBeansModel(CustomComponentsDiscovererHelper.this.myModule, (NotNullLazyValue)new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                        @NotNull
                        protected Collection<? extends SpringBeanPointer> compute() {
                            Set<SpringBeanPointer> set = BeanService.getInstance().mapSpringBeans(discoverer.getCustomComponents(CustomComponentsDiscovererHelper.this.myModule));
                            if (set == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return set;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/custom/CustomComponentsDiscovererHelper$1$1", "compute"));
                        }
                    }, discoverer.getProviderName());
                    return CachedValueProvider.Result.create((Object)model, (Object[])discoverer.getDependencies(CustomComponentsDiscovererHelper.this.myModule));
                }, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/model/custom/CustomComponentsDiscovererHelper$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "discoverer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "compute";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/model/custom/CustomComponentsDiscovererHelper$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "createCachedModel";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$createCachedModel$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myModule = module;
    }

    public Collection<CommonSpringModel> getCustomModels() {
        return ContainerUtil.map((Collection)((Collection)this.myCachedModels.getValue()), CachedValue::getValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "module";
        objectArray2[1] = "com/intellij/spring/model/custom/CustomComponentsDiscovererHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CustomComponentDiscovererBeansModel
    extends BeansSpringModel {
        @NotNull
        private final String myProviderName;

        private CustomComponentDiscovererBeansModel(@Nullable Module module, @NotNull NotNullLazyValue<Collection<? extends SpringBeanPointer>> pointers, @NotNull String providerName) {
            if (pointers == null) {
                CustomComponentDiscovererBeansModel.$$$reportNull$$$0(0);
            }
            if (providerName == null) {
                CustomComponentDiscovererBeansModel.$$$reportNull$$$0(1);
            }
            super(module, pointers);
            this.myProviderName = providerName;
        }

        public String toString() {
            return this.myProviderName + ": " + super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pointers";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "providerName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/model/custom/CustomComponentsDiscovererHelper$CustomComponentDiscovererBeansModel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

