/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.autowire;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequestKt;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.DefaultSpringBeanQualifier;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.highlighting.fixes.ShowBeansQuickFix;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.spring.references.SpringUastQualifierReference;
import com.intellij.uast.UastSmartPointer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SortedList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;

public class SpringUastInjectionPointsAutowiringInspection
extends SpringUastInspectionBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.model.highlighting.autowire.SpringUastInjectionPointsAutowiringInspection");

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull UMethod uMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        CommonSpringModel model;
        if (uMethod == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(1);
        }
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass psiClass = psiMethod.getContainingClass();
        PsiElement sourcePsi = uMethod.getSourcePsi();
        if (sourcePsi == null) {
            return null;
        }
        if (SpringAutowireUtil.isAutowiringRelevantClass(psiClass) && SpringAutowireUtil.isInjectionPoint(psiMethod) && (model = SpringAutowireUtil.getProcessingSpringModel(psiClass)) != null) {
            ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
            boolean required = SpringAutowireUtil.isRequired((PsiModifierListOwner)psiMethod);
            if (SpringAutowireUtil.getResourceAnnotation((PsiModifierListOwner)psiMethod) != null) {
                SpringUastInjectionPointsAutowiringInspection.checkResourceMethod(uMethod, holder, model, required);
            } else if (psiMethod.getParameterList().getParametersCount() == 0 && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiMethod)) {
                PsiElement nameIdentifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor());
                if (nameIdentifier != null) {
                    String msg = SpringBundle.message("bean.autowiring.by.type.no.parameter.for.autowired.method", psiMethod.isConstructor() ? "constructor" : "method");
                    holder.registerProblem(nameIdentifier, msg, new LocalQuickFix[0]);
                }
            } else {
                SpringUastInjectionPointsAutowiringInspection.checkAutowiredMethodInjections(uMethod, holder, model, required);
            }
            return holder.getResultsArray();
        }
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkField(@NotNull UField uField, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiField psiField;
        if (uField == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(3);
        }
        if ((psiField = (PsiField)UElementKt.getAsJavaPsiElement((UElement)uField, PsiField.class)) == null) {
            return null;
        }
        if (SpringAutowireUtil.isAutowiringRelevantClass(psiField.getContainingClass()) && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiField)) {
            CommonSpringModel model = SpringAutowireUtil.getProcessingSpringModel(psiField.getContainingClass());
            PsiElement sourcePsi = uField.getSourcePsi();
            if (model != null && sourcePsi != null) {
                ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
                SpringUastInjectionPointsAutowiringInspection.checkInjectionPoint((UDeclaration)uField, psiField.getType(), holder, model, SpringAutowireUtil.isRequired((PsiModifierListOwner)psiField));
                return holder.getResultsArray();
            }
        }
        return null;
    }

    private static void checkAutowiredMethodInjections(UMethod psiMethod, @NotNull ProblemsHolder holder, CommonSpringModel springModel, boolean required) {
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(4);
        }
        for (UParameter parameter : psiMethod.getUastParameters()) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)UElementKt.getAsJavaPsiElement((UElement)parameter, PsiModifierListOwner.class);
            if (modifierListOwner == null || AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, (String)"org.springframework.beans.factory.annotation.Value", (int)1)) continue;
            SpringUastInjectionPointsAutowiringInspection.checkInjectionPoint((UDeclaration)parameter, parameter.getType(), holder, springModel, required);
        }
    }

    private static void checkResourceMethod(@NotNull UMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel springModel, boolean required) {
        PsiType type;
        if (psiMethod == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(6);
        }
        if (springModel == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(7);
        }
        if ((type = PropertyUtilBase.getPropertyType((PsiMember)psiMethod.getJavaPsi())) != null) {
            SpringUastInjectionPointsAutowiringInspection.checkInjectionPoint((UDeclaration)psiMethod, type, holder, springModel, required);
        }
    }

    public static void checkInjectionPoint(@NotNull UDeclaration uDeclaration, @NotNull PsiType psiType, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel springModel, boolean required) {
        if (uDeclaration == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(8);
        }
        if (psiType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(10);
        }
        if (springModel == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(11);
        }
        if (!psiType.isValid()) {
            return;
        }
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)UElementKt.getAsJavaPsiElement((UElement)uDeclaration, PsiModifierListOwner.class);
        if (psiModifierListOwner == null) {
            return;
        }
        PsiAnnotation resourceAnnotation = SpringAutowireUtil.getResourceAnnotation(psiModifierListOwner);
        if (resourceAnnotation != null && psiModifierListOwner instanceof PsiMember) {
            SpringUastInjectionPointsAutowiringInspection.checkResourceInjectionPoint(psiType, holder, springModel, resourceAnnotation);
            return;
        }
        UAnnotation annotation = SpringUastInjectionPointsAutowiringInspection.getEffectiveQualifiedUAnnotation(uDeclaration);
        if (annotation != null) {
            SpringUastInjectionPointsAutowiringInspection.checkQualifiedAutowiring(psiType, annotation, holder, springModel);
            return;
        }
        SpringUastInjectionPointsAutowiringInspection.checkByTypeAutowire(uDeclaration, psiType, holder, springModel, required);
    }

    @Nullable
    private static UAnnotation getEffectiveQualifiedUAnnotation(UDeclaration uDeclaration) {
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)UElementKt.getAsJavaPsiElement((UElement)uDeclaration, PsiModifierListOwner.class);
        if (psiModifierListOwner == null) {
            return null;
        }
        PsiAnnotation annotation = SpringAutowireUtil.getEffectiveQualifiedAnnotation(psiModifierListOwner);
        if (annotation == null) {
            return null;
        }
        UAnnotation qualifiedAnnotation = null;
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName != null) {
            qualifiedAnnotation = uDeclaration.findAnnotation(qualifiedName);
        }
        if (qualifiedAnnotation == null) {
            qualifiedAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)annotation, UAnnotation.class);
        }
        if (qualifiedAnnotation == null) {
            PsiElement sourcePsi = uDeclaration.getSourcePsi();
            LOG.error("Psi annotation '" + annotation + "' from '" + (sourcePsi != null ? sourcePsi.getText() : null) + "' was not converted to UAST");
        }
        return qualifiedAnnotation;
    }

    private static void checkResourceInjectionPoint(@NotNull PsiType psiType, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel springModel, @NotNull PsiAnnotation resourceAnnotation) {
        PsiAnnotationMemberValue attributeValue;
        if (psiType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(12);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(13);
        }
        if (springModel == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(14);
        }
        if (resourceAnnotation == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(15);
        }
        if ((attributeValue = resourceAnnotation.findDeclaredAttributeValue("name")) != null) {
            SpringUastInjectionPointsAutowiringInspection.checkByNameAutowiring(attributeValue, holder, springModel, psiType);
        }
    }

    private static void checkByNameAutowiring(@NotNull PsiAnnotationMemberValue annotationMemberValue, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel model, @NotNull PsiType memberEffectiveType) {
        if (annotationMemberValue == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(16);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(17);
        }
        if (model == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(18);
        }
        if (memberEffectiveType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(19);
        }
        for (PsiReference reference : annotationMemberValue.getReferences()) {
            PsiConstantEvaluationHelper helper;
            Object o;
            PsiElement element;
            if (reference instanceof SpringBeanReference) {
                SpringBeanReference sbReference = (SpringBeanReference)reference;
                SpringUastInjectionPointsAutowiringInspection.checkResourceBeanReference(holder, model, memberEffectiveType, reference, sbReference.getValue(), sbReference.isFactoryBeanRef());
                break;
            }
            if (!(reference instanceof PsiReferenceExpression) || !((element = reference.resolve()) instanceof PsiField) || !((o = (helper = JavaPsiFacade.getInstance((Project)element.getProject()).getConstantEvaluationHelper()).computeConstantExpression((PsiElement)((PsiField)element).getInitializer())) instanceof String)) continue;
            SpringUastInjectionPointsAutowiringInspection.checkResourceBeanReference(holder, model, memberEffectiveType, reference, (String)o, false);
        }
    }

    private static void checkResourceBeanReference(@NotNull ProblemsHolder holder, @NotNull CommonSpringModel model, @NotNull PsiType memberEffectiveType, @NotNull PsiReference ref, @Nullable String beanName, boolean isFactoryBeanRef) {
        SpringBeanPointer bean;
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(20);
        }
        if (model == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(21);
        }
        if (memberEffectiveType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(22);
        }
        if (ref == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(23);
        }
        if (beanName != null && (bean = SpringModelSearchers.findBean(model, beanName)) != null) {
            PsiType[] beanTypes;
            for (PsiType psiType : beanTypes = SpringUastInjectionPointsAutowiringInspection.getEffectiveBeanTypes(isFactoryBeanRef, bean)) {
                if (!SpringAutowireUtil.canBeAutowiredByType(memberEffectiveType, psiType)) continue;
                return;
            }
            holder.registerProblem(ref, SpringBundle.message("cannot.autowire.bean.of.type", memberEffectiveType.getCanonicalText()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            return;
        }
        if (ref instanceof SpringBeanReference) {
            holder.registerProblem(ref);
        } else if (beanName != null) {
            holder.registerProblem(ref.getElement(), SpringApiBundle.message("model.bean.error.message", beanName), new LocalQuickFix[0]);
        }
    }

    private static PsiType[] getEffectiveBeanTypes(boolean factoryBeanRef, SpringBeanPointer bean) {
        PsiClass beanClass;
        if (factoryBeanRef && (beanClass = bean.getBeanClass()) != null) {
            return new PsiType[]{PsiTypesUtil.getClassType((PsiClass)beanClass)};
        }
        return bean.getEffectiveBeanTypes();
    }

    private static void checkQualifiedAutowiring(PsiType searchType, UAnnotation qualifiedAnnotation, @Nullable ProblemsHolder holder, @NotNull CommonSpringModel model) {
        PsiLanguageInjectionHost host;
        if (model == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(24);
        }
        UExpression attributeValue = qualifiedAnnotation.findDeclaredAttributeValue("value");
        PsiAnnotation psiAnnotation = (PsiAnnotation)UElementKt.getAsJavaPsiElement((UElement)qualifiedAnnotation, PsiAnnotation.class);
        if (psiAnnotation == null) {
            return;
        }
        String name = SpringAutowireUtil.getQualifiedBeanName(psiAnnotation);
        SpringUastQualifierReference qreference = null;
        if (attributeValue instanceof ULiteralExpression && (host = UastLiteralUtils.getPsiLanguageInjectionHost((ULiteralExpression)((ULiteralExpression)attributeValue))) != null) {
            PsiReference[] references;
            for (PsiReference reference : references = host.getReferences()) {
                if (!(reference instanceof SpringUastQualifierReference) || (qreference = (SpringUastQualifierReference)reference).multiResolve(false).length != 0) continue;
                if (holder != null && ((PsiLanguageInjectionHost)qreference.getElement()).isPhysical()) {
                    holder.registerProblem((PsiReference)qreference, SpringBundle.message("bean.class.unknown.qualifier.bean", name), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                }
                return;
            }
        }
        Set<SpringBeanPointer> beanPointers = SpringAutowireUtil.getQualifiedBeanPointers(psiAnnotation, model);
        PsiElement attributeValueSourcePsi = UElementKt.getSourcePsiElement((UElement)attributeValue);
        PsiElement annotationSourcePsi = UElementKt.getSourcePsiElement((UElement)qualifiedAnnotation);
        if (beanPointers.size() == 0) {
            if (holder != null) {
                if (attributeValueSourcePsi != null) {
                    SpringUastInjectionPointsAutowiringInspection.reportProblem(holder, (PsiReference)qreference, attributeValueSourcePsi, SpringBundle.message("bean.class.unknown.qualifier.bean", name));
                } else {
                    String qualifiedName = qualifiedAnnotation.getQualifiedName();
                    assert (qualifiedName != null);
                    if (annotationSourcePsi != null) {
                        SpringUastInjectionPointsAutowiringInspection.reportProblem(holder, (PsiReference)qreference, annotationSourcePsi, SpringBundle.message("cannot.find.bean.qualified.by", "@" + StringUtil.getShortName((String)qualifiedName)));
                    }
                }
            }
            return;
        }
        Set<SpringBeanPointer> autowiredPointers = SpringAutowireUtil.filterPointersByAutowiredType(searchType, beanPointers);
        if (autowiredPointers.isEmpty() && SpringAutowireUtil.getIterableBeanPointers(searchType, model, null).size() == 0 && holder != null) {
            PsiElement elementToReport;
            String message = SpringBundle.message("bean.class.autowired.incorrect.qualifier.type", searchType.getPresentableText());
            PsiElement psiElement = elementToReport = attributeValueSourcePsi == null ? annotationSourcePsi : attributeValueSourcePsi;
            if (elementToReport != null) {
                SpringUastInjectionPointsAutowiringInspection.reportProblem(holder, (PsiReference)qreference, elementToReport, message);
            }
        }
    }

    private static void reportProblem(@NotNull ProblemsHolder holder, @Nullable PsiReference qreference, @NotNull PsiElement attributeValue, String text) {
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(25);
        }
        if (attributeValue == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(26);
        }
        if (qreference == null) {
            holder.registerProblem(attributeValue, text, new LocalQuickFix[0]);
        } else {
            holder.registerProblem(qreference, text, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    private static void checkByTypeAutowire(UDeclaration psiNameIdentifierOwner, @NotNull PsiType searchType, @Nullable ProblemsHolder holder, @NotNull CommonSpringModel model, boolean required) {
        UIdentifier uIdentifier;
        if (searchType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(27);
        }
        if (model == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(28);
        }
        if ((uIdentifier = (UIdentifier)psiNameIdentifierOwner.getUastAnchor()) == null) {
            return;
        }
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uIdentifier);
        if (psiElement == null) {
            return;
        }
        if (psiElement.getTextRange().isEmpty()) {
            return;
        }
        String primaryCandidateName = uIdentifier.getName();
        Set<SpringBeanPointer> beanPointers = SpringAutowireUtil.autowireByType(model, searchType, primaryCandidateName);
        Set<SpringBeanPointer> iterableBeanPointers = SpringAutowireUtil.getIterableBeanPointers(searchType, model, primaryCandidateName);
        if (beanPointers.isEmpty() && iterableBeanPointers.isEmpty() && required) {
            if (!(holder == null || SpringAutowireUtil.isAutowiredByDefault(searchType) || SpringUastInjectionPointsAutowiringInspection.isObjectFactory(searchType) || SpringUastInjectionPointsAutowiringInspection.isInjectionPoint(searchType) || SpringAutowireUtil.isJavaUtilOptional(searchType))) {
                holder.registerProblem(psiElement, SpringUastInjectionPointsAutowiringInspection.getBeansNotFoundMessage(searchType), new LocalQuickFix[0]);
            }
        } else if (iterableBeanPointers.isEmpty() && beanPointers.size() > 1 && holder != null) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)psiNameIdentifierOwner.getJavaPsi();
            if (modifierListOwner == null) {
                return;
            }
            Set<SpringBeanPointer> filtered = SpringUastInjectionPointsAutowiringInspection.filterOverridenBeans(beanPointers);
            if ((filtered = SpringUastInjectionPointsAutowiringInspection.filterSelfReferencedBeans((PsiElement)modifierListOwner, filtered)).size() > 1) {
                if (SpringUastInjectionPointsAutowiringInspection.isNonDefinedActiveProfile(model.getActiveProfiles()) && SpringUastInjectionPointsAutowiringInspection.isAllBeansInDifferentProfiles(filtered)) {
                    return;
                }
                SmartList fixes = new SmartList();
                String annotation = SpringUastInjectionPointsAutowiringInspection.getQualifierAnnotation(modifierListOwner);
                CreateQualifierRequest annotationRequest = new CreateQualifierRequest(modifierListOwner, annotation, SpringUastInjectionPointsAutowiringInspection.getBeanPointerName(beanPointers.iterator().next()));
                List actions = JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)modifierListOwner, (AnnotationRequest)annotationRequest);
                if (!actions.isEmpty()) {
                    fixes.add((Object)new AddSpringBeanQualifierFix(psiNameIdentifierOwner, beanPointers, annotation, (IntentionAction)actions.get(0)));
                }
                fixes.add((Object)new ShowBeansQuickFix(beanPointers));
                holder.registerProblem(psiElement, SpringUastInjectionPointsAutowiringInspection.getErrorMessage(searchType, filtered), (LocalQuickFix[])fixes.toArray((Object[])LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    private static String getBeansNotFoundMessage(@NotNull PsiType searchType) {
        PsiType secondarySearchType;
        if (searchType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(29);
        }
        return (secondarySearchType = SpringAutowireUtil.getIterableSearchType(searchType)) != null ? SpringBundle.message("bean.autowiring.by.type.no.beans", secondarySearchType.getPresentableText(), searchType.getPresentableText()) : SpringBundle.message("bean.autowiring.by.type.none", searchType.getPresentableText());
    }

    private static boolean isObjectFactory(@NotNull PsiType type) {
        if (type == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(30);
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            return psiClass != null && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.beans.factory.ObjectFactory");
        }
        return false;
    }

    private static boolean isInjectionPoint(@NotNull PsiType type) {
        if (type == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(31);
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            return psiClass != null && "org.springframework.beans.factory.InjectionPoint".equals(psiClass.getQualifiedName());
        }
        return false;
    }

    @NotNull
    private static String getErrorMessage(@NotNull PsiType beanType, Set<SpringBeanPointer> autowiredPointers) {
        if (beanType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(32);
        }
        SortedList sortedByNamePointers = new SortedList(Comparator.comparing(o -> (String)o.first));
        for (SpringBeanPointer pointer : autowiredPointers) {
            sortedByNamePointers.add(Pair.create((Object)SpringPresentationProvider.getSpringBeanName(pointer), (Object)SpringPresentationProvider.getSpringBeanLocation(pointer)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><table>");
        sb.append("<tr><td>");
        sb.append(SpringBundle.message("bean.class.autowired.by.type", beanType.getPresentableText()));
        sb.append("</td></tr>");
        sb.append("<tr><td>");
        sb.append("<table>");
        sb.append("<tr><td valign='top'>Beans:</td>");
        sb.append("<td>");
        for (Pair pair : sortedByNamePointers) {
            sb.append((String)pair.first);
            sb.append("&nbsp;&nbsp; (");
            sb.append((String)pair.second);
            sb.append(")<br>");
        }
        sb.append("</td></tr>");
        sb.append("</table>");
        sb.append("</td></tr>");
        sb.append("</table></html>");
        String string = sb.toString();
        if (string == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    private static Set<SpringBeanPointer> filterSelfReferencedBeans(@NotNull PsiElement psiNameIdentifierOwner, @NotNull Set<SpringBeanPointer> pointers) {
        PsiMethod psiMethod;
        if (psiNameIdentifierOwner == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(34);
        }
        if (pointers == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(35);
        }
        if ((psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiNameIdentifierOwner, PsiMethod.class)) == null) {
            Set<SpringBeanPointer> set = pointers;
            if (set == null) {
                SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(36);
            }
            return set;
        }
        LinkedHashSet filtered = ContainerUtil.newLinkedHashSet();
        for (SpringBeanPointer pointer : pointers) {
            if (psiMethod.equals(pointer.getSpringBean().getIdentifyingPsiElement())) continue;
            filtered.add(pointer);
        }
        LinkedHashSet linkedHashSet = filtered;
        if (linkedHashSet == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(37);
        }
        return linkedHashSet;
    }

    private static boolean isAllBeansInDifferentProfiles(@NotNull Set<SpringBeanPointer> pointers) {
        if (pointers == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(38);
        }
        Set names = ContainerUtil.newConcurrentSet();
        for (SpringBeanPointer pointer : pointers) {
            Object bean = pointer.getSpringBean();
            for (String profileName : bean.getProfile().getNames()) {
                if (names.contains(profileName)) {
                    return false;
                }
                names.add(profileName);
            }
        }
        return true;
    }

    private static boolean isNonDefinedActiveProfile(@Nullable Set<String> activeProfiles) {
        if (activeProfiles == null || activeProfiles.isEmpty()) {
            return true;
        }
        boolean isDefaultProfile = activeProfiles.size() == 1 && "_DEFAULT_PROFILE_NAME_".equals(activeProfiles.iterator().next());
        return !isDefaultProfile;
    }

    @NotNull
    private static Set<SpringBeanPointer> filterOverridenBeans(@NotNull Set<SpringBeanPointer> pointers) {
        if (pointers == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(39);
        }
        MultiMap names = new MultiMap();
        Set set = ContainerUtil.map2SetNotNull(pointers, pointer -> {
            boolean isOverriden = false;
            String name = pointer.getName();
            if (StringUtil.isNotEmpty((String)name)) {
                VirtualFile containingFile = pointer.getContainingFile().getVirtualFile();
                if (names.containsKey((Object)name) && !names.values().contains(containingFile)) {
                    isOverriden = true;
                }
                names.putValue((Object)name, (Object)containingFile);
            }
            return isOverriden ? null : pointer;
        });
        if (set == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(40);
        }
        return set;
    }

    @NotNull
    private static String getQualifierAnnotation(@Nullable PsiModifierListOwner psiModifierListOwner) {
        PsiMember psiMember;
        if (psiModifierListOwner != null && (psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiModifierListOwner, PsiMember.class, (boolean)false)) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"javax.inject.Inject", (int)1)) {
            if ("javax.inject.Named" == null) {
                SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(41);
            }
            return "javax.inject.Named";
        }
        if ("org.springframework.beans.factory.annotation.Qualifier" == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(42);
        }
        return "org.springframework.beans.factory.annotation.Qualifier";
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringJavaInjectionPointsAutowiringInspection" == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(43);
        }
        return "SpringJavaInjectionPointsAutowiringInspection";
    }

    private static Expression getQualifierNamesSuggestNamesExpression(final ULiteralExpression psiLiteral, final PsiLanguageInjectionHost host, final @NotNull Collection<SpringBeanPointer> beanPointers) {
        if (beanPointers == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(44);
        }
        return new Expression(){

            public Result calculateResult(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                return new TextResult(ElementManipulators.getValueText((PsiElement)host));
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                LinkedHashSet<LookupElement> items = new LinkedHashSet<LookupElement>();
                PsiClass psiAnnoClass = SpringUastInjectionPointsAutowiringInspection.findAnnoPsiClass(psiLiteral, host);
                for (SpringBeanPointer pointer : beanPointers) {
                    Object bean = pointer.getSpringBean();
                    if (psiAnnoClass == null) continue;
                    for (SpringQualifier qualifier : bean.getSpringQualifiers()) {
                        String value = qualifier.getQualifierValue();
                        if (value == null || !(qualifier instanceof DefaultSpringBeanQualifier) && !Comparing.equal((Object)qualifier.getQualifierType(), (Object)psiAnnoClass)) continue;
                        items.add(SpringConverterUtil.createCompletionVariant(pointer, value));
                    }
                }
                LookupElement[] elements = items.toArray(LookupElement.EMPTY_ARRAY);
                Arrays.sort(elements, Comparator.comparing(e -> e.getLookupString()));
                return elements;
            }
        };
    }

    @Nullable
    public static PsiClass findAnnoPsiClass(@NotNull ULiteralExpression expression, PsiLanguageInjectionHost host) {
        kotlin.Pair annotation;
        if (expression == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(45);
        }
        if ((annotation = UAnnotationUtils.getContainingAnnotationEntry((UElement)expression)) == null) {
            return null;
        }
        String qualifiedName = ((PsiAnnotation)annotation.component1()).getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
        if (module == null) {
            return null;
        }
        PsiElement sourcePsi = expression.getSourcePsi();
        if (sourcePsi == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(qualifiedName, sourcePsi.getResolveScope());
    }

    @NotNull
    private static String getBeanPointerName(@NotNull SpringBeanPointer beanPointer) {
        String name;
        if (beanPointer == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(46);
        }
        String string = StringUtil.isEmptyOrSpaces((String)(name = beanPointer.getName())) ? "Unknown" : name;
        if (string == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(47);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uField";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uDeclaration";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceAnnotation";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationMemberValue";
                break;
            }
            case 18: 
            case 21: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberEffectiveType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanType";
                break;
            }
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringInspection";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiNameIdentifierOwner";
                break;
            }
            case 35: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointers";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringInspection";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSelfReferencedBeans";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOverridenBeans";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAnnotation";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanPointerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkAutowiredMethodInjections";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceMethod";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkInjectionPoint";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceInjectionPoint";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkByNameAutowiring";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceBeanReference";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkQualifiedAutowiring";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "reportProblem";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkByTypeAutowire";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getBeansNotFoundMessage";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isObjectFactory";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isInjectionPoint";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: {
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "filterSelfReferencedBeans";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isAllBeansInDifferentProfiles";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "filterOverridenBeans";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierNamesSuggestNamesExpression";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findAnnoPsiClass";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getBeanPointerName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreateQualifierRequest
    implements AnnotationRequest {
        private final String myQualifierAnno;
        private final SmartPsiElementPointer<PsiModifierListOwner> myModifierListOwnerPointer;
        private final List<AnnotationAttributeRequest> myAttributeRequests;

        CreateQualifierRequest(PsiModifierListOwner psiElement, String qualifierAnno, String beanPointerName) {
            this.myQualifierAnno = qualifierAnno;
            this.myModifierListOwnerPointer = SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer((PsiElement)psiElement);
            this.myAttributeRequests = Collections.singletonList(AnnotationAttributeValueRequestKt.stringAttribute((String)"value", (String)beanPointerName));
        }

        @NotNull
        public String getQualifiedName() {
            String string = this.myQualifierAnno;
            if (string == null) {
                CreateQualifierRequest.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public List<AnnotationAttributeRequest> getAttributes() {
            List<AnnotationAttributeRequest> list = this.myAttributeRequests;
            if (list == null) {
                CreateQualifierRequest.$$$reportNull$$$0(1);
            }
            return list;
        }

        public boolean isValid() {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)this.myModifierListOwnerPointer.getElement();
            if (modifierListOwner == null || !modifierListOwner.isValid()) {
                return false;
            }
            return modifierListOwner.getModifierList() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringInspection$CreateQualifierRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiedName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class AddSpringBeanQualifierFix
    implements LocalQuickFix {
        private final UastSmartPointer<UDeclaration> myModifierListOwnerPointer;
        private final Collection<SpringBeanPointer> myBeanPointers;
        private final String myQualifierAnno;
        private final IntentionAction myCreateAnnotationAction;

        AddSpringBeanQualifierFix(@NotNull UDeclaration uDeclaration, @NotNull Collection<SpringBeanPointer> beanPointers, @NotNull String qualifierAnno, IntentionAction createAnnotationAction) {
            if (uDeclaration == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(0);
            }
            if (beanPointers == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(1);
            }
            if (qualifierAnno == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(2);
            }
            this.myModifierListOwnerPointer = new UastSmartPointer((UElement)uDeclaration, UDeclaration.class);
            this.myBeanPointers = beanPointers;
            this.myQualifierAnno = qualifierAnno;
            this.myCreateAnnotationAction = createAnnotationAction;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("SpringAutowiringInspection.add.qualifier.fix", new Object[0]);
            if (string == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            UDeclaration uDeclaration;
            if (project == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(5);
            }
            if ((uDeclaration = (UDeclaration)this.myModifierListOwnerPointer.getElement()) == null) {
                return;
            }
            PsiElement sourcePsi = uDeclaration.getSourcePsi();
            if (sourcePsi == null) {
                return;
            }
            if (this.myBeanPointers.size() > 0) {
                UExpression value;
                Editor editor = AddSpringBeanQualifierFix.getEditor(sourcePsi);
                this.myCreateAnnotationAction.invoke(project, editor, sourcePsi.getContainingFile());
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                UDeclaration modifiedDeclaration = (UDeclaration)this.myModifierListOwnerPointer.getElement();
                if (modifiedDeclaration == null) {
                    return;
                }
                UAnnotation annotation = modifiedDeclaration.findAnnotation(this.myQualifierAnno);
                if (annotation != null && (value = annotation.findDeclaredAttributeValue("value")) instanceof ULiteralExpression) {
                    TemplateManager manager = TemplateManager.getInstance((Project)project);
                    Template template = this.createQualifierNameTemplate((ULiteralExpression)value);
                    if (template != null) {
                        manager.startTemplate(editor, template);
                    }
                }
            }
        }

        @Nullable
        private Template createQualifierNameTemplate(@NotNull ULiteralExpression psiLiteral) {
            PsiElement sourcePsi;
            if (psiLiteral == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(6);
            }
            if ((sourcePsi = psiLiteral.getSourcePsi()) == null) {
                return null;
            }
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)sourcePsi.getContainingFile());
            PsiLanguageInjectionHost host = UastLiteralUtils.getPsiLanguageInjectionHost((ULiteralExpression)psiLiteral);
            if (host == null) {
                return null;
            }
            TextRange textRange = host.getTextRange();
            String valueText = ElementManipulators.getValueText((PsiElement)host);
            builder.replaceRange(TextRange.from((int)(textRange.getStartOffset() + 1), (int)valueText.length()), SpringUastInjectionPointsAutowiringInspection.getQualifierNamesSuggestNamesExpression(psiLiteral, host, this.myBeanPointers));
            return builder.buildInlineTemplate();
        }

        public static Editor getEditor(PsiElement modifierListOwner) {
            PsiFile psiFile = modifierListOwner.getContainingFile();
            Project project = psiFile.getProject();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            assert (virtualFile != null);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, 0), false);
            assert (editor != null);
            return editor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uDeclaration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beanPointers";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifierAnno";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringInspection$AddSpringBeanQualifierFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiLiteral";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringInspection$AddSpringBeanQualifierFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createQualifierNameTemplate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

