/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.config;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.config.ConfigureFileSetFix;
import com.intellij.spring.model.highlighting.config.CreateSpringFacetFix;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringFacetInspection
extends SpringBeanInspectionBase {
    public boolean checkTestFiles = false;

    @Override
    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        XmlFile xmlFile = domFileElement.getFile();
        if (SpringModelUtils.getInstance().isUsedConfigurationFile((PsiFile)xmlFile, this.checkTestFiles)) {
            return;
        }
        VirtualFile virtualFile = xmlFile.getVirtualFile();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)xmlFile.getProject());
        if (module == null) {
            return;
        }
        Object fix = SpringCommonUtils.hasSpringFacet(module) ? new ConfigureFileSetFix(module, virtualFile) : new CreateSpringFacetFix(module);
        holder.createProblem(domFileElement, HighlightSeverity.WARNING, SpringBundle.message("spring.facet.inspection.context.not.configured.for.file", new Object[0]), new LocalQuickFix[]{fix});
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(SpringBundle.message("spring.facet.inspection.check.test.files", new Object[0]), (InspectionProfileEntry)this, "checkTestFiles");
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringFacetInspection" == null) {
            SpringFacetInspection.$$$reportNull$$$0(0);
        }
        return "SpringFacetInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/config/SpringFacetInspection", "getShortName"));
    }
}

