/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpringJavaConfigInspection
extends AbstractBaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Module module;
        if (file == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(1);
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)file) && (SpringCommonUtils.hasSpringFacet(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) || SpringModelUtils.getInstance().hasAutoConfiguredModels(module))) {
            ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
            this.checkJavaFile((PsiJavaFile)file, holder, isOnTheFly, module);
            List problemDescriptors = holder.getResults();
            return problemDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return null;
    }

    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull Module module) {
        if (javaFile == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(3);
        }
        if (module == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(4);
        }
        for (PsiClass psiClass : javaFile.getClasses()) {
            this.checkClassInternal(psiClass, holder, module);
        }
    }

    private void checkClassInternal(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(5);
        }
        this.checkClass(aClass, holder, module);
        for (PsiClass psiClass : aClass.getInnerClasses()) {
            this.checkClass(psiClass, holder, module);
        }
    }

    protected abstract void checkClass(PsiClass var1, ProblemsHolder var2, @NotNull Module var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/jam/AbstractSpringJavaConfigInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkJavaFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassInternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

