/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PatternUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAntPatternPackageReferenceSet
extends PackageReferenceSet {
    public SpringAntPatternPackageReferenceSet(@NotNull String packageName, @NotNull PsiElement element, int startInElement, @NotNull GlobalSearchScope scope) {
        if (packageName == null) {
            SpringAntPatternPackageReferenceSet.$$$reportNull$$$0(0);
        }
        if (element == null) {
            SpringAntPatternPackageReferenceSet.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            SpringAntPatternPackageReferenceSet.$$$reportNull$$$0(2);
        }
        super(packageName, element, startInElement, scope);
    }

    @NotNull
    protected PsiPackageReference createReference(TextRange range, int index) {
        PsiPackageReference psiPackageReference = new PsiPackageReference(this, range, index){

            @NotNull
            protected ResolveResult[] doMultiResolve() {
                LinkedHashSet<PsiPackage> packages = new LinkedHashSet<PsiPackage>();
                for (PsiPackage parentPackage : this.getContext()) {
                    packages.addAll(this.resolvePackages(parentPackage));
                }
                ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(packages);
                if (resolveResultArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return resolveResultArray;
            }

            private Collection<PsiPackage> resolvePackages(@Nullable PsiPackage context) {
                PsiPackageReference parentContextReference;
                if (context == null) {
                    return Collections.emptySet();
                }
                String packageName = this.getValue();
                CommonProcessors.CollectProcessor<PsiPackage> processor = this.getProcessor(packageName);
                PsiPackageReference psiPackageReference = parentContextReference = this.myIndex > 0 ? (PsiPackageReference)this.getReferenceSet().getReference(this.myIndex - 1) : null;
                if (packageName.equals("*")) {
                    for (PsiPackage aPackage : context.getSubPackages(SpringAntPatternPackageReferenceSet.this.getResolveScope())) {
                        if (!processor.process((Object)aPackage)) break;
                    }
                    return processor.getResults();
                }
                if (parentContextReference != null && parentContextReference.getValue().equals("**")) {
                    return this.getSubPackages(context, processor, true);
                }
                if (packageName.equals("**")) {
                    if (this.isLastReference()) {
                        return this.getSubPackages(context, processor, false);
                    }
                    return Collections.singleton(context);
                }
                if (packageName.contains("*") || packageName.contains("?")) {
                    for (PsiPackage subPackage : context.getSubPackages(SpringAntPatternPackageReferenceSet.this.getResolveScope())) {
                        processor.process((Object)subPackage);
                    }
                    return processor.getResults();
                }
                return this.getReferenceSet().resolvePackageName(context, packageName);
            }

            private boolean isLastReference() {
                return ((Object)((Object)this)).equals(this.getReferenceSet().getLastReference());
            }

            @NotNull
            private CommonProcessors.CollectProcessor<PsiPackage> getProcessor(@NotNull String packageName) {
                if (packageName == null) {
                    1.$$$reportNull$$$0(1);
                }
                final Pattern pattern = PatternUtil.fromMask((String)packageName);
                CommonProcessors.CollectProcessor<PsiPackage> collectProcessor = new CommonProcessors.CollectProcessor<PsiPackage>(new LinkedHashSet()){

                    protected boolean accept(PsiPackage psiPackage) {
                        String name = psiPackage.getName();
                        return name != null && pattern.matcher(name).matches();
                    }
                };
                if (collectProcessor == null) {
                    1.$$$reportNull$$$0(2);
                }
                return collectProcessor;
            }

            @NotNull
            private Collection<PsiPackage> getSubPackages(@NotNull PsiPackage context, CommonProcessors.CollectProcessor<PsiPackage> processor, boolean deep) {
                if (context == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.processSubPackages(context, processor, deep);
                Collection collection = processor.getResults();
                if (collection == null) {
                    1.$$$reportNull$$$0(4);
                }
                return collection;
            }

            private void processSubPackages(PsiPackage psiPackage, CommonProcessors.CollectProcessor<PsiPackage> processor, boolean deep) {
                for (PsiPackage subPackage : psiPackage.getSubPackages(SpringAntPatternPackageReferenceSet.this.getResolveScope())) {
                    processor.process((Object)subPackage);
                    if (!deep) continue;
                    this.processSubPackages(subPackage, processor, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "packageName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doMultiResolve";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProcessor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubPackages";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getProcessor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getSubPackages";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (psiPackageReference == null) {
            SpringAntPatternPackageReferenceSet.$$$reportNull$$$0(3);
        }
        return psiPackageReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

